/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.numeric;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.Coercible;
import ai.timefold.jpyinterpreter.types.NotImplemented;
import ai.timefold.jpyinterpreter.types.PythonLikeComparable;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.arithmetic.ZeroDivisionError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.types.numeric.PythonNumber;
import ai.timefold.jpyinterpreter.util.DefaultFormatSpec;
import ai.timefold.jpyinterpreter.util.StringFormatter;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningImmutable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Map;

public class PythonFloat
extends AbstractPythonLikeObject
implements PythonNumber,
PlanningImmutable,
Coercible {
    public final double value;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        PythonLikeComparable.setup(BuiltinTypes.FLOAT_TYPE);
        BuiltinTypes.FLOAT_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.isEmpty()) {
                return new PythonFloat(0.0);
            }
            if (positionalArguments.size() == 1) {
                return PythonFloat.from((PythonLikeObject)positionalArguments.get(0));
            }
            throw new ValueError("float takes 0 or 1 arguments, got " + positionalArguments.size());
        });
        BuiltinTypes.FLOAT_TYPE.addUnaryMethod(PythonUnaryOperator.AS_BOOLEAN, PythonFloat.class.getMethod("asBoolean", new Class[0]));
        BuiltinTypes.FLOAT_TYPE.addUnaryMethod(PythonUnaryOperator.AS_INT, PythonFloat.class.getMethod("asInteger", new Class[0]));
        BuiltinTypes.FLOAT_TYPE.addUnaryMethod(PythonUnaryOperator.POSITIVE, PythonFloat.class.getMethod("asFloat", new Class[0]));
        BuiltinTypes.FLOAT_TYPE.addUnaryMethod(PythonUnaryOperator.NEGATIVE, PythonFloat.class.getMethod("negative", new Class[0]));
        BuiltinTypes.FLOAT_TYPE.addUnaryMethod(PythonUnaryOperator.ABS, PythonFloat.class.getMethod("abs", new Class[0]));
        BuiltinTypes.FLOAT_TYPE.addUnaryMethod(PythonUnaryOperator.HASH, PythonFloat.class.getMethod("$method$__hash__", new Class[0]));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.ADD, PythonFloat.class.getMethod("add", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.ADD, PythonFloat.class.getMethod("add", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.ADD, PythonFloat.class.getMethod("add", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.SUBTRACT, PythonFloat.class.getMethod("subtract", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.SUBTRACT, PythonFloat.class.getMethod("subtract", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.SUBTRACT, PythonFloat.class.getMethod("subtract", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonFloat.class.getMethod("multiply", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonFloat.class.getMethod("multiply", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonFloat.class.getMethod("multiply", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.TRUE_DIVIDE, PythonFloat.class.getMethod("trueDivide", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.TRUE_DIVIDE, PythonFloat.class.getMethod("trueDivide", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.TRUE_DIVIDE, PythonFloat.class.getMethod("trueDivide", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.FLOOR_DIVIDE, PythonFloat.class.getMethod("floorDivide", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.FLOOR_DIVIDE, PythonFloat.class.getMethod("floorDivide", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.FLOOR_DIVIDE, PythonFloat.class.getMethod("floorDivide", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.DIVMOD, PythonFloat.class.getMethod("divmod", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.DIVMOD, PythonFloat.class.getMethod("divmod", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.DIVMOD, PythonFloat.class.getMethod("divmod", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.MODULO, PythonFloat.class.getMethod("modulo", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.MODULO, PythonFloat.class.getMethod("modulo", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.MODULO, PythonFloat.class.getMethod("modulo", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.POWER, PythonFloat.class.getMethod("power", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.POWER, PythonFloat.class.getMethod("power", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.POWER, PythonFloat.class.getMethod("power", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.EQUAL, PythonFloat.class.getMethod("pythonEquals", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.EQUAL, PythonFloat.class.getMethod("pythonEquals", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.EQUAL, PythonFloat.class.getMethod("pythonEquals", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.NOT_EQUAL, PythonFloat.class.getMethod("notEqual", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.NOT_EQUAL, PythonFloat.class.getMethod("notEqual", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.NOT_EQUAL, PythonFloat.class.getMethod("notEqual", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.LESS_THAN, PythonFloat.class.getMethod("lessThan", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.LESS_THAN, PythonFloat.class.getMethod("lessThan", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.LESS_THAN, PythonFloat.class.getMethod("lessThan", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.LESS_THAN_OR_EQUAL, PythonFloat.class.getMethod("lessThanOrEqual", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.LESS_THAN_OR_EQUAL, PythonFloat.class.getMethod("lessThanOrEqual", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.LESS_THAN_OR_EQUAL, PythonFloat.class.getMethod("lessThanOrEqual", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.GREATER_THAN, PythonFloat.class.getMethod("greaterThan", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.GREATER_THAN, PythonFloat.class.getMethod("greaterThan", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.GREATER_THAN, PythonFloat.class.getMethod("greaterThan", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.GREATER_THAN_OR_EQUAL, PythonFloat.class.getMethod("greaterThanOrEqual", PythonLikeObject.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.GREATER_THAN_OR_EQUAL, PythonFloat.class.getMethod("greaterThanOrEqual", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addLeftBinaryMethod(PythonBinaryOperator.GREATER_THAN_OR_EQUAL, PythonFloat.class.getMethod("greaterThanOrEqual", PythonFloat.class));
        BuiltinTypes.FLOAT_TYPE.addMethod("__round__", PythonFloat.class.getMethod("round", new Class[0]));
        BuiltinTypes.FLOAT_TYPE.addMethod("__round__", PythonFloat.class.getMethod("round", PythonInteger.class));
        BuiltinTypes.FLOAT_TYPE.addBinaryMethod(PythonBinaryOperator.FORMAT, PythonFloat.class.getMethod("$method$__format__", new Class[0]));
        BuiltinTypes.FLOAT_TYPE.addBinaryMethod(PythonBinaryOperator.FORMAT, PythonFloat.class.getMethod("$method$__format__", PythonLikeObject.class));
        return BuiltinTypes.FLOAT_TYPE;
    }

    public PythonFloat(double value) {
        super(BuiltinTypes.FLOAT_TYPE);
        this.value = value;
    }

    public static PythonFloat from(PythonLikeObject value) {
        if (value instanceof PythonInteger) {
            PythonInteger integer = (PythonInteger)value;
            return integer.asFloat();
        }
        if (value instanceof PythonFloat) {
            return (PythonFloat)value;
        }
        if (value instanceof PythonString) {
            PythonString str = (PythonString)value;
            try {
                String literal = switch (str.value.toLowerCase()) {
                    case "nan", "+nan" -> "+NaN";
                    case "-nan" -> "-NaN";
                    case "inf", "+inf", "infinity" -> "+Infinity";
                    case "-inf", "-infinity" -> "-Infinity";
                    default -> str.value;
                };
                return new PythonFloat(Double.parseDouble(literal));
            }
            catch (NumberFormatException e) {
                throw new ValueError("invalid literal for float(): %s".formatted(value));
            }
        }
        PythonLikeType valueType = value.$getType();
        PythonLikeFunction asFloatFunction = (PythonLikeFunction)valueType.$getAttributeOrError("__float__");
        return (PythonFloat)asFloatFunction.$call(List.of(value), Map.of(), null);
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public PythonLikeTuple asFraction() {
        BigInteger denominator;
        BigInteger FIVE = BigInteger.valueOf(5L);
        BigDecimal bigDecimal = new BigDecimal(this.value);
        BigInteger numerator = bigDecimal.movePointRight(bigDecimal.scale()).toBigIntegerExact();
        if (bigDecimal.scale() < 0) {
            denominator = BigInteger.ONE;
            numerator = numerator.multiply(BigInteger.TEN.pow(-bigDecimal.scale()));
        } else {
            denominator = BigInteger.TEN.pow(bigDecimal.scale());
        }
        while (denominator.remainder(BigInteger.TWO).equals(BigInteger.ZERO) && numerator.remainder(BigInteger.TWO).equals(BigInteger.ZERO)) {
            denominator = denominator.shiftRight(1);
            numerator = numerator.shiftRight(1);
        }
        while (denominator.remainder(FIVE).equals(BigInteger.ZERO) && numerator.remainder(FIVE).equals(BigInteger.ZERO)) {
            denominator = denominator.divide(FIVE);
            numerator = numerator.divide(FIVE);
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonInteger[]{PythonInteger.valueOf(numerator), PythonInteger.valueOf(denominator)});
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    public boolean equals(Object o) {
        if (o instanceof Number) {
            Number number = (Number)o;
            return number.doubleValue() == this.value;
        }
        if (o instanceof PythonNumber) {
            PythonNumber number = (PythonNumber)o;
            return this.compareTo(number) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.$method$__hash__().value.intValue();
    }

    @Override
    public PythonInteger $method$__hash__() {
        if (Double.isNaN(this.value)) {
            return PythonInteger.valueOf(this.hashCode());
        }
        if (Double.isInfinite(this.value)) {
            if (this.value > 0.0) {
                return INFINITY_HASH_VALUE;
            }
            return INFINITY_HASH_VALUE.negative();
        }
        PythonLikeTuple fractionTuple = this.asFraction();
        return PythonNumber.computeHash((PythonInteger)fractionTuple.get(0), (PythonInteger)fractionTuple.get(1));
    }

    public static PythonFloat valueOf(float value) {
        return new PythonFloat(value);
    }

    public static PythonFloat valueOf(double value) {
        return new PythonFloat(value);
    }

    public PythonBoolean asBoolean() {
        return this.value == 0.0 ? PythonBoolean.FALSE : PythonBoolean.TRUE;
    }

    public PythonInteger asInteger() {
        return new PythonInteger((long)Math.floor(this.value));
    }

    public PythonFloat asFloat() {
        return this;
    }

    public PythonFloat negative() {
        return new PythonFloat(-this.value);
    }

    public PythonFloat abs() {
        return new PythonFloat(Math.abs(this.value));
    }

    public PythonLikeObject add(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.add((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.add((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonFloat add(PythonInteger other) {
        return new PythonFloat(this.value + other.value.doubleValue());
    }

    public PythonFloat add(PythonFloat other) {
        return new PythonFloat(this.value + other.value);
    }

    public PythonLikeObject subtract(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.subtract((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.subtract((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonFloat subtract(PythonInteger other) {
        return new PythonFloat(this.value - other.value.doubleValue());
    }

    public PythonFloat subtract(PythonFloat other) {
        return new PythonFloat(this.value - other.value);
    }

    public PythonLikeObject multiply(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.multiply((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.multiply((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonFloat multiply(PythonInteger other) {
        return new PythonFloat(this.value * other.value.doubleValue());
    }

    public PythonFloat multiply(PythonFloat other) {
        return new PythonFloat(this.value * other.value);
    }

    public PythonLikeObject trueDivide(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.trueDivide((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.trueDivide((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonFloat trueDivide(PythonInteger other) {
        if (other.value.equals(BigInteger.ZERO)) {
            throw new ZeroDivisionError("float division");
        }
        return new PythonFloat(this.value / other.value.doubleValue());
    }

    public PythonFloat trueDivide(PythonFloat other) {
        if (other.value == 0.0) {
            throw new ZeroDivisionError("float division");
        }
        return new PythonFloat(this.value / other.value);
    }

    public PythonLikeObject floorDivide(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.floorDivide((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.floorDivide((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonFloat floorDivide(PythonInteger other) {
        if (other.value.equals(BigInteger.ZERO)) {
            throw new ZeroDivisionError("float division");
        }
        return new PythonFloat(new BigDecimal(this.value).divideToIntegralValue(new BigDecimal(other.value)).doubleValue());
    }

    public PythonFloat floorDivide(PythonFloat other) {
        if (other.value == 0.0) {
            throw new ZeroDivisionError("float division");
        }
        return PythonFloat.valueOf(Math.floor(this.value / other.value));
    }

    public PythonFloat ceilDivide(PythonInteger other) {
        if (other.value.equals(BigInteger.ZERO)) {
            throw new ZeroDivisionError("float division");
        }
        return new PythonFloat(new BigDecimal(this.value).divide(new BigDecimal(other.value), RoundingMode.CEILING).doubleValue());
    }

    public PythonFloat ceilDivide(PythonFloat other) {
        if (other.value == 0.0) {
            throw new ZeroDivisionError("float division");
        }
        return PythonFloat.valueOf(Math.ceil(this.value / other.value));
    }

    public PythonLikeObject modulo(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.modulo((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.modulo((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonFloat modulo(PythonInteger other) {
        int remainderSign = other.compareTo(PythonInteger.ZERO);
        if (remainderSign == 0) {
            throw new ZeroDivisionError("float modulo");
        }
        if (remainderSign > 0) {
            double remainder = this.value % other.value.doubleValue();
            if (remainder < 0.0) {
                remainder += other.value.doubleValue();
            }
            return new PythonFloat(remainder);
        }
        double remainder = this.value % other.value.doubleValue();
        if (remainder > 0.0) {
            remainder += other.value.doubleValue();
        }
        return new PythonFloat(remainder);
    }

    public PythonFloat modulo(PythonFloat other) {
        if (other.value == 0.0) {
            throw new ZeroDivisionError("float modulo");
        }
        if (other.value > 0.0) {
            double remainder = this.value % other.value;
            if (remainder < 0.0) {
                remainder += other.value;
            }
            return new PythonFloat(remainder);
        }
        double remainder = this.value % other.value;
        if (remainder > 0.0) {
            remainder += other.value;
        }
        return new PythonFloat(remainder);
    }

    public PythonLikeObject divmod(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.divmod((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.divmod((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonLikeTuple divmod(PythonInteger other) {
        PythonFloat quotient = this.value < 0.0 == other.value.compareTo(BigInteger.ZERO) < 0 ? this.floorDivide(other) : this.ceilDivide(other);
        PythonInteger.valueOf(Math.round(this.value / other.value.doubleValue()));
        double remainder = this.value % other.value.doubleValue();
        if (other.value.compareTo(BigInteger.ZERO) < 0) {
            if (remainder > 0.0) {
                quotient = quotient.subtract(PythonInteger.ONE);
                remainder += other.value.doubleValue();
            }
        } else if (remainder < 0.0) {
            quotient = quotient.subtract(PythonInteger.ONE);
            remainder += other.value.doubleValue();
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonFloat[]{quotient, new PythonFloat(remainder)});
    }

    public PythonLikeTuple divmod(PythonFloat other) {
        PythonFloat quotient = this.value < 0.0 == other.value < 0.0 ? this.floorDivide(other) : this.ceilDivide(other);
        double remainder = this.value % other.value;
        if (other.value < 0.0) {
            if (remainder > 0.0) {
                quotient = quotient.subtract(PythonInteger.ONE);
                remainder += other.value;
            }
        } else if (remainder < 0.0) {
            quotient = quotient.subtract(PythonInteger.ONE);
            remainder += other.value;
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonFloat[]{quotient, new PythonFloat(remainder)});
    }

    public PythonInteger round() {
        if (this.value % 1.0 == 0.5) {
            long floor = (long)Math.floor(this.value);
            if (floor % 2L == 0L) {
                return PythonInteger.valueOf(floor);
            }
            return PythonInteger.valueOf(floor + 1L);
        }
        return PythonInteger.valueOf(Math.round(this.value));
    }

    public PythonNumber round(PythonInteger digitsAfterDecimal) {
        if (digitsAfterDecimal.equals(PythonInteger.ZERO)) {
            return this.round();
        }
        BigDecimal asDecimal = new BigDecimal(this.value);
        return new PythonFloat(asDecimal.setScale(digitsAfterDecimal.value.intValueExact(), RoundingMode.HALF_EVEN).doubleValue());
    }

    public PythonLikeObject power(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.power((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.power((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonFloat power(PythonInteger other) {
        return new PythonFloat(Math.pow(this.value, other.value.doubleValue()));
    }

    public PythonFloat power(PythonFloat other) {
        return new PythonFloat(Math.pow(this.value, other.value));
    }

    public PythonLikeObject pythonEquals(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.pythonEquals((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.pythonEquals((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonLikeObject notEqual(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.notEqual((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.notEqual((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonLikeObject lessThan(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.lessThan((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.lessThan((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonLikeObject greaterThan(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.greaterThan((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.greaterThan((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonLikeObject lessThanOrEqual(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.lessThanOrEqual((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.lessThanOrEqual((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonLikeObject greaterThanOrEqual(PythonLikeObject other) {
        if (other instanceof PythonInteger) {
            return this.greaterThanOrEqual((PythonInteger)other);
        }
        if (other instanceof PythonFloat) {
            return this.greaterThanOrEqual((PythonFloat)other);
        }
        return NotImplemented.INSTANCE;
    }

    public PythonBoolean pythonEquals(PythonInteger other) {
        return PythonBoolean.valueOf(this.value == other.value.doubleValue());
    }

    public PythonBoolean notEqual(PythonInteger other) {
        return PythonBoolean.valueOf(this.value != other.value.doubleValue());
    }

    @Override
    public PythonBoolean lessThan(PythonInteger other) {
        return PythonBoolean.valueOf(this.value < other.value.doubleValue());
    }

    @Override
    public PythonBoolean lessThanOrEqual(PythonInteger other) {
        return PythonBoolean.valueOf(this.value <= other.value.doubleValue());
    }

    @Override
    public PythonBoolean greaterThan(PythonInteger other) {
        return PythonBoolean.valueOf(this.value > other.value.doubleValue());
    }

    @Override
    public PythonBoolean greaterThanOrEqual(PythonInteger other) {
        return PythonBoolean.valueOf(this.value >= other.value.doubleValue());
    }

    public PythonBoolean pythonEquals(PythonFloat other) {
        return PythonBoolean.valueOf(this.value == other.value);
    }

    public PythonBoolean notEqual(PythonFloat other) {
        return PythonBoolean.valueOf(this.value != other.value);
    }

    @Override
    public PythonBoolean lessThan(PythonFloat other) {
        return PythonBoolean.valueOf(this.value < other.value);
    }

    @Override
    public PythonBoolean lessThanOrEqual(PythonFloat other) {
        return PythonBoolean.valueOf(this.value <= other.value);
    }

    @Override
    public PythonBoolean greaterThan(PythonFloat other) {
        return PythonBoolean.valueOf(this.value > other.value);
    }

    @Override
    public PythonBoolean greaterThanOrEqual(PythonFloat other) {
        return PythonBoolean.valueOf(this.value >= other.value);
    }

    public PythonString format() {
        return PythonString.valueOf(Double.toString(this.value));
    }

    /*
     * Unable to fully structure code
     */
    private DecimalFormat getNumberFormat(DefaultFormatSpec formatSpec) {
        numberFormat = new DecimalFormat();
        symbols = new DecimalFormatSymbols();
        isUppercase = false;
        switch (1.$SwitchMap$ai$timefold$jpyinterpreter$util$DefaultFormatSpec$ConversionType[formatSpec.conversionType.orElse(DefaultFormatSpec.ConversionType.LOWERCASE_GENERAL).ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                isUppercase = true;
            }
        }
        if (isUppercase) {
            symbols.setExponentSeparator("E");
            symbols.setInfinity("INF");
            symbols.setNaN("NAN");
        } else {
            symbols.setExponentSeparator("e");
            symbols.setInfinity("inf");
            symbols.setNaN("nan");
        }
        if (formatSpec.groupingOption.isPresent()) {
            switch (1.$SwitchMap$ai$timefold$jpyinterpreter$util$DefaultFormatSpec$GroupingOption[formatSpec.groupingOption.get().ordinal()]) {
                case 1: {
                    symbols.setGroupingSeparator(',');
                    break;
                }
                case 2: {
                    symbols.setGroupingSeparator('_');
                }
            }
        }
        if (formatSpec.conversionType.orElse(null) == DefaultFormatSpec.ConversionType.LOCALE_SENSITIVE) {
            symbols.setGroupingSeparator(DecimalFormatSymbols.getInstance().getGroupingSeparator());
        }
        numberFormat.setDecimalFormatSymbols(symbols);
        switch (1.$SwitchMap$ai$timefold$jpyinterpreter$util$DefaultFormatSpec$ConversionType[formatSpec.conversionType.orElse(DefaultFormatSpec.ConversionType.LOWERCASE_GENERAL).ordinal()]) {
            case 2: 
            case 4: {
                numberFormat.applyPattern("0." + "#".repeat(formatSpec.getPrecisionOrDefault()) + "E00");
                break;
            }
            case 3: 
            case 5: {
                if (formatSpec.groupingOption.isPresent()) {
                    numberFormat.applyPattern("#,##0." + "0".repeat(formatSpec.getPrecisionOrDefault()));
                    break;
                }
                numberFormat.applyPattern("0." + "0".repeat(formatSpec.getPrecisionOrDefault()));
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                asBigDecimal = new BigDecimal(this.value);
                exponent = asBigDecimal.precision() == asBigDecimal.scale() + 1 ? -asBigDecimal.scale() : asBigDecimal.precision() - asBigDecimal.scale() - 1;
                if (-4 >= exponent && exponent < formatSpec.getPrecisionOrDefault()) ** GOTO lbl44
                if (formatSpec.conversionType.isEmpty()) {
                    numberFormat.applyPattern("0.0" + "#".repeat(formatSpec.getPrecisionOrDefault() - 1) + "E00");
                } else {
                    numberFormat.applyPattern("0." + "#".repeat(formatSpec.getPrecisionOrDefault()) + "E00");
                }
                ** GOTO lbl54
lbl44:
                // 1 sources

                if (!formatSpec.groupingOption.isPresent() && formatSpec.conversionType.orElse(null) != DefaultFormatSpec.ConversionType.LOCALE_SENSITIVE) ** GOTO lbl50
                if (formatSpec.conversionType.isEmpty()) {
                    numberFormat.applyPattern("#,##0.0" + "#".repeat(formatSpec.getPrecisionOrDefault() - 1));
                } else {
                    numberFormat.applyPattern("#,##0." + "#".repeat(formatSpec.getPrecisionOrDefault()));
                }
                ** GOTO lbl54
lbl50:
                // 1 sources

                if (formatSpec.conversionType.isEmpty()) {
                    numberFormat.applyPattern("0.0" + "#".repeat(formatSpec.getPrecisionOrDefault() - 1));
                } else {
                    numberFormat.applyPattern("0." + "#".repeat(formatSpec.getPrecisionOrDefault()));
                }
            }
lbl54:
            // 7 sources

            case 8: {
                if (formatSpec.groupingOption.isPresent()) {
                    numberFormat.applyPattern("#,##0." + "0".repeat(formatSpec.getPrecisionOrDefault()) + "%");
                    break;
                }
                numberFormat.applyPattern("0." + "0".repeat(formatSpec.getPrecisionOrDefault()) + "%");
                break;
            }
            default: {
                throw new ValueError("Invalid conversion for float type: " + formatSpec.conversionType);
            }
        }
        switch (1.$SwitchMap$ai$timefold$jpyinterpreter$util$DefaultFormatSpec$SignOption[formatSpec.signOption.orElse(DefaultFormatSpec.SignOption.ONLY_NEGATIVE_NUMBERS).ordinal()]) {
            case 1: {
                numberFormat.setPositivePrefix("+");
                numberFormat.setNegativePrefix("-");
                break;
            }
            case 2: {
                numberFormat.setPositivePrefix("");
                numberFormat.setNegativePrefix("-");
                break;
            }
            case 3: {
                numberFormat.setPositivePrefix(" ");
                numberFormat.setNegativePrefix("-");
            }
        }
        numberFormat.setRoundingMode(RoundingMode.HALF_EVEN);
        numberFormat.setDecimalSeparatorAlwaysShown(formatSpec.useAlternateForm);
        return numberFormat;
    }

    @Override
    public PythonString $method$__format__(PythonLikeObject specObject) {
        PythonString spec;
        if (specObject == PythonNone.INSTANCE) {
            spec = PythonString.EMPTY;
        } else if (specObject instanceof PythonString) {
            spec = (PythonString)specObject;
        } else {
            throw new TypeError("__format__ argument 0 has incorrect type (expecting str or None)");
        }
        DefaultFormatSpec formatSpec = DefaultFormatSpec.fromSpec(spec);
        StringBuilder out = new StringBuilder();
        DecimalFormat numberFormat = this.getNumberFormat(formatSpec);
        out.append(numberFormat.format(this.value));
        StringFormatter.align(out, formatSpec, DefaultFormatSpec.AlignmentOption.RIGHT_ALIGN);
        return PythonString.valueOf(out.toString());
    }

    @Override
    public <T> T coerce(Class<T> targetType) {
        if (targetType.equals(PythonInteger.class)) {
            return (T)PythonInteger.valueOf((long)this.value);
        }
        return null;
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonFloat::registerMethods);
    }
}

