/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.wrappers;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.errors.AttributeError;
import ai.timefold.jpyinterpreter.types.errors.RuntimeError;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.types.wrappers.JavaMethodReference;
import ai.timefold.jpyinterpreter.types.wrappers.MultiDispatchJavaMethodReference;
import ai.timefold.jpyinterpreter.types.wrappers.WrappingJavaObjectIterator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JavaObjectWrapper
implements PythonLikeObject,
Iterable<JavaObjectWrapper>,
Comparable<JavaObjectWrapper> {
    static final Map<Class<?>, PythonLikeType> classToPythonTypeMap = new HashMap();
    static final Map<Class<?>, Map<String, Field>> classToAttributeNameToMemberListMap = new HashMap();
    private final PythonLikeType type;
    private final Object wrappedObject;
    private final Class<?> objectClass;
    private final Map<String, Field> attributeNameToMemberListMap;
    private final Map<Object, PythonLikeObject> convertedObjectMap;

    private static Map<String, Field> getAllFields(Class<?> baseClass) {
        return JavaObjectWrapper.getAllDeclaredMembers(baseClass).stream().filter(member -> member instanceof Field && !Modifier.isStatic(member.getModifiers())).collect(Collectors.toMap(Member::getName, member -> (Field)member, (oldMember, newMember) -> {
            if (oldMember.getDeclaringClass().isAssignableFrom(newMember.getDeclaringClass())) {
                return newMember;
            }
            return oldMember;
        }));
    }

    private static List<Member> getAllDeclaredMembers(Class<?> baseClass) {
        Class<?> clazz = baseClass;
        ArrayList<Member> members = new ArrayList<Member>();
        members.addAll(Arrays.asList(clazz.getFields()));
        members.addAll(Arrays.asList(clazz.getMethods()));
        return members;
    }

    private Method getGetterMethod(Field field) {
        Object getterName;
        if (this.objectClass.isRecord()) {
            getterName = field.getName();
        } else {
            String propertyName = field.getName();
            String capitalizedName = propertyName.isEmpty() ? "" : propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            getterName = (field.getType().equals(Boolean.TYPE) ? "is" : "get") + capitalizedName;
        }
        PythonLikeObject object = this.type.$getAttributeOrNull((String)getterName);
        if (object instanceof JavaMethodReference) {
            JavaMethodReference methodReference = (JavaMethodReference)object;
            return methodReference.getMethod();
        }
        if (object instanceof MultiDispatchJavaMethodReference) {
            MultiDispatchJavaMethodReference multiDispatchJavaMethodReference = (MultiDispatchJavaMethodReference)object;
            return multiDispatchJavaMethodReference.getNoArgsMethod();
        }
        throw new AttributeError("Cannot get attribute (%s) on class (%s).".formatted(field.getName(), this.type));
    }

    private Method getSetterMethod(Field field) {
        String propertyName = field.getName();
        Object capitalizedName = propertyName.isEmpty() ? "" : propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String setterName = "set" + (String)capitalizedName;
        PythonLikeObject object = this.type.$getAttributeOrNull(setterName);
        if (object instanceof JavaMethodReference) {
            JavaMethodReference methodReference = (JavaMethodReference)object;
            return methodReference.getMethod();
        }
        throw new AttributeError("Cannot set attribute (%s) on class (%s).".formatted(field.getName(), this.type));
    }

    public JavaObjectWrapper(Object wrappedObject) {
        this(wrappedObject, new IdentityHashMap<Object, PythonLikeObject>());
    }

    public JavaObjectWrapper(Object wrappedObject, Map<Object, PythonLikeObject> convertedObjectMap) {
        convertedObjectMap.put(wrappedObject, this);
        this.wrappedObject = wrappedObject;
        this.objectClass = wrappedObject.getClass();
        this.convertedObjectMap = convertedObjectMap;
        this.attributeNameToMemberListMap = classToAttributeNameToMemberListMap.computeIfAbsent(this.objectClass, JavaObjectWrapper::getAllFields);
        this.type = JavaObjectWrapper.getPythonTypeForClass(this.objectClass, convertedObjectMap);
    }

    public static PythonLikeType getPythonTypeForClass(Class<?> objectClass) {
        return JavaObjectWrapper.getPythonTypeForClass(objectClass, new IdentityHashMap<Object, PythonLikeObject>());
    }

    public static PythonLikeType getPythonTypeForClass(Class<?> objectClass, Map<Object, PythonLikeObject> convertedObjectMap) {
        if (classToPythonTypeMap.containsKey(objectClass)) {
            return classToPythonTypeMap.get(objectClass);
        }
        PythonLikeType out = JavaObjectWrapper.generatePythonTypeForClass(objectClass, convertedObjectMap);
        classToPythonTypeMap.put(objectClass, out);
        return out;
    }

    private static boolean isInaccessible(Member member) {
        return JavaObjectWrapper.isInaccessible(member.getDeclaringClass());
    }

    private static boolean isInaccessible(Class<?> clazz) {
        for (Class<?> declaringClass = clazz; declaringClass != null; declaringClass = declaringClass.getDeclaringClass()) {
            if (Modifier.isPublic(declaringClass.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private static Method findMethodInInterfaces(Class<?> declaringClass, Method method) {
        ArrayDeque toVisit = new ArrayDeque();
        while (declaringClass != null) {
            toVisit.addAll(List.of(declaringClass.getInterfaces()));
            declaringClass = declaringClass.getSuperclass();
        }
        HashSet<Class> visited = new HashSet<Class>();
        while (!toVisit.isEmpty()) {
            Class interfaceClass = (Class)toVisit.poll();
            if (visited.contains(interfaceClass)) continue;
            visited.add(interfaceClass);
            toVisit.addAll(Arrays.asList(interfaceClass.getInterfaces()));
            if (JavaObjectWrapper.isInaccessible(interfaceClass)) continue;
            try {
                return interfaceClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    private static void addMemberToPythonType(PythonLikeType type, Member member, Map<Object, PythonLikeObject> convertedObjectMap) {
        if (member instanceof Method) {
            Method method = (Method)member;
            if (JavaObjectWrapper.isInaccessible(member) && (method = JavaObjectWrapper.findMethodInInterfaces(method.getDeclaringClass(), method)) == null) {
                return;
            }
            switch (method.getName()) {
                case "size": {
                    if (!Collection.class.isAssignableFrom(method.getDeclaringClass())) break;
                    type.__dir__.put(PythonUnaryOperator.LENGTH.getDunderMethod(), new JavaMethodReference(method, Map.of()));
                    break;
                }
                case "contains": {
                    if (!Collection.class.isAssignableFrom(method.getDeclaringClass())) break;
                    type.__dir__.put(PythonBinaryOperator.CONTAINS.getDunderMethod(), new JavaMethodReference(method, Map.of()));
                    break;
                }
                case "get": {
                    type.__dir__.put(PythonBinaryOperator.GET_ITEM.getDunderMethod(), new JavaMethodReference(method, Map.of()));
                }
            }
            ((MultiDispatchJavaMethodReference)type.__dir__.computeIfAbsent(method.getName(), name -> new MultiDispatchJavaMethodReference())).addMethod(method);
        } else {
            if (JavaObjectWrapper.isInaccessible(member)) {
                return;
            }
            Field field = (Field)member;
            if (Modifier.isPublic(field.getModifiers())) {
                try {
                    type.__dir__.put(field.getName(), JavaPythonTypeConversionImplementor.wrapJavaObject(field.get(null), convertedObjectMap));
                }
                catch (IllegalAccessException e) {
                    throw (RuntimeError)new RuntimeError("Cannot get attribute (%s) on type (%s).".formatted(field.getName(), type.getTypeName())).initCause(e);
                }
            }
        }
    }

    private static PythonLikeType generatePythonTypeForClass(Class<?> objectClass, Map<Object, PythonLikeObject> convertedObjectMap) {
        PythonLikeType out = new PythonLikeType(objectClass.getName(), JavaObjectWrapper.class, objectClass);
        JavaObjectWrapper.getAllDeclaredMembers(objectClass).stream().filter(member -> Modifier.isStatic(member.getModifiers()) || member instanceof Method).forEach(member -> JavaObjectWrapper.addMemberToPythonType(out, member, convertedObjectMap));
        return out;
    }

    public Object getWrappedObject() {
        return this.wrappedObject;
    }

    @Override
    public PythonLikeObject $getAttributeOrNull(String attributeName) {
        Field field = this.attributeNameToMemberListMap.get(attributeName);
        if (field == null) {
            return null;
        }
        try {
            Object result;
            if (Modifier.isPublic(field.getModifiers())) {
                result = field.get(this.wrappedObject);
            } else {
                Method getterMethod = this.getGetterMethod(field);
                result = getterMethod.invoke(this.wrappedObject, new Object[0]);
            }
            return JavaPythonTypeConversionImplementor.wrapJavaObject(result, this.convertedObjectMap);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw (RuntimeError)new RuntimeError("Cannot get attribute (%s) on object (%s).".formatted(attributeName, this)).initCause(e);
        }
    }

    @Override
    public void $setAttribute(String attributeName, PythonLikeObject value) {
        Field field = this.attributeNameToMemberListMap.get(attributeName);
        if (field == null) {
            throw new AttributeError("(%s) object does not have attribute (%s).".formatted(this.type, attributeName));
        }
        try {
            Object javaObject = JavaPythonTypeConversionImplementor.convertPythonObjectToJavaType(field.getType(), value);
            if (Modifier.isPublic(field.getModifiers())) {
                field.set(this.wrappedObject, javaObject);
            } else {
                Method setterMethod = this.getSetterMethod(field);
                setterMethod.invoke(this.wrappedObject, javaObject);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void $deleteAttribute(String attributeName) {
        throw new IllegalArgumentException("Cannot delete attributes on type '" + this.objectClass + "'");
    }

    @Override
    public PythonLikeType $getType() {
        return this.type;
    }

    @Override
    public int compareTo(JavaObjectWrapper javaObjectWrapper) {
        Object object = this.wrappedObject;
        if (!(object instanceof Comparable)) {
            throw new IllegalStateException("Class (%s) does not implement (%s).".formatted(this.objectClass, Comparable.class));
        }
        Comparable comparable = (Comparable)object;
        return comparable.compareTo(javaObjectWrapper.wrappedObject);
    }

    @Override
    public Iterator<JavaObjectWrapper> iterator() {
        Object object = this.wrappedObject;
        if (!(object instanceof Iterable)) {
            throw new IllegalStateException("Class (%s) does not implement (%s).".formatted(this.objectClass, Iterable.class));
        }
        Iterable iterable = (Iterable)object;
        return new WrappingJavaObjectIterator(iterable.iterator());
    }

    public String toString() {
        return this.wrappedObject.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaObjectWrapper) {
            JavaObjectWrapper other = (JavaObjectWrapper)o;
            return this.wrappedObject.equals(other.wrappedObject);
        }
        return this.wrappedObject.equals(o);
    }

    public int hashCode() {
        return this.wrappedObject.hashCode();
    }

    @Override
    public PythonInteger $method$__hash__() {
        return PythonInteger.valueOf(this.hashCode());
    }
}

