/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.util.arguments;

import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonFunctionSignature;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentKind;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ArgumentSpec<Out_> {
    private static List<ArgumentSpec<?>> ARGUMENT_SPECS = new ArrayList();
    private final String functionReturnTypeName;
    private final String functionName;
    private final List<String> argumentNameList;
    private final List<String> argumentTypeNameList;
    private final List<ArgumentKind> argumentKindList;
    private final List<Object> argumentDefaultList;
    private final BitSet nullableArgumentSet;
    private final Optional<Integer> extraPositionalsArgumentIndex;
    private final Optional<Integer> extraKeywordsArgumentIndex;
    private final int numberOfPositionalArguments;
    private final int requiredPositionalArguments;
    private Class<?> functionReturnType = null;
    private List<Class> argumentTypeList = null;

    private ArgumentSpec(String functionName, String functionReturnTypeName) {
        this.functionReturnTypeName = functionReturnTypeName;
        this.functionName = functionName + "()";
        this.requiredPositionalArguments = 0;
        this.numberOfPositionalArguments = 0;
        this.argumentNameList = Collections.emptyList();
        this.argumentTypeNameList = Collections.emptyList();
        this.argumentKindList = Collections.emptyList();
        this.argumentDefaultList = Collections.emptyList();
        this.extraPositionalsArgumentIndex = Optional.empty();
        this.extraKeywordsArgumentIndex = Optional.empty();
        this.nullableArgumentSet = new BitSet();
    }

    private ArgumentSpec(String argumentName, String argumentTypeName, ArgumentKind argumentKind, Object defaultValue, Optional<Integer> extraPositionalsArgumentIndex, Optional<Integer> extraKeywordsArgumentIndex, boolean allowNull, ArgumentSpec<Out_> previousSpec) {
        this.functionName = previousSpec.functionName;
        this.functionReturnTypeName = previousSpec.functionReturnTypeName;
        this.numberOfPositionalArguments = previousSpec.numberOfPositionalArguments < previousSpec.getTotalArgumentCount() ? previousSpec.numberOfPositionalArguments : (argumentKind.allowPositional ? previousSpec.getTotalArgumentCount() + 1 : previousSpec.getTotalArgumentCount());
        if (argumentKind == ArgumentKind.POSITIONAL_ONLY) {
            if (previousSpec.requiredPositionalArguments != previousSpec.getTotalArgumentCount()) {
                throw new IllegalArgumentException("All required positional arguments must come before all other arguments");
            }
            this.requiredPositionalArguments = previousSpec.getTotalArgumentCount() + 1;
        } else {
            this.requiredPositionalArguments = previousSpec.requiredPositionalArguments;
        }
        this.argumentNameList = new ArrayList<String>(previousSpec.argumentNameList.size() + 1);
        this.argumentTypeNameList = new ArrayList<String>(previousSpec.argumentTypeNameList.size() + 1);
        this.argumentKindList = new ArrayList<ArgumentKind>(previousSpec.argumentKindList.size() + 1);
        this.argumentDefaultList = new ArrayList<Object>(previousSpec.argumentDefaultList.size() + 1);
        this.argumentNameList.addAll(previousSpec.argumentNameList);
        this.argumentNameList.add(argumentName);
        this.argumentTypeNameList.addAll(previousSpec.argumentTypeNameList);
        this.argumentTypeNameList.add(argumentTypeName);
        this.argumentKindList.addAll(previousSpec.argumentKindList);
        this.argumentKindList.add(argumentKind);
        this.argumentDefaultList.addAll(previousSpec.argumentDefaultList);
        this.argumentDefaultList.add(defaultValue);
        if (extraPositionalsArgumentIndex.isPresent() && previousSpec.extraPositionalsArgumentIndex.isPresent()) {
            throw new IllegalArgumentException("Multiple positional vararg arguments");
        }
        if (previousSpec.extraPositionalsArgumentIndex.isPresent()) {
            extraPositionalsArgumentIndex = previousSpec.extraPositionalsArgumentIndex;
        }
        if (extraKeywordsArgumentIndex.isPresent() && previousSpec.extraKeywordsArgumentIndex.isPresent()) {
            throw new IllegalArgumentException("Multiple keyword vararg arguments");
        }
        if (previousSpec.extraKeywordsArgumentIndex.isPresent()) {
            extraKeywordsArgumentIndex = previousSpec.extraKeywordsArgumentIndex;
        }
        this.extraPositionalsArgumentIndex = extraPositionalsArgumentIndex;
        this.extraKeywordsArgumentIndex = extraKeywordsArgumentIndex;
        this.nullableArgumentSet = (BitSet)previousSpec.nullableArgumentSet.clone();
        if (allowNull) {
            this.nullableArgumentSet.set(this.argumentNameList.size() - 1);
        }
    }

    public static <T extends PythonLikeObject> ArgumentSpec<T> forFunctionReturning(String functionName, String outClass) {
        return new ArgumentSpec(functionName, outClass);
    }

    public int getTotalArgumentCount() {
        return this.argumentNameList.size();
    }

    public int getAllowPositionalArgumentCount() {
        return this.numberOfPositionalArguments;
    }

    public boolean hasExtraPositionalArgumentsCapture() {
        return this.extraPositionalsArgumentIndex.isPresent();
    }

    public boolean hasExtraKeywordArgumentsCapture() {
        return this.extraKeywordsArgumentIndex.isPresent();
    }

    public String getArgumentTypeInternalName(int argumentIndex) {
        return this.argumentTypeNameList.get(argumentIndex).replace('.', '/');
    }

    public ArgumentKind getArgumentKind(int argumentIndex) {
        return this.argumentKindList.get(argumentIndex);
    }

    public int getArgumentIndex(String argumentName) {
        return this.argumentNameList.indexOf(argumentName);
    }

    public boolean isArgumentNullable(int argumentIndex) {
        return this.nullableArgumentSet.get(argumentIndex);
    }

    public Optional<Integer> getExtraPositionalsArgumentIndex() {
        return this.extraPositionalsArgumentIndex;
    }

    public Optional<Integer> getExtraKeywordsArgumentIndex() {
        return this.extraKeywordsArgumentIndex;
    }

    public Collection<Integer> getUnspecifiedArgumentSet(int positionalArguments, List<String> keywordArgumentNameList) {
        int specArgumentCount = this.getTotalArgumentCount();
        if (this.hasExtraPositionalArgumentsCapture()) {
            --specArgumentCount;
        }
        if (this.hasExtraKeywordArgumentsCapture()) {
            --specArgumentCount;
        }
        return IntStream.range(positionalArguments, specArgumentCount).filter(index -> !keywordArgumentNameList.contains(this.argumentNameList.get(index))).boxed().collect(Collectors.toList());
    }

    public static ArgumentSpec<?> getArgumentSpec(int argumentSpecIndex) {
        return ARGUMENT_SPECS.get(argumentSpecIndex);
    }

    public void loadArgumentSpec(MethodVisitor methodVisitor) {
        int index = ARGUMENT_SPECS.size();
        ARGUMENT_SPECS.add(this);
        methodVisitor.visitLdcInsn((Object)index);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(ArgumentSpec.class), "getArgumentSpec", Type.getMethodDescriptor((Type)Type.getType(ArgumentSpec.class), (Type[])new Type[]{Type.INT_TYPE}), false);
    }

    private void computeArgumentTypeList() {
        if (this.argumentTypeList == null) {
            try {
                this.functionReturnType = BuiltinTypes.asmClassLoader.loadClass(this.functionReturnTypeName.replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.argumentTypeList = this.argumentTypeNameList.stream().map(className -> {
                try {
                    return BuiltinTypes.asmClassLoader.loadClass(className.replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }).toList();
        }
    }

    public List<PythonLikeObject> extractArgumentList(List<PythonLikeObject> positionalArguments, Map<PythonString, PythonLikeObject> keywordArguments) {
        Object argumentName;
        this.computeArgumentTypeList();
        ArrayList<PythonLikeObject> out = new ArrayList<PythonLikeObject>(this.argumentNameList.size());
        if (positionalArguments.size() > this.numberOfPositionalArguments && this.extraPositionalsArgumentIndex.isEmpty()) {
            throw new TypeError(this.functionName + " takes " + this.numberOfPositionalArguments + " positional arguments but " + positionalArguments.size() + " were given");
        }
        if (positionalArguments.size() < this.requiredPositionalArguments) {
            int missing = this.requiredPositionalArguments - positionalArguments.size();
            String argumentString = missing == 1 ? "argument" : "arguments";
            List<String> missingArgumentNames = this.argumentNameList.subList(this.argumentNameList.size() - missing, this.argumentNameList.size());
            throw new TypeError(this.functionName + " missing " + (this.requiredPositionalArguments - positionalArguments.size()) + " required positional " + argumentString + ": '" + String.join((CharSequence)"', ", missingArgumentNames) + "'");
        }
        int numberOfSetArguments = Math.min(this.numberOfPositionalArguments, positionalArguments.size());
        out.addAll(positionalArguments.subList(0, numberOfSetArguments));
        for (int i = numberOfSetArguments; i < this.argumentNameList.size(); ++i) {
            out.add(null);
        }
        int remaining = this.argumentNameList.size() - numberOfSetArguments;
        PythonLikeDict extraKeywordArguments = null;
        if (this.extraPositionalsArgumentIndex.isPresent()) {
            --remaining;
            out.set(this.extraPositionalsArgumentIndex.get(), PythonLikeTuple.fromList(positionalArguments.subList(numberOfSetArguments, positionalArguments.size())));
        }
        if (this.extraKeywordsArgumentIndex.isPresent()) {
            --remaining;
            extraKeywordArguments = new PythonLikeDict();
            out.set(this.extraKeywordsArgumentIndex.get(), extraKeywordArguments);
        }
        for (Map.Entry<PythonString, PythonLikeObject> keywordArgument : keywordArguments.entrySet()) {
            argumentName = keywordArgument.getKey();
            int position = this.argumentNameList.indexOf(((PythonString)argumentName).value);
            if (position == -1) {
                if (this.extraKeywordsArgumentIndex.isPresent()) {
                    extraKeywordArguments.put((PythonLikeObject)argumentName, keywordArgument.getValue());
                    continue;
                }
                throw new TypeError(this.functionName + " got an unexpected keyword argument " + ((PythonString)argumentName).repr().value);
            }
            if (out.get(position) != null) {
                throw new TypeError(this.functionName + " got multiple values for argument " + ((PythonString)argumentName).repr().value);
            }
            if (!this.argumentKindList.get((int)position).allowKeyword) {
                throw new TypeError(this.functionName + " got some positional-only arguments passed as keyword arguments: " + ((PythonString)argumentName).repr().value);
            }
            --remaining;
            out.set(position, keywordArgument.getValue());
        }
        if (remaining > 0) {
            ArrayList<Integer> missing = new ArrayList<Integer>(remaining);
            for (int i = 0; i < out.size(); ++i) {
                if (out.get(i) != null) continue;
                if (this.argumentDefaultList.get(i) != null || this.nullableArgumentSet.get(i)) {
                    out.set(i, (PythonLikeObject)this.argumentDefaultList.get(i));
                    --remaining;
                    continue;
                }
                missing.add(i);
            }
            if (remaining > 0) {
                Object argumentString;
                int index2;
                if (missing.stream().anyMatch(index -> this.argumentKindList.get((int)index.intValue()).allowPositional)) {
                    ArrayList<String> missingAllowsPositional = new ArrayList<String>(remaining);
                    argumentName = missing.iterator();
                    while (argumentName.hasNext()) {
                        index2 = (Integer)argumentName.next();
                        if (!this.argumentKindList.get((int)index2).allowPositional) continue;
                        missingAllowsPositional.add(this.argumentNameList.get(index2));
                    }
                    argumentString = missingAllowsPositional.size() == 1 ? "argument" : "arguments";
                    throw new TypeError(this.functionName + " missing " + remaining + " required positional " + (String)argumentString + ": '" + String.join((CharSequence)"', ", missingAllowsPositional) + "'");
                }
                ArrayList<String> missingKeywordOnly = new ArrayList<String>(remaining);
                argumentString = missing.iterator();
                while (argumentString.hasNext()) {
                    index2 = (Integer)argumentString.next();
                    missingKeywordOnly.add(this.argumentNameList.get(index2));
                }
                argumentString = missingKeywordOnly.size() == 1 ? "argument" : "arguments";
                throw new TypeError(this.functionName + " missing " + remaining + " required keyword-only " + (String)argumentString + ": '" + String.join((CharSequence)"', ", missingKeywordOnly) + "'");
            }
        }
        for (int i = 0; i < this.argumentNameList.size(); ++i) {
            if ((out.get(i) != null || this.nullableArgumentSet.get(i)) && (out.get(i) == null || this.argumentTypeList.get(i).isInstance(out.get(i)))) continue;
            throw new TypeError(this.functionName + "'s argument '" + this.argumentNameList.get(i) + "' has incorrect type: '" + this.argumentNameList.get(i) + "' must be a " + JavaPythonTypeConversionImplementor.getPythonLikeType(this.argumentTypeList.get(i)) + " (got " + (out.get(i) != null ? JavaPythonTypeConversionImplementor.getPythonLikeType(((PythonLikeObject)out.get(i)).getClass()) : "NULL") + " instead)");
        }
        return out;
    }

    public boolean verifyMatchesCallSignature(int positionalArgumentCount, List<String> keywordArgumentNameList, List<PythonLikeType> callStackTypeList) {
        this.computeArgumentTypeList();
        Set<Integer> missingValue = this.getRequiredArgumentIndexSet();
        for (int keywordIndex = 0; keywordIndex < keywordArgumentNameList.size(); ++keywordIndex) {
            String keyword = keywordArgumentNameList.get(keywordIndex);
            PythonLikeType stackType = callStackTypeList.get(positionalArgumentCount + keywordIndex);
            int index = this.argumentNameList.indexOf(keyword);
            if (index == -1 && this.extraKeywordsArgumentIndex.isEmpty()) {
                return false;
            }
            if (index != -1 && index < positionalArgumentCount) {
                return false;
            }
            try {
                if (!this.argumentTypeList.get(index).isAssignableFrom(stackType.getJavaClass())) {
                    return false;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            missingValue.remove(index);
        }
        if (positionalArgumentCount < this.requiredPositionalArguments || positionalArgumentCount > this.getTotalArgumentCount()) {
            return false;
        }
        for (int i = 0; i < positionalArgumentCount; ++i) {
            missingValue.remove(i);
            try {
                if (this.argumentTypeList.get(i).isAssignableFrom(callStackTypeList.get(i).getJavaClass())) continue;
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!missingValue.isEmpty()) {
            return false;
        }
        if (this.extraPositionalsArgumentIndex.isEmpty() && this.extraKeywordsArgumentIndex.isEmpty()) {
            return positionalArgumentCount <= this.numberOfPositionalArguments && positionalArgumentCount + keywordArgumentNameList.size() <= this.argumentNameList.size();
        }
        if (this.extraPositionalsArgumentIndex.isPresent() && this.extraKeywordsArgumentIndex.isEmpty()) {
            return true;
        }
        if (this.extraPositionalsArgumentIndex.isEmpty()) {
            return positionalArgumentCount < this.numberOfPositionalArguments;
        }
        return true;
    }

    private Set<Integer> getRequiredArgumentIndexSet() {
        HashSet<Integer> out = new HashSet<Integer>();
        for (int i = 0; i < this.argumentNameList.size(); ++i) {
            if (this.argumentKindList.get(i) == ArgumentKind.VARARGS || this.argumentDefaultList.get(i) != null || this.nullableArgumentSet.get(i)) continue;
            out.add(i);
        }
        return out;
    }

    private <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addArgument(String argumentName, String argumentTypeName, ArgumentKind argumentKind, ArgumentType_ defaultValue, Optional<Integer> extraPositionalsArgumentIndex, Optional<Integer> extraKeywordsArgumentIndex, boolean allowNull) {
        return new ArgumentSpec<Out_>(argumentName, argumentTypeName, argumentKind, defaultValue, extraPositionalsArgumentIndex, extraKeywordsArgumentIndex, allowNull, this);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addArgument(String argumentName, String argumentTypeName) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.POSITIONAL_AND_KEYWORD, null, Optional.empty(), Optional.empty(), false);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addPositionalOnlyArgument(String argumentName, String argumentTypeName) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.POSITIONAL_ONLY, null, Optional.empty(), Optional.empty(), false);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addKeywordOnlyArgument(String argumentName, String argumentTypeName) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.KEYWORD_ONLY, null, Optional.empty(), Optional.empty(), false);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addArgument(String argumentName, String argumentTypeName, ArgumentType_ defaultValue) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.POSITIONAL_AND_KEYWORD, defaultValue, Optional.empty(), Optional.empty(), false);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addPositionalOnlyArgument(String argumentName, String argumentTypeName, ArgumentType_ defaultValue) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.POSITIONAL_ONLY, defaultValue, Optional.empty(), Optional.empty(), false);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addKeywordOnlyArgument(String argumentName, String argumentTypeName, ArgumentType_ defaultValue) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.KEYWORD_ONLY, defaultValue, Optional.empty(), Optional.empty(), false);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addNullableArgument(String argumentName, String argumentTypeName) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.POSITIONAL_AND_KEYWORD, null, Optional.empty(), Optional.empty(), true);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addNullablePositionalOnlyArgument(String argumentName, String argumentTypeName) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.POSITIONAL_ONLY, null, Optional.empty(), Optional.empty(), true);
    }

    public <ArgumentType_ extends PythonLikeObject> ArgumentSpec<Out_> addNullableKeywordOnlyArgument(String argumentName, String argumentTypeName) {
        return this.addArgument(argumentName, argumentTypeName, ArgumentKind.KEYWORD_ONLY, null, Optional.empty(), Optional.empty(), true);
    }

    public ArgumentSpec<Out_> addExtraPositionalVarArgument(String argumentName) {
        return this.addArgument(argumentName, PythonLikeTuple.class.getName(), ArgumentKind.VARARGS, null, Optional.of(this.getTotalArgumentCount()), Optional.empty(), false);
    }

    public ArgumentSpec<Out_> addExtraKeywordVarArgument(String argumentName) {
        return this.addArgument(argumentName, PythonLikeDict.class.getName(), ArgumentKind.VARARGS, null, Optional.empty(), Optional.of(this.getTotalArgumentCount()), false);
    }

    public PythonFunctionSignature asPythonFunctionSignature(Method method) {
        this.verifyMethodMatchesSpec(method);
        return this.getPythonFunctionSignatureForMethodDescriptor(new MethodDescriptor(method), method.getReturnType());
    }

    public PythonFunctionSignature asStaticPythonFunctionSignature(Method method) {
        this.verifyMethodMatchesSpec(method);
        return this.getPythonFunctionSignatureForMethodDescriptor(new MethodDescriptor(method, MethodDescriptor.MethodType.STATIC), method.getReturnType());
    }

    public PythonFunctionSignature asClassPythonFunctionSignature(Method method) {
        this.verifyMethodMatchesSpec(method);
        return this.getPythonFunctionSignatureForMethodDescriptor(new MethodDescriptor(method, MethodDescriptor.MethodType.CLASS), method.getReturnType());
    }

    public PythonFunctionSignature asPythonFunctionSignature(String internalClassName, String methodName, String methodDescriptor) {
        MethodDescriptor method = new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.VIRTUAL, methodName, methodDescriptor);
        try {
            return this.getPythonFunctionSignatureForMethodDescriptor(method, BuiltinTypes.asmClassLoader.loadClass(method.getReturnType().getClassName().replace('/', '.')));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public PythonFunctionSignature asStaticPythonFunctionSignature(String internalClassName, String methodName, String methodDescriptor) {
        MethodDescriptor method = new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.STATIC, methodName, methodDescriptor);
        try {
            return this.getPythonFunctionSignatureForMethodDescriptor(method, BuiltinTypes.asmClassLoader.loadClass(method.getReturnType().getClassName().replace('/', '.')));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public PythonFunctionSignature asClassPythonFunctionSignature(String internalClassName, String methodName, String methodDescriptor) {
        MethodDescriptor method = new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.CLASS, methodName, methodDescriptor);
        try {
            return this.getPythonFunctionSignatureForMethodDescriptor(method, BuiltinTypes.asmClassLoader.loadClass(method.getReturnType().getClassName().replace('/', '.')));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyMethodMatchesSpec(Method method) {
        this.computeArgumentTypeList();
        if (!this.functionReturnType.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("Method (" + method + ") does not match the given spec (" + this + "): its return type (" + method.getReturnType() + ") is not assignable to the spec return type (" + this.functionReturnTypeName + ").");
        }
        if (method.getParameterCount() != this.argumentNameList.size()) {
            throw new IllegalArgumentException("Method (" + method + ") does not match the given spec (" + this + "): they have different parameter counts.");
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (method.getParameterTypes()[i].isAssignableFrom(this.argumentTypeList.get(i))) continue;
            throw new IllegalArgumentException("Method (" + method + ") does not match the given spec (" + this + "): its " + i + " parameter (" + method.getParameters()[i].toString() + ") cannot  be assigned from the spec " + i + " parameter (" + this.argumentTypeList.get(i) + " " + this.argumentNameList.get(i) + ").");
        }
    }

    private PythonFunctionSignature getPythonFunctionSignatureForMethodDescriptor(MethodDescriptor methodDescriptor, Class<?> javaReturnType) {
        int firstDefault;
        this.computeArgumentTypeList();
        for (firstDefault = 0; firstDefault < this.argumentDefaultList.size() && this.argumentDefaultList.get(firstDefault) == null && !this.nullableArgumentSet.get(firstDefault); ++firstDefault) {
        }
        List<Object> defaultParameterValueList = firstDefault != this.argumentDefaultList.size() ? this.argumentDefaultList.subList(firstDefault, this.argumentDefaultList.size()) : Collections.emptyList();
        List<PythonLikeType> parameterTypeList = this.argumentTypeList.stream().map(JavaPythonTypeConversionImplementor::getPythonLikeType).collect(Collectors.toList());
        PythonLikeType returnType = JavaPythonTypeConversionImplementor.getPythonLikeType(javaReturnType);
        HashMap<String, Integer> keywordArgumentToIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.argumentNameList.size(); ++i) {
            if (!this.argumentKindList.get((int)i).allowKeyword) continue;
            keywordArgumentToIndexMap.put(this.argumentNameList.get(i), i);
        }
        return new PythonFunctionSignature(methodDescriptor, defaultParameterValueList, keywordArgumentToIndexMap, returnType, parameterTypeList, this.extraPositionalsArgumentIndex, this.extraKeywordsArgumentIndex, this);
    }

    public Object getDefaultValue(int defaultIndex) {
        return this.argumentDefaultList.get(defaultIndex);
    }

    public String toString() {
        StringBuilder out = new StringBuilder("ArgumentSpec(");
        out.append("name=").append(this.functionName).append(", returnType=").append(this.functionReturnTypeName).append(", arguments=[");
        for (int i = 0; i < this.argumentNameList.size(); ++i) {
            out.append(this.argumentTypeNameList.get(i));
            out.append(" ");
            out.append(this.argumentNameList.get(i));
            if (this.nullableArgumentSet.get(i)) {
                out.append(" (nullable)");
            }
            if (this.argumentDefaultList.get(i) != null) {
                out.append(" (default: ");
                out.append(this.argumentDefaultList.get(i));
                out.append(")");
            }
            if (this.argumentKindList.get(i) != ArgumentKind.POSITIONAL_AND_KEYWORD) {
                if (this.extraPositionalsArgumentIndex.isPresent() && this.extraPositionalsArgumentIndex.get() == i) {
                    out.append(" (vargs)");
                } else if (this.extraKeywordsArgumentIndex.isPresent() && this.extraKeywordsArgumentIndex.get() == i) {
                    out.append(" (kwargs)");
                } else {
                    out.append(" (");
                    out.append((Object)this.argumentKindList.get(i));
                    out.append(")");
                }
            }
            if (i == this.argumentNameList.size() - 1) continue;
            out.append(", ");
        }
        out.append("])");
        return out.toString();
    }
}

