/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import java.util.Objects;
import java.util.Set;

public class ExceptionBlock {
    final int blockStartInstructionInclusive;
    final int blockEndInstructionExclusive;
    final int targetInstruction;
    final int stackDepth;
    final boolean pushLastIndex;

    public ExceptionBlock(int blockStartInstructionInclusive, int blockEndInstructionExclusive, int targetInstruction, int stackDepth, boolean pushLastIndex) {
        this.blockStartInstructionInclusive = blockStartInstructionInclusive;
        this.blockEndInstructionExclusive = blockEndInstructionExclusive;
        this.targetInstruction = targetInstruction;
        this.stackDepth = stackDepth;
        this.pushLastIndex = pushLastIndex;
    }

    public String toString() {
        StringBuilder out = new StringBuilder().append(this.blockStartInstructionInclusive).append(" to ").append(this.blockEndInstructionExclusive).append(" -> ").append(this.targetInstruction).append(" [").append(this.stackDepth).append("]");
        if (this.pushLastIndex) {
            out.append(" lasti");
        }
        return out.toString();
    }

    public int getBlockStartInstructionInclusive() {
        return this.blockStartInstructionInclusive;
    }

    public int getBlockEndInstructionExclusive() {
        return this.blockEndInstructionExclusive;
    }

    public int getTargetInstruction() {
        return this.targetInstruction;
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public boolean isPushLastIndex() {
        return this.pushLastIndex;
    }

    public boolean containsAnyTargetInSet(Set<Integer> possibleJumpTargetSet) {
        for (int target : possibleJumpTargetSet) {
            if (target > this.blockStartInstructionInclusive || target >= this.blockEndInstructionExclusive) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionBlock that = (ExceptionBlock)o;
        return this.blockStartInstructionInclusive == that.blockStartInstructionInclusive && this.blockEndInstructionExclusive == that.blockEndInstructionExclusive && this.targetInstruction == that.targetInstruction && this.stackDepth == that.stackDepth && this.pushLastIndex == that.pushLastIndex;
    }

    public int hashCode() {
        return Objects.hash(this.blockStartInstructionInclusive, this.blockEndInstructionExclusive, this.targetInstruction, this.stackDepth, this.pushLastIndex);
    }
}

