/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodDescriptor {
    private final String declaringClassInternalName;
    private final String methodName;
    private final String methodDescriptor;
    private final MethodType methodType;

    private static Type resolveGenericType(java.lang.reflect.Type type, TypeVariable[] interfaceTypeVariables, List<Class<?>> typeArgumentList) {
        if (type instanceof Class) {
            return Type.getType((Class)((Class)type));
        }
        if (type instanceof TypeVariable) {
            for (int i = 0; i < interfaceTypeVariables.length; ++i) {
                if (!interfaceTypeVariables[i].equals(type)) continue;
                return Type.getType(typeArgumentList.get(i));
            }
            throw new IllegalStateException("Unknown TypeVariable " + type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            java.lang.reflect.Type[] lowerBounds = wildcardType.getLowerBounds();
            java.lang.reflect.Type[] upperBounds = wildcardType.getUpperBounds();
            if (lowerBounds.length > 0) {
                return MethodDescriptor.resolveGenericType(lowerBounds[0], interfaceTypeVariables, typeArgumentList);
            }
            if (upperBounds.length > 0) {
                return MethodDescriptor.resolveGenericType(upperBounds[0], interfaceTypeVariables, typeArgumentList);
            }
            throw new IllegalStateException("Wildcard Type " + wildcardType + " has no upper or lower bounds.");
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return MethodDescriptor.resolveGenericType(parameterizedType.getRawType(), interfaceTypeVariables, typeArgumentList);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Type.getType((String)("[" + MethodDescriptor.resolveGenericType(genericArrayType.getGenericComponentType(), interfaceTypeVariables, typeArgumentList).getDescriptor()));
        }
        throw new IllegalArgumentException("Unknown class (" + type.getClass() + ") of argument (" + type + ")");
    }

    public MethodDescriptor(Class<?> interfaceClass, Method method, List<Class<?>> typeArgumentList) {
        Object[] interfaceTypeVariables = interfaceClass.getTypeParameters();
        if (interfaceTypeVariables.length != typeArgumentList.size()) {
            throw new IllegalArgumentException("Type argument list (" + typeArgumentList + ") does not have same size as " + interfaceClass + " generic argument list (" + Arrays.toString(interfaceTypeVariables) + ")");
        }
        this.declaringClassInternalName = Type.getInternalName(method.getDeclaringClass());
        this.methodName = method.getName();
        this.methodType = method.getDeclaringClass().isInterface() ? MethodType.INTERFACE : (Modifier.isStatic(method.getModifiers()) ? MethodType.STATIC : MethodType.VIRTUAL);
        String methodDescriptorString = "";
        Type returnType = MethodDescriptor.resolveGenericType(method.getGenericReturnType(), (TypeVariable[])interfaceTypeVariables, typeArgumentList);
        Type[] argumentTypes = new Type[method.getParameterCount()];
        for (int i = 0; i < argumentTypes.length; ++i) {
            argumentTypes[i] = MethodDescriptor.resolveGenericType(method.getGenericParameterTypes()[i], (TypeVariable[])interfaceTypeVariables, typeArgumentList);
        }
        this.methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])argumentTypes);
    }

    public MethodDescriptor(Method method) {
        this.declaringClassInternalName = Type.getInternalName(method.getDeclaringClass());
        this.methodName = method.getName();
        this.methodDescriptor = Type.getMethodDescriptor((Method)method);
        this.methodType = method.getDeclaringClass().isInterface() ? MethodType.INTERFACE : (Modifier.isStatic(method.getModifiers()) ? MethodType.STATIC : MethodType.VIRTUAL);
    }

    public MethodDescriptor(Method method, MethodType type) {
        this.declaringClassInternalName = Type.getInternalName(method.getDeclaringClass());
        this.methodName = method.getName();
        this.methodDescriptor = Type.getMethodDescriptor((Method)method);
        this.methodType = type;
    }

    public MethodDescriptor(Constructor<?> constructor) {
        this.declaringClassInternalName = Type.getInternalName(constructor.getDeclaringClass());
        this.methodName = constructor.getName();
        this.methodDescriptor = Type.getConstructorDescriptor(constructor);
        this.methodType = MethodType.CONSTRUCTOR;
    }

    public MethodDescriptor(String declaringClassInternalName, MethodType methodType, String methodName, String methodDescriptor) {
        this.declaringClassInternalName = declaringClassInternalName;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.methodType = methodType;
    }

    public MethodDescriptor(Class<?> declaringClass, MethodType methodType, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        this.declaringClassInternalName = Type.getInternalName(declaringClass);
        this.methodName = methodName;
        Type[] parameterAsmTypes = new Type[parameterTypes.length];
        for (int i = 0; i < parameterAsmTypes.length; ++i) {
            parameterAsmTypes[i] = Type.getType(parameterTypes[i]);
        }
        this.methodDescriptor = Type.getMethodDescriptor((Type)Type.getType(returnType), (Type[])parameterAsmTypes);
        this.methodType = methodType;
    }

    public static MethodDescriptor useStaticMethodAsVirtual(Method method) {
        return new MethodDescriptor(method.getDeclaringClass(), MethodType.STATIC_AS_VIRTUAL, method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public String getDeclaringClassInternalName() {
        return this.declaringClassInternalName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public void callMethod(MethodVisitor methodVisitor) {
        methodVisitor.visitMethodInsn(this.getMethodType().getOpcode(), this.getDeclaringClassInternalName(), this.getMethodName(), this.getMethodDescriptor(), this.getMethodType() == MethodType.INTERFACE);
    }

    public MethodDescriptor withReturnType(Type returnType) {
        return new MethodDescriptor(this.getDeclaringClassInternalName(), this.getMethodType(), this.getMethodName(), Type.getMethodDescriptor((Type)returnType, (Type[])Type.getArgumentTypes((String)this.getMethodDescriptor())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)o;
        return this.getDeclaringClassInternalName().equals(that.getDeclaringClassInternalName()) && this.getMethodName().equals(that.getMethodName()) && this.getMethodDescriptor().equals(that.getMethodDescriptor());
    }

    public int hashCode() {
        return Objects.hash(this.getDeclaringClassInternalName(), this.getMethodName(), this.getMethodDescriptor());
    }

    public Type getReturnType() {
        return Type.getReturnType((String)this.getMethodDescriptor());
    }

    public Type[] getParameterTypes() {
        return Type.getArgumentTypes((String)this.getMethodDescriptor());
    }

    public static enum MethodType {
        VIRTUAL(182, false),
        STATIC(184, true),
        CLASS(184, true),
        STATIC_AS_VIRTUAL(184, true),
        INTERFACE(185, false),
        CONSTRUCTOR(183, false);

        private final int opcode;
        private final boolean isStatic;

        private MethodType(int opcode, boolean isStatic) {
            this.opcode = opcode;
            this.isStatic = isStatic;
        }

        public int getOpcode() {
            return this.opcode;
        }

        public boolean isStatic() {
            return this.isStatic;
        }
    }
}

