/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.BytecodeSwitchImplementor;
import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.GeneratorLocalVariableHelper;
import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonBytecodeToJavaBytecodeTranslator;
import ai.timefold.jpyinterpreter.PythonCompiledFunction;
import ai.timefold.jpyinterpreter.PythonFunctionType;
import ai.timefold.jpyinterpreter.PythonInterpreter;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.dag.FlowGraph;
import ai.timefold.jpyinterpreter.implementors.DunderOperatorImplementor;
import ai.timefold.jpyinterpreter.implementors.FunctionImplementor;
import ai.timefold.jpyinterpreter.implementors.GeneratorImplementor;
import ai.timefold.jpyinterpreter.implementors.PythonConstantsImplementor;
import ai.timefold.jpyinterpreter.implementors.VariableImplementor;
import ai.timefold.jpyinterpreter.opcodes.AbstractOpcode;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.descriptor.GeneratorOpDescriptor;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import ai.timefold.jpyinterpreter.opcodes.generator.GeneratorStartOpcode;
import ai.timefold.jpyinterpreter.opcodes.generator.ResumeOpcode;
import ai.timefold.jpyinterpreter.opcodes.generator.YieldFromOpcode;
import ai.timefold.jpyinterpreter.opcodes.generator.YieldValueOpcode;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonCell;
import ai.timefold.jpyinterpreter.types.PythonGenerator;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.StopIteration;
import ai.timefold.jpyinterpreter.util.JavaPythonClassWriter;
import ai.timefold.jpyinterpreter.util.MethodVisitorAdapters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class PythonGeneratorTranslator {
    private static final String SHOULD_PROGRESS_GENERATOR = "$shouldProgressGenerator";
    public static final String GENERATOR_STATE = "$generatorState";
    public static final String GENERATOR_STACK = "$generatorStack";
    public static final String YIELDED_VALUE = "$yieldedValue";
    public static final String YIELD_FROM_ITERATOR = "$yieldFromIterator";
    public static final String CURRENT_EXCEPTION = "$currentException";
    private static final String EXCEPTION_STACK_PREFIX = "$exceptionHandlerStack";
    private static final String PROGRESS_GENERATOR = "progressGenerator";

    public static String exceptionHandlerTargetStackLocal(int target) {
        return EXCEPTION_STACK_PREFIX + target;
    }

    public static Class<?> translateGeneratorFunction(PythonCompiledFunction pythonCompiledFunction) {
        int i;
        int i2;
        String maybeClassName = "org.jpyinterpreter.user." + pythonCompiledFunction.getGeneratedClassBaseName() + "$Generator";
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(PythonGenerator.class), null);
        classWriter.visitField(2, SHOULD_PROGRESS_GENERATOR, Type.BOOLEAN_TYPE.getDescriptor(), null, null);
        classWriter.visitField(2, GENERATOR_STATE, Type.INT_TYPE.getDescriptor(), null, null);
        classWriter.visitField(2, GENERATOR_STACK, Type.getDescriptor(List.class), null, null);
        classWriter.visitField(2, YIELDED_VALUE, Type.getDescriptor(PythonLikeObject.class), null, null);
        classWriter.visitField(2, YIELD_FROM_ITERATOR, Type.getDescriptor(PythonLikeObject.class), null, null);
        classWriter.visitField(2, CURRENT_EXCEPTION, Type.getDescriptor(Throwable.class), null, null);
        PythonBytecodeToJavaBytecodeTranslator.createFields(classWriter);
        for (int variable = 0; variable < pythonCompiledFunction.co_varnames.size(); ++variable) {
            classWriter.visitField(2, pythonCompiledFunction.co_varnames.get(variable), Type.getDescriptor(PythonLikeObject.class), null, null);
        }
        for (i2 = 0; i2 < pythonCompiledFunction.co_cellvars.size(); ++i2) {
            classWriter.visitField(2, pythonCompiledFunction.co_cellvars.get(i2), Type.getDescriptor(PythonCell.class), null, null);
        }
        for (i2 = 0; i2 < pythonCompiledFunction.co_freevars.size(); ++i2) {
            classWriter.visitField(2, pythonCompiledFunction.co_freevars.get(i2), Type.getDescriptor(PythonCell.class), null, null);
        }
        for (int target : pythonCompiledFunction.co_exceptiontable.getJumpTargetSet()) {
            classWriter.visitField(2, PythonGeneratorTranslator.exceptionHandlerTargetStackLocal(target), Type.getDescriptor(PythonLikeObject[].class), null, null);
        }
        Type[] javaParameterTypes = (Type[])Stream.concat(Stream.of(Type.getType(PythonLikeTuple.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonString.class), Type.getType(PythonInterpreter.class)), pythonCompiledFunction.getParameterTypes().stream().map(type -> Type.getType((String)type.getJavaTypeDescriptor()))).toArray(Type[]::new);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])javaParameterTypes), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonGenerator.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, internalClassName, "__defaults__", Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitFieldInsn(181, internalClassName, "__kwdefaults__", Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitFieldInsn(181, internalClassName, "__annotations__", Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitFieldInsn(181, internalClassName, "__closure__", Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitFieldInsn(181, internalClassName, "__qualname__", Type.getDescriptor(PythonString.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitFieldInsn(181, internalClassName, "__interpreter__", Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)true);
        methodVisitor.visitFieldInsn(181, internalClassName, SHOULD_PROGRESS_GENERATOR, Type.BOOLEAN_TYPE.getDescriptor());
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)0);
        methodVisitor.visitFieldInsn(181, internalClassName, GENERATOR_STATE, Type.INT_TYPE.getDescriptor());
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        methodVisitor.visitFieldInsn(181, internalClassName, GENERATOR_STACK, Type.getDescriptor(List.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        methodVisitor.visitFieldInsn(181, internalClassName, YIELDED_VALUE, Type.getDescriptor(PythonLikeObject.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        methodVisitor.visitFieldInsn(181, internalClassName, YIELD_FROM_ITERATOR, Type.getDescriptor(PythonLikeObject.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        methodVisitor.visitFieldInsn(181, internalClassName, CURRENT_EXCEPTION, Type.getDescriptor(Throwable.class));
        for (int parameter = 0; parameter < pythonCompiledFunction.getParameterTypes().size(); ++parameter) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, parameter + 7);
            methodVisitor.visitFieldInsn(181, internalClassName, pythonCompiledFunction.co_varnames.get(parameter), Type.getDescriptor(PythonLikeObject.class));
        }
        GeneratorLocalVariableHelper localVariableHelper = new GeneratorLocalVariableHelper(classWriter, internalClassName, new Type[0], pythonCompiledFunction);
        localVariableHelper.resetCallKeywords(methodVisitor);
        for (i = 0; i < localVariableHelper.getNumberOfBoundCells(); ++i) {
            VariableImplementor.createCell(methodVisitor, localVariableHelper, i);
        }
        for (i = 0; i < localVariableHelper.getNumberOfFreeCells(); ++i) {
            VariableImplementor.setupFreeVariableCell(methodVisitor, internalClassName, localVariableHelper, i);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        PythonGeneratorTranslator.generateHasNext(classWriter, internalClassName, pythonCompiledFunction);
        PythonGeneratorTranslator.generateNext(classWriter, internalClassName, pythonCompiledFunction);
        Map<Integer, GeneratorMethodPart> generatorStateToMethodPart = PythonGeneratorTranslator.createGeneratorStateToMethod(classWriter, internalClassName, pythonCompiledFunction);
        PythonGeneratorTranslator.generateProgressGenerator(classWriter, internalClassName, generatorStateToMethodPart);
        PythonGeneratorTranslator.generateAdvanceGeneratorMethods(classWriter, internalClassName, generatorStateToMethodPart);
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            Class<?> out = BuiltinTypes.asmClassLoader.loadClass(className);
            PythonBytecodeToJavaBytecodeTranslator.setStaticFields(out, pythonCompiledFunction);
            return out;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load class " + className + " despite it being just generated.", e);
        }
    }

    private static void generateHasNext(ClassWriter classWriter, String internalClassName, PythonCompiledFunction pythonCompiledFunction) {
        MethodVisitor methodVisitor = MethodVisitorAdapters.adapt(classWriter.visitMethod(1, "hasNext", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), null, null), "hasNext", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]));
        methodVisitor.visitCode();
        Label checkIfGeneratorEnded = new Label();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, SHOULD_PROGRESS_GENERATOR, Type.BOOLEAN_TYPE.getDescriptor());
        methodVisitor.visitJumpInsn(153, checkIfGeneratorEnded);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, internalClassName, PROGRESS_GENERATOR, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(3);
        methodVisitor.visitFieldInsn(181, internalClassName, SHOULD_PROGRESS_GENERATOR, Type.BOOLEAN_TYPE.getDescriptor());
        methodVisitor.visitLabel(checkIfGeneratorEnded);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, GENERATOR_STATE, Type.INT_TYPE.getDescriptor());
        methodVisitor.visitLdcInsn((Object)-1);
        Label generatorEnded = new Label();
        methodVisitor.visitJumpInsn(159, generatorEnded);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(generatorEnded);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void generateNext(ClassWriter classWriter, String internalClassName, PythonCompiledFunction pythonCompiledFunction) {
        MethodVisitor methodVisitor = MethodVisitorAdapters.adapt(classWriter.visitMethod(1, "next", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]), null, null), "next", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]));
        methodVisitor.visitCode();
        Label returnYieldedValue = new Label();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, SHOULD_PROGRESS_GENERATOR, Type.BOOLEAN_TYPE.getDescriptor());
        methodVisitor.visitJumpInsn(153, returnYieldedValue);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, internalClassName, PROGRESS_GENERATOR, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitLabel(returnYieldedValue);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, GENERATOR_STATE, Type.INT_TYPE.getDescriptor());
        methodVisitor.visitLdcInsn((Object)-1);
        Label generatorEnded = new Label();
        methodVisitor.visitJumpInsn(159, generatorEnded);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(4);
        methodVisitor.visitFieldInsn(181, internalClassName, SHOULD_PROGRESS_GENERATOR, Type.BOOLEAN_TYPE.getDescriptor());
        methodVisitor.visitFieldInsn(180, internalClassName, YIELDED_VALUE, Type.getDescriptor(PythonLikeObject.class));
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel(generatorEnded);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(3);
        methodVisitor.visitFieldInsn(181, internalClassName, SHOULD_PROGRESS_GENERATOR, Type.BOOLEAN_TYPE.getDescriptor());
        methodVisitor.visitFieldInsn(180, internalClassName, YIELDED_VALUE, Type.getDescriptor(PythonLikeObject.class));
        methodVisitor.visitTypeInsn(187, Type.getInternalName(StopIteration.class));
        methodVisitor.visitInsn(90);
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(StopIteration.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class)}), false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void generateProgressGenerator(ClassWriter classWriter, String internalClassName, Map<Integer, GeneratorMethodPart> generatorStateToMethodPartMap) {
        MethodVisitor methodVisitor = MethodVisitorAdapters.adapt(classWriter.visitMethod(2, PROGRESS_GENERATOR, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null), PROGRESS_GENERATOR, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, GENERATOR_STATE, Type.INT_TYPE.getDescriptor());
        BytecodeSwitchImplementor.createIntSwitch(methodVisitor, generatorStateToMethodPartMap.keySet(), generatorState -> {
            GeneratorMethodPart generatorMethodPart = (GeneratorMethodPart)generatorStateToMethodPartMap.get(generatorState);
            methodVisitor.visitVarInsn(25, 0);
            generatorMethodPart.functionMetadata.method.callMethod(methodVisitor);
        }, () -> {}, false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void generateAdvanceGeneratorMethods(ClassWriter classWriter, String internalClassName, Map<Integer, GeneratorMethodPart> generatorStateToMethodPartMap) {
        generatorStateToMethodPartMap.values().forEach(generatorMethodPart -> PythonGeneratorTranslator.generateAdvanceGeneratorMethod(classWriter, internalClassName, generatorMethodPart));
    }

    private static void generateAdvanceGeneratorMethod(ClassWriter classWriter, String internalClassName, GeneratorMethodPart generatorMethodPart) {
        OpcodeDescriptor instruction = AbstractOpcode.lookupInstruction(generatorMethodPart.instruction.opname());
        if (!(instruction instanceof GeneratorOpDescriptor)) {
            throw new IllegalArgumentException("Invalid opcode for instruction: %s".formatted(generatorMethodPart.instruction.opname()));
        }
        GeneratorOpDescriptor generatorInstruction = (GeneratorOpDescriptor)instruction;
        switch (generatorInstruction) {
            case YIELD_VALUE: {
                PythonGeneratorTranslator.generateAdvanceGeneratorMethodForYieldValue(classWriter, internalClassName, generatorMethodPart);
                break;
            }
            case YIELD_FROM: {
                PythonGeneratorTranslator.generateAdvanceGeneratorMethodForYieldFrom(classWriter, internalClassName, generatorMethodPart);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid opcode for instruction: " + generatorMethodPart.instruction.opname());
            }
        }
    }

    private static void generateAdvanceGeneratorMethodForYieldValue(ClassWriter classWriter, String internalClassName, GeneratorMethodPart generatorMethodPart) {
        MethodVisitor methodVisitor = generatorMethodPart.functionMetadata.methodVisitor;
        List<Opcode> opcodeList = PythonBytecodeToJavaBytecodeTranslator.getOpcodeList(generatorMethodPart.functionMetadata.pythonCompiledFunction);
        methodVisitor.visitCode();
        GeneratorImplementor.restoreGeneratorState(generatorMethodPart.functionMetadata, generatorMethodPart.initialStackMetadata);
        if (generatorMethodPart.afterYield != 0 || opcodeList.size() > 0 && opcodeList.get(0) instanceof GeneratorStartOpcode) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, Type.getInternalName(PythonGenerator.class), "sentValue", Type.getDescriptor(PythonLikeObject.class));
            methodVisitor.visitVarInsn(25, 0);
            PythonConstantsImplementor.loadNone(methodVisitor);
            methodVisitor.visitFieldInsn(181, Type.getInternalName(PythonGenerator.class), "sentValue", Type.getDescriptor(PythonLikeObject.class));
        }
        StackMetadata initialStackMetadata = PythonBytecodeToJavaBytecodeTranslator.getInitialStackMetadata(generatorMethodPart.initialStackMetadata.localVariableHelper, generatorMethodPart.originalMethodDescriptor, false);
        FlowGraph flowGraph = FlowGraph.createFlowGraph(generatorMethodPart.functionMetadata, initialStackMetadata, opcodeList);
        List<StackMetadata> stackMetadataForOpcodeIndex = flowGraph.getStackMetadataForOperations();
        initialStackMetadata.localVariableHelper.resetCallKeywords(methodVisitor);
        if (generatorMethodPart.afterYield != 0) {
            Label afterYieldLabel = new Label();
            generatorMethodPart.functionMetadata.bytecodeCounterToLabelMap.put(generatorMethodPart.afterYield, afterYieldLabel);
            methodVisitor.visitJumpInsn(167, afterYieldLabel);
        }
        ResumeOpcode.ResumeType resumeType = ResumeOpcode.ResumeType.YIELD;
        if (opcodeList.get(generatorMethodPart.afterYield) instanceof ResumeOpcode) {
            resumeType = ((ResumeOpcode)opcodeList.get(generatorMethodPart.afterYield)).getResumeType();
        }
        ResumeOpcode.ResumeType actualResumeType = resumeType;
        PythonBytecodeToJavaBytecodeTranslator.writeInstructionsForOpcodes(generatorMethodPart.functionMetadata, stackMetadataForOpcodeIndex, opcodeList, instruction -> {
            if (actualResumeType == ResumeOpcode.ResumeType.YIELD) {
                if (instruction.offset() == generatorMethodPart.afterYield) {
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitFieldInsn(180, Type.getInternalName(PythonGenerator.class), "thrownValue", Type.getDescriptor(Throwable.class));
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitInsn(1);
                    methodVisitor.visitFieldInsn(181, Type.getInternalName(PythonGenerator.class), "thrownValue", Type.getDescriptor(Throwable.class));
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitInsn(1);
                    Label doNotThrowException = new Label();
                    methodVisitor.visitJumpInsn(165, doNotThrowException);
                    methodVisitor.visitInsn(191);
                    methodVisitor.visitLabel(doNotThrowException);
                    methodVisitor.visitInsn(87);
                }
            } else {
                switch (actualResumeType) {
                    case YIELD_FROM: 
                    case AWAIT: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid resume type after YIELD_VALUE: " + actualResumeType);
                    }
                }
            }
        });
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void generateAdvanceGeneratorMethodForYieldFrom(ClassWriter classWriter, String internalClassName, GeneratorMethodPart generatorMethodPart) {
        MethodVisitor methodVisitor = generatorMethodPart.functionMetadata.methodVisitor;
        methodVisitor.visitCode();
        StackMetadata initialStackMetadata = PythonBytecodeToJavaBytecodeTranslator.getInitialStackMetadata(generatorMethodPart.initialStackMetadata.localVariableHelper, generatorMethodPart.originalMethodDescriptor, false);
        List<Opcode> opcodeList = PythonBytecodeToJavaBytecodeTranslator.getOpcodeList(generatorMethodPart.functionMetadata.pythonCompiledFunction);
        FlowGraph flowGraph = FlowGraph.createFlowGraph(generatorMethodPart.functionMetadata, initialStackMetadata, opcodeList);
        List<StackMetadata> stackMetadataForOpcodeIndex = flowGraph.getStackMetadataForOperations();
        initialStackMetadata.localVariableHelper.resetCallKeywords(methodVisitor);
        if (generatorMethodPart.afterYield != 0) {
            Label afterYieldLabel = new Label();
            generatorMethodPart.functionMetadata.bytecodeCounterToLabelMap.put(generatorMethodPart.afterYield, afterYieldLabel);
            methodVisitor.visitJumpInsn(167, afterYieldLabel);
        }
        PythonBytecodeToJavaBytecodeTranslator.writeInstructionsForOpcodes(generatorMethodPart.functionMetadata, stackMetadataForOpcodeIndex, opcodeList, instruction -> {
            if (instruction.offset() == generatorMethodPart.afterYield) {
                Label wasNotSentValue = new Label();
                Label wasNotThrownValue = new Label();
                Label iterateSubiterator = new Label();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, internalClassName, YIELD_FROM_ITERATOR, Type.getDescriptor(PythonLikeObject.class));
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, Type.getInternalName(PythonGenerator.class), "sentValue", Type.getDescriptor(PythonLikeObject.class));
                PythonConstantsImplementor.loadNone(methodVisitor);
                methodVisitor.visitJumpInsn(165, wasNotSentValue);
                methodVisitor.visitLdcInsn((Object)1);
                methodVisitor.visitJumpInsn(167, iterateSubiterator);
                methodVisitor.visitLabel(wasNotSentValue);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, Type.getInternalName(PythonGenerator.class), "thrownValue", Type.getDescriptor(Throwable.class));
                methodVisitor.visitInsn(1);
                methodVisitor.visitJumpInsn(165, wasNotThrownValue);
                methodVisitor.visitLdcInsn((Object)2);
                methodVisitor.visitJumpInsn(167, iterateSubiterator);
                methodVisitor.visitLabel(wasNotThrownValue);
                methodVisitor.visitLdcInsn((Object)0);
                methodVisitor.visitLabel(iterateSubiterator);
                Label tryStartLabel = new Label();
                Label tryEndLabel = new Label();
                Label catchStartLabel = new Label();
                Label catchEndLabel = new Label();
                methodVisitor.visitTryCatchBlock(tryStartLabel, tryEndLabel, catchStartLabel, Type.getInternalName(StopIteration.class));
                methodVisitor.visitLabel(tryStartLabel);
                BytecodeSwitchImplementor.createIntSwitch(methodVisitor, List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), key -> {
                    Label generatorOperationDone = new Label();
                    switch (key) {
                        case 0: {
                            DunderOperatorImplementor.unaryOperator(methodVisitor, PythonUnaryOperator.NEXT);
                            break;
                        }
                        case 1: {
                            methodVisitor.visitVarInsn(25, 0);
                            methodVisitor.visitFieldInsn(180, Type.getInternalName(PythonGenerator.class), "sentValue", Type.getDescriptor(PythonLikeObject.class));
                            methodVisitor.visitVarInsn(25, 0);
                            PythonConstantsImplementor.loadNone(methodVisitor);
                            methodVisitor.visitFieldInsn(181, Type.getInternalName(PythonGenerator.class), "sentValue", Type.getDescriptor(PythonLikeObject.class));
                            FunctionImplementor.callBinaryMethod(methodVisitor, PythonBinaryOperator.SEND.dunderMethod);
                            break;
                        }
                        case 2: {
                            methodVisitor.visitVarInsn(25, 0);
                            methodVisitor.visitFieldInsn(180, Type.getInternalName(PythonGenerator.class), "thrownValue", Type.getDescriptor(Throwable.class));
                            methodVisitor.visitVarInsn(25, 0);
                            methodVisitor.visitInsn(1);
                            methodVisitor.visitFieldInsn(181, Type.getInternalName(PythonGenerator.class), "thrownValue", Type.getDescriptor(Throwable.class));
                            methodVisitor.visitInsn(95);
                            methodVisitor.visitInsn(89);
                            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
                            methodVisitor.visitLdcInsn((Object)"throw");
                            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
                            Label ifThrowMethodPresent = new Label();
                            methodVisitor.visitInsn(1);
                            methodVisitor.visitJumpInsn(166, ifThrowMethodPresent);
                            methodVisitor.visitVarInsn(25, 0);
                            methodVisitor.visitInsn(1);
                            methodVisitor.visitFieldInsn(181, internalClassName, YIELD_FROM_ITERATOR, Type.getDescriptor(PythonLikeObject.class));
                            methodVisitor.visitInsn(87);
                            methodVisitor.visitInsn(191);
                            methodVisitor.visitLabel(ifThrowMethodPresent);
                            methodVisitor.visitInsn(95);
                            FunctionImplementor.callBinaryMethod(methodVisitor, PythonBinaryOperator.THROW.dunderMethod);
                            break;
                        }
                    }
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeObject.class));
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitInsn(95);
                    methodVisitor.visitFieldInsn(181, internalClassName, YIELDED_VALUE, Type.getDescriptor(PythonLikeObject.class));
                    methodVisitor.visitInsn(177);
                }, () -> {
                    methodVisitor.visitTypeInsn(187, Type.getInternalName(IllegalStateException.class));
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitMethodInsn(183, Type.getInternalName(IllegalStateException.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
                    methodVisitor.visitInsn(191);
                }, true);
                methodVisitor.visitLabel(tryEndLabel);
                methodVisitor.visitLabel(catchStartLabel);
                methodVisitor.visitInsn(87);
                methodVisitor.visitLabel(catchEndLabel);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitInsn(1);
                methodVisitor.visitFieldInsn(181, internalClassName, YIELD_FROM_ITERATOR, Type.getDescriptor(PythonLikeObject.class));
                GeneratorImplementor.restoreGeneratorState(generatorMethodPart.functionMetadata, generatorMethodPart.initialStackMetadata);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, internalClassName, YIELDED_VALUE, Type.getDescriptor(PythonLikeObject.class));
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitInsn(1);
                methodVisitor.visitFieldInsn(181, internalClassName, YIELDED_VALUE, Type.getDescriptor(PythonLikeObject.class));
            }
        });
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static Map<Integer, GeneratorMethodPart> createGeneratorStateToMethod(ClassWriter classWriter, String internalClassName, PythonCompiledFunction pythonCompiledFunction) {
        HashMap<Integer, GeneratorMethodPart> generatorStateToMethod = new HashMap<Integer, GeneratorMethodPart>();
        MethodVisitor methodVisitor = classWriter.visitMethod(2, "advance", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor = MethodVisitorAdapters.adapt(methodVisitor, "advance", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        HashMap<Integer, List<Runnable>> bytecodeIndexToArgumentorsMap = new HashMap<Integer, List<Runnable>>();
        HashMap<Integer, Label> bytecodeCounterToLabelMap = new HashMap<Integer, Label>();
        FunctionMetadata functionMetadata = new FunctionMetadata();
        functionMetadata.functionType = PythonFunctionType.GENERATOR;
        functionMetadata.method = new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.VIRTUAL, "advance", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        functionMetadata.bytecodeCounterToCodeArgumenterList = bytecodeIndexToArgumentorsMap;
        functionMetadata.bytecodeCounterToLabelMap = bytecodeCounterToLabelMap;
        functionMetadata.methodVisitor = methodVisitor;
        functionMetadata.pythonCompiledFunction = pythonCompiledFunction;
        functionMetadata.className = internalClassName;
        GeneratorLocalVariableHelper localVariableHelper = new GeneratorLocalVariableHelper(classWriter, internalClassName, new Type[0], pythonCompiledFunction);
        MethodDescriptor stackMetadataMethod = new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.STATIC, pythonCompiledFunction.qualifiedName, pythonCompiledFunction.getAsmMethodDescriptorString());
        StackMetadata initialStackMetadata = PythonBytecodeToJavaBytecodeTranslator.getInitialStackMetadata(localVariableHelper, stackMetadataMethod, false);
        List<Opcode> opcodeList = PythonBytecodeToJavaBytecodeTranslator.getOpcodeList(pythonCompiledFunction);
        FlowGraph flowGraph = FlowGraph.createFlowGraph(functionMetadata, initialStackMetadata, opcodeList);
        flowGraph.visitOperations(YieldValueOpcode.class, (yieldValueOpcode, priorStackMetadata) -> generatorStateToMethod.put(yieldValueOpcode.getBytecodeIndex() + 1, PythonGeneratorTranslator.getGeneratorMethodPartForYield(internalClassName, classWriter, pythonCompiledFunction, stackMetadataMethod, priorStackMetadata.pop(), yieldValueOpcode)));
        flowGraph.visitOperations(YieldFromOpcode.class, (yieldFromOpcode, priorStackMetadata) -> generatorStateToMethod.put(yieldFromOpcode.getBytecodeIndex() + 1, PythonGeneratorTranslator.getGeneratorMethodPartForYield(internalClassName, classWriter, pythonCompiledFunction, stackMetadataMethod, priorStackMetadata.pop(2), yieldFromOpcode)));
        GeneratorMethodPart start = new GeneratorMethodPart();
        start.initialStackMetadata = initialStackMetadata;
        start.functionMetadata = functionMetadata;
        start.afterYield = 0;
        start.originalMethodDescriptor = stackMetadataMethod;
        start.instruction = PythonBytecodeInstruction.atOffset(GeneratorOpDescriptor.YIELD_VALUE, 0);
        generatorStateToMethod.put(0, start);
        return generatorStateToMethod;
    }

    private static GeneratorMethodPart getGeneratorMethodPartForYield(String internalClassName, ClassWriter classWriter, PythonCompiledFunction pythonCompiledFunction, MethodDescriptor originalMethodDescriptor, StackMetadata stackMetadata, AbstractOpcode opcode) {
        FunctionMetadata functionMetadata;
        String methodName = "advance" + (opcode.getBytecodeIndex() + 1);
        GeneratorMethodPart out = new GeneratorMethodPart();
        out.initialStackMetadata = stackMetadata;
        out.afterYield = opcode.getBytecodeIndex() + 1;
        out.instruction = opcode.getInstruction();
        out.originalMethodDescriptor = originalMethodDescriptor;
        out.functionMetadata = functionMetadata = new FunctionMetadata();
        functionMetadata.functionType = PythonFunctionType.GENERATOR;
        functionMetadata.method = new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.VIRTUAL, methodName, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        functionMetadata.bytecodeCounterToLabelMap = new HashMap<Integer, Label>();
        functionMetadata.bytecodeCounterToCodeArgumenterList = new HashMap<Integer, List<Runnable>>();
        functionMetadata.className = internalClassName;
        functionMetadata.methodVisitor = classWriter.visitMethod(2, methodName, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        functionMetadata.methodVisitor = MethodVisitorAdapters.adapt(functionMetadata.methodVisitor, methodName, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        functionMetadata.pythonCompiledFunction = pythonCompiledFunction.copy();
        return out;
    }

    private static class GeneratorMethodPart {
        FunctionMetadata functionMetadata;
        StackMetadata initialStackMetadata;
        MethodDescriptor originalMethodDescriptor;
        int afterYield;
        PythonBytecodeInstruction instruction;

        private GeneratorMethodPart() {
        }
    }
}

