/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ValueSourceInfo {
    final PythonLikeType valueType;
    final Set<Opcode> possibleSourceOpcodeSet;
    final Set<ValueSourceInfo> valueDependencySet;

    private ValueSourceInfo(PythonLikeType valueType, Set<Opcode> possibleSourceOpcodeSet, Set<ValueSourceInfo> valueDependencySet) {
        this.valueType = valueType;
        this.possibleSourceOpcodeSet = possibleSourceOpcodeSet;
        this.valueDependencySet = valueDependencySet;
    }

    public PythonLikeType getValueType() {
        return this.valueType;
    }

    public Set<Opcode> getPossibleSourceOpcodeSet() {
        return this.possibleSourceOpcodeSet;
    }

    public Set<ValueSourceInfo> getValueDependencySet() {
        return this.valueDependencySet;
    }

    public ValueSourceInfo unifyWith(ValueSourceInfo other) {
        PythonLikeType newValueType = this.valueType.unifyWith(other.valueType);
        HashSet<Opcode> newPossibleSourceOpcodeSet = new HashSet<Opcode>(this.possibleSourceOpcodeSet.size() + other.possibleSourceOpcodeSet.size());
        newPossibleSourceOpcodeSet.addAll(this.possibleSourceOpcodeSet);
        newPossibleSourceOpcodeSet.addAll(other.possibleSourceOpcodeSet);
        HashSet<ValueSourceInfo> newValueDependencySet = new HashSet<ValueSourceInfo>(this.valueDependencySet.size() + other.valueDependencySet.size());
        newValueDependencySet.addAll(this.valueDependencySet);
        for (ValueSourceInfo dependency : other.valueDependencySet) {
            Optional<ValueSourceInfo> maybeCommonDependency = this.valueDependencySet.stream().filter(otherValueSource -> otherValueSource.possibleSourceOpcodeSet.equals(dependency.getPossibleSourceOpcodeSet())).findAny();
            if (!maybeCommonDependency.isEmpty()) continue;
            newValueDependencySet.add(dependency);
        }
        return new ValueSourceInfo(newValueType, newPossibleSourceOpcodeSet, newValueDependencySet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueSourceInfo that = (ValueSourceInfo)o;
        return this.valueType.equals(that.valueType) && this.possibleSourceOpcodeSet.equals(that.possibleSourceOpcodeSet) && this.valueDependencySet.equals(that.valueDependencySet);
    }

    public int hashCode() {
        return Objects.hash(this.valueType, this.possibleSourceOpcodeSet, this.valueDependencySet);
    }

    public String toString() {
        return "ValueSourceInfo{valueType=" + this.valueType + ", possibleSourceOpcodeList=" + this.possibleSourceOpcodeSet + ", valueDependencyList=" + this.valueDependencySet + "}";
    }

    public static ValueSourceInfo of(Opcode sourceOpcode, PythonLikeType valueType, ValueSourceInfo ... dependencies) {
        return new ValueSourceInfo(valueType, Set.of(sourceOpcode), Set.of(dependencies));
    }

    public static ValueSourceInfo of(Opcode sourceOpcode, PythonLikeType valueType, List<ValueSourceInfo> dependencyList) {
        return new ValueSourceInfo(valueType, Set.of(sourceOpcode), new HashSet<ValueSourceInfo>(dependencyList));
    }
}

