/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.descriptor;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import ai.timefold.jpyinterpreter.opcodes.descriptor.VersionMapping;
import ai.timefold.jpyinterpreter.opcodes.dunder.BinaryDunderOpcode;
import ai.timefold.jpyinterpreter.opcodes.dunder.CompareOpcode;
import ai.timefold.jpyinterpreter.opcodes.dunder.GetSliceOpcode;
import ai.timefold.jpyinterpreter.opcodes.dunder.NotOpcode;
import ai.timefold.jpyinterpreter.opcodes.dunder.StoreSliceOpcode;
import ai.timefold.jpyinterpreter.opcodes.dunder.UniDunerOpcode;
import java.util.function.Function;

public enum DunderOpDescriptor implements OpcodeDescriptor
{
    COMPARE_OP(CompareOpcode::new),
    UNARY_NOT(NotOpcode::new),
    BINARY_OP(PythonBinaryOperator::getBinaryOpcode),
    UNARY_POSITIVE(PythonUnaryOperator.POSITIVE),
    UNARY_NEGATIVE(PythonUnaryOperator.NEGATIVE),
    UNARY_INVERT(PythonUnaryOperator.INVERT),
    BINARY_POWER(PythonBinaryOperator.POWER),
    BINARY_MULTIPLY(PythonBinaryOperator.MULTIPLY),
    BINARY_MATRIX_MULTIPLY(PythonBinaryOperator.MATRIX_MULTIPLY),
    BINARY_FLOOR_DIVIDE(PythonBinaryOperator.FLOOR_DIVIDE),
    BINARY_TRUE_DIVIDE(PythonBinaryOperator.TRUE_DIVIDE),
    BINARY_MODULO(PythonBinaryOperator.MODULO),
    BINARY_ADD(PythonBinaryOperator.ADD),
    BINARY_SUBTRACT(PythonBinaryOperator.SUBTRACT),
    BINARY_SUBSCR(PythonBinaryOperator.GET_ITEM),
    BINARY_SLICE(GetSliceOpcode::new),
    STORE_SLICE(StoreSliceOpcode::new),
    BINARY_LSHIFT(PythonBinaryOperator.LSHIFT),
    BINARY_RSHIFT(PythonBinaryOperator.RSHIFT),
    BINARY_AND(PythonBinaryOperator.AND),
    BINARY_XOR(PythonBinaryOperator.XOR),
    BINARY_OR(PythonBinaryOperator.OR),
    INPLACE_POWER(PythonBinaryOperator.INPLACE_POWER),
    INPLACE_MULTIPLY(PythonBinaryOperator.INPLACE_MULTIPLY),
    INPLACE_MATRIX_MULTIPLY(PythonBinaryOperator.INPLACE_MATRIX_MULTIPLY),
    INPLACE_FLOOR_DIVIDE(PythonBinaryOperator.INPLACE_FLOOR_DIVIDE),
    INPLACE_TRUE_DIVIDE(PythonBinaryOperator.INPLACE_TRUE_DIVIDE),
    INPLACE_MODULO(PythonBinaryOperator.INPLACE_MODULO),
    INPLACE_ADD(PythonBinaryOperator.INPLACE_ADD),
    INPLACE_SUBTRACT(PythonBinaryOperator.INPLACE_SUBTRACT),
    INPLACE_LSHIFT(PythonBinaryOperator.INPLACE_LSHIFT),
    INPLACE_RSHIFT(PythonBinaryOperator.INPLACE_RSHIFT),
    INPLACE_AND(PythonBinaryOperator.INPLACE_AND),
    INPLACE_XOR(PythonBinaryOperator.INPLACE_XOR),
    INPLACE_OR(PythonBinaryOperator.INPLACE_OR);

    final VersionMapping versionLookup;

    private DunderOpDescriptor(Function<PythonBytecodeInstruction, Opcode> opcodeFunction) {
        this.versionLookup = VersionMapping.constantMapping(opcodeFunction);
    }

    private DunderOpDescriptor(PythonUnaryOperator binaryOperator) {
        this((PythonBytecodeInstruction instruction) -> new UniDunerOpcode((PythonBytecodeInstruction)instruction, binaryOperator));
    }

    private DunderOpDescriptor(PythonBinaryOperator binaryOperator) {
        this((PythonBytecodeInstruction instruction) -> new BinaryDunderOpcode((PythonBytecodeInstruction)instruction, binaryOperator));
    }

    @Override
    public VersionMapping getVersionMapping() {
        return this.versionLookup;
    }
}

