/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class PythonRange
extends AbstractPythonLikeObject
implements List<PythonInteger> {
    public static PythonLikeType $TYPE = BuiltinTypes.RANGE_TYPE;
    public final PythonInteger start;
    public final PythonInteger stop;
    public final PythonInteger step;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.RANGE_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            PythonLikeObject step;
            PythonLikeObject stop;
            PythonLikeObject start;
            Map map = namedArguments = namedArguments != null ? namedArguments : Map.of();
            if (positionalArguments.size() == 3) {
                start = (PythonLikeObject)positionalArguments.get(0);
                stop = (PythonLikeObject)positionalArguments.get(1);
                step = (PythonLikeObject)positionalArguments.get(2);
            } else if (positionalArguments.size() == 2) {
                start = (PythonLikeObject)positionalArguments.get(0);
                stop = (PythonLikeObject)positionalArguments.get(1);
                step = namedArguments.getOrDefault(PythonString.valueOf("step"), PythonInteger.valueOf(1));
            } else if (positionalArguments.size() == 1 && namedArguments.containsKey(PythonString.valueOf("stop"))) {
                start = (PythonLikeObject)positionalArguments.get(0);
                stop = (PythonLikeObject)namedArguments.get(PythonString.valueOf("stop"));
                step = namedArguments.getOrDefault(PythonString.valueOf("step"), PythonInteger.valueOf(1));
            } else if (positionalArguments.size() == 1) {
                stop = (PythonLikeObject)positionalArguments.get(0);
                start = PythonInteger.valueOf(0);
                step = namedArguments.getOrDefault(PythonString.valueOf("step"), PythonInteger.valueOf(1));
            } else if (positionalArguments.isEmpty()) {
                start = namedArguments.getOrDefault(PythonString.valueOf("start"), PythonInteger.valueOf(0));
                stop = (PythonLikeObject)namedArguments.get(PythonString.valueOf("stop"));
                step = namedArguments.getOrDefault(PythonString.valueOf("step"), PythonInteger.valueOf(1));
            } else {
                throw new ValueError("range expects 1 to 3 arguments, got " + positionalArguments.size());
            }
            PythonInteger intStart = start instanceof PythonInteger ? (PythonInteger)start : (PythonInteger)UnaryDunderBuiltin.INDEX.invoke(start);
            PythonInteger intStop = stop instanceof PythonInteger ? (PythonInteger)stop : (PythonInteger)UnaryDunderBuiltin.INDEX.invoke(stop);
            PythonInteger intStep = step instanceof PythonInteger ? (PythonInteger)step : (PythonInteger)UnaryDunderBuiltin.INDEX.invoke(step);
            return new PythonRange(intStart, intStop, intStep);
        });
        BuiltinTypes.RANGE_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonRange.class.getMethod("getLength", new Class[0]));
        BuiltinTypes.RANGE_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonRange.class.getMethod("getPythonIterator", new Class[0]));
        BuiltinTypes.RANGE_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonRange.class.getMethod("getItem", PythonInteger.class));
        BuiltinTypes.RANGE_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonRange.class.getMethod("isObjectInRange", PythonLikeObject.class));
        return BuiltinTypes.RANGE_TYPE;
    }

    public PythonRange(PythonInteger start, PythonInteger stop, PythonInteger step) {
        super(BuiltinTypes.RANGE_TYPE);
        this.start = start;
        this.stop = stop;
        this.step = step;
        this.$setAttribute("start", start);
        this.$setAttribute("stop", stop);
        this.$setAttribute("step", step);
    }

    @Override
    public int size() {
        BigInteger[] divideAndRemainder = this.stop.value.subtract(this.start.value).divideAndRemainder(this.step.value);
        if (divideAndRemainder[1].equals(BigInteger.ZERO)) {
            return divideAndRemainder[0].intValueExact();
        }
        return divideAndRemainder[0].intValueExact() + 1;
    }

    public PythonInteger getLength() {
        return PythonInteger.valueOf(this.size());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof PythonInteger)) {
            return false;
        }
        PythonInteger query = (PythonInteger)o;
        if (this.step.value.compareTo(BigInteger.ZERO) < 0 ? query.value.compareTo(this.stop.value) < 0 : query.value.compareTo(this.stop.value) > 0) {
            return false;
        }
        BigInteger relativeToStart = query.value.subtract(this.start.value);
        BigInteger[] divisionAndRemainder = relativeToStart.divideAndRemainder(this.step.value);
        if (!divisionAndRemainder[1].equals(BigInteger.ZERO)) {
            return false;
        }
        return divisionAndRemainder[0].compareTo(BigInteger.ZERO) >= 0;
    }

    public PythonBoolean isObjectInRange(PythonLikeObject query) {
        return PythonBoolean.valueOf(this.contains(query));
    }

    @Override
    public Iterator<PythonInteger> iterator() {
        return new RangeIterator(this.start, this.stop, this.step, this.start, 0);
    }

    public DelegatePythonIterator getPythonIterator() {
        return new DelegatePythonIterator<PythonInteger>(this.iterator());
    }

    @Override
    public Object[] toArray() {
        Object[] out = new PythonInteger[this.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.get(i);
        }
        return out;
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        Object[] out = ts;
        if (ts.length < this.size()) {
            out = (Object[])Array.newInstance(ts.getClass().getComponentType(), this.size());
        }
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.get(i);
        }
        if (out.length > this.size()) {
            out[this.size()] = null;
        }
        return out;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PythonInteger get(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException();
        }
        PythonInteger out = this.start.add(this.step.multiply(PythonInteger.valueOf(i)));
        if (!this.contains(out)) {
            throw new IndexOutOfBoundsException();
        }
        return out;
    }

    public PythonInteger getItem(PythonInteger index) {
        if (index.value.compareTo(BigInteger.ZERO) < 0) {
            throw new IndexOutOfBoundsException();
        }
        PythonInteger out = this.start.add(this.step.multiply(index));
        if (!this.contains(out)) {
            throw new IndexOutOfBoundsException();
        }
        return out;
    }

    @Override
    public int indexOf(Object o) {
        if (!this.contains(o)) {
            return -1;
        }
        PythonInteger query = (PythonInteger)o;
        BigInteger relativeToStart = query.value.subtract(this.start.value);
        return relativeToStart.divide(this.step.value).intValueExact();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<PythonInteger> listIterator() {
        return new RangeIterator(this.start, this.stop, this.step, this.start, 0);
    }

    @Override
    public ListIterator<PythonInteger> listIterator(int i) {
        return new RangeIterator(this.get(i), this.stop, this.step, this.get(i), i);
    }

    @Override
    public List<PythonInteger> subList(int startIndexInclusive, int endIndexExclusive) {
        return new PythonRange(this.get(startIndexInclusive), this.get(endIndexExclusive), this.step);
    }

    @Override
    public boolean addAll(Collection<? extends PythonInteger> collection) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public boolean addAll(int i, Collection<? extends PythonInteger> collection) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public PythonInteger set(int i, PythonInteger pythonInteger) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public void add(int i, PythonInteger pythonInteger) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public PythonInteger remove(int i) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public boolean add(PythonInteger pythonInteger) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot modify range");
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonRange::registerMethods);
    }

    public static class RangeIterator
    implements ListIterator<PythonInteger> {
        final PythonInteger startValue;
        final PythonInteger stopValue;
        final PythonInteger step;
        final int startOffset;
        PythonInteger currentValue;

        public RangeIterator(PythonInteger startValue, PythonInteger stopValue, PythonInteger step, PythonInteger currentValue, int startOffset) {
            this.startValue = startValue;
            this.stopValue = stopValue;
            this.step = step;
            this.currentValue = currentValue;
            this.startOffset = startOffset;
        }

        @Override
        public boolean hasNext() {
            if (this.step.value.compareTo(BigInteger.ZERO) < 0) {
                return this.currentValue.compareTo(this.stopValue) > 0;
            }
            return this.currentValue.compareTo(this.stopValue) < 0;
        }

        @Override
        public PythonInteger next() {
            PythonInteger out = this.currentValue;
            this.currentValue = this.currentValue.add(this.step);
            return out;
        }

        @Override
        public boolean hasPrevious() {
            if (this.step.value.compareTo(BigInteger.ZERO) < 0) {
                return this.currentValue.compareTo(this.startValue) < 0;
            }
            return this.currentValue.compareTo(this.startValue) > 0;
        }

        @Override
        public PythonInteger previous() {
            PythonInteger out = this.currentValue;
            this.currentValue = this.currentValue.subtract(this.step);
            return out;
        }

        @Override
        public int nextIndex() {
            return this.currentValue.value.divide(this.step.value).intValueExact() + this.startOffset + 1;
        }

        @Override
        public int previousIndex() {
            return this.currentValue.value.divide(this.step.value).intValueExact() + this.startOffset - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot modify range");
        }

        @Override
        public void set(PythonInteger pythonInteger) {
            throw new UnsupportedOperationException("Cannot modify range");
        }

        @Override
        public void add(PythonInteger pythonInteger) {
            throw new UnsupportedOperationException("Cannot modify range");
        }
    }
}

