/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.wrappers;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.wrappers.JavaObjectWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class JavaMethodReference
implements PythonLikeFunction {
    private final Method method;
    private final Map<String, Integer> parameterNameToIndexMap;

    public JavaMethodReference(Method method, Map<String, Integer> parameterNameToIndexMap) {
        this.method = method;
        this.parameterNameToIndexMap = parameterNameToIndexMap;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public PythonLikeObject $call(List<PythonLikeObject> positionalArguments, Map<PythonString, PythonLikeObject> namedArguments, PythonLikeObject callerInstance) {
        Object[] args;
        Object self;
        if (Modifier.isStatic(this.method.getModifiers())) {
            self = null;
            args = this.unwrapPrimitiveArguments(positionalArguments, namedArguments);
        } else {
            self = positionalArguments.get(0);
            if (self instanceof JavaObjectWrapper) {
                self = ((JavaObjectWrapper)self).getWrappedObject();
            }
            args = this.unwrapPrimitiveArguments(positionalArguments.subList(1, positionalArguments.size()), namedArguments);
        }
        try {
            return JavaPythonTypeConversionImplementor.wrapJavaObject(this.method.invoke(self, args));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method (" + this.method + ") is not accessible.", e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private Object[] unwrapPrimitiveArguments(List<PythonLikeObject> positionalArguments, Map<PythonString, PythonLikeObject> namedArguments) {
        namedArguments = namedArguments != null ? namedArguments : Map.of();
        Object[] out = new Object[this.method.getParameterCount()];
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        for (int i = 0; i < positionalArguments.size(); ++i) {
            PythonLikeObject argument = positionalArguments.get(i);
            out[i] = JavaPythonTypeConversionImplementor.convertPythonObjectToJavaType(parameterTypes[i], argument);
        }
        for (PythonString key : namedArguments.keySet()) {
            int index = this.parameterNameToIndexMap.get(key.value);
            PythonLikeObject argument = namedArguments.get(key);
            out[index] = JavaPythonTypeConversionImplementor.convertPythonObjectToJavaType(parameterTypes[index], argument);
        }
        return out;
    }

    @Override
    public PythonLikeType $getType() {
        if (Modifier.isStatic(this.method.getModifiers())) {
            return BuiltinTypes.STATIC_FUNCTION_TYPE;
        }
        return BuiltinTypes.FUNCTION_TYPE;
    }
}

