/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.PythonBytecodeToJavaBytecodeTranslator;
import ai.timefold.jpyinterpreter.PythonFunctionSignature;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.DelegatingInterfaceImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonKnownFunctionType;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.util.MethodVisitorAdapters;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class InterfaceProxyGenerator {
    public static <T> Class<T> generateProxyForFunction(Class<T> interfaceClass, T interfaceInstance) {
        String maybeClassName = interfaceInstance.getClass().getCanonicalName() + "$Proxy";
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(interfaceClass)});
        classWriter.visitField(9, "proxy", Type.getDescriptor(interfaceClass), null, null);
        MethodVisitor constructor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        constructor.visitEnd();
        Method interfaceMethod = PythonBytecodeToJavaBytecodeTranslator.getFunctionalInterfaceMethod(interfaceClass);
        String interfaceMethodDescriptor = Type.getMethodDescriptor((Method)interfaceMethod);
        MethodVisitor interfaceMethodVisitor = classWriter.visitMethod(1, interfaceMethod.getName(), interfaceMethodDescriptor, null, null);
        for (Parameter parameter : interfaceMethod.getParameters()) {
            interfaceMethodVisitor.visitParameter(parameter.getName(), 0);
        }
        interfaceMethodVisitor.visitCode();
        interfaceMethodVisitor.visitFieldInsn(178, internalClassName, "proxy", Type.getDescriptor(interfaceClass));
        for (int i = 0; i < interfaceMethod.getParameterCount(); ++i) {
            interfaceMethodVisitor.visitVarInsn(Type.getType(interfaceMethod.getParameterTypes()[i]).getOpcode(21), i + 1);
        }
        interfaceMethodVisitor.visitMethodInsn(185, Type.getInternalName(interfaceClass), interfaceMethod.getName(), interfaceMethodDescriptor, true);
        interfaceMethodVisitor.visitInsn(Type.getType(interfaceMethod.getReturnType()).getOpcode(172));
        interfaceMethodVisitor.visitMaxs(0, 0);
        interfaceMethodVisitor.visitEnd();
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            Class<?> compiledClass = BuiltinTypes.asmClassLoader.loadClass(className);
            compiledClass.getField("proxy").set(null, interfaceInstance);
            return compiledClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (%s) despite it being just generated.".formatted(className), e);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Impossible State: Unable to access field on generated class (%s).".formatted(className), e);
        }
    }

    public static <T> Class<T> generateProxyForClass(Class<T> interfaceClass, PythonLikeType delegateType) {
        String maybeClassName = delegateType.getClass().getCanonicalName() + "$" + interfaceClass.getSimpleName() + "$Proxy";
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(interfaceClass)});
        classWriter.visitField(18, "delegate", delegateType.getJavaTypeDescriptor(), null, null);
        HashSet<String> createdNameSet = new HashSet<String>();
        for (Method interfaceMethod : interfaceClass.getMethods()) {
            InterfaceProxyGenerator.addArgumentSpecFieldForMethod(classWriter, delegateType, interfaceMethod, createdNameSet);
        }
        MethodVisitor constructor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        constructor.visitVarInsn(25, 0);
        constructor.visitTypeInsn(187, delegateType.getJavaTypeInternalName());
        constructor.visitInsn(89);
        constructor.visitMethodInsn(183, delegateType.getJavaTypeInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        constructor.visitFieldInsn(181, internalClassName, "delegate", delegateType.getJavaTypeDescriptor());
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        constructor.visitEnd();
        for (Method interfaceMethod : interfaceClass.getMethods()) {
            InterfaceProxyGenerator.createMethodDelegate(classWriter, internalClassName, delegateType, interfaceMethod);
        }
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            Class<?> compiledClass = BuiltinTypes.asmClassLoader.loadClass(className);
            for (Method interfaceMethod : interfaceClass.getMethods()) {
                if (!interfaceMethod.getDeclaringClass().isInterface()) continue;
                if (interfaceMethod.isDefault()) {
                    Optional<PythonFunctionSignature> function;
                    Optional<PythonKnownFunctionType> methodType = delegateType.getMethodType(interfaceMethod.getName());
                    if (methodType.isEmpty() || (function = methodType.get().getDefaultFunctionSignature()).isEmpty()) continue;
                    compiledClass.getField("argumentSpec$" + interfaceMethod.getName()).set(null, function.get().getArgumentSpec());
                    continue;
                }
                compiledClass.getField("argumentSpec$" + interfaceMethod.getName()).set(null, delegateType.getMethodType(interfaceMethod.getName()).orElseThrow().getDefaultFunctionSignature().orElseThrow().getArgumentSpec());
            }
            return compiledClass;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (%s) despite it being just generated.".formatted(className), e);
        }
    }

    private static void addArgumentSpecFieldForMethod(ClassWriter classWriter, PythonLikeType delegateType, Method interfaceMethod, Set<String> createdNameSet) {
        if (createdNameSet.contains(interfaceMethod.getName()) || !interfaceMethod.getDeclaringClass().isInterface()) {
            return;
        }
        Optional<PythonKnownFunctionType> methodType = delegateType.getMethodType(interfaceMethod.getName());
        if (methodType.isEmpty()) {
            if (interfaceMethod.isDefault()) {
                return;
            }
            throw new IllegalArgumentException("Type %s cannot implement interface %s because it missing method %s.".formatted(delegateType, interfaceMethod.getDeclaringClass(), interfaceMethod));
        }
        Optional<PythonFunctionSignature> function = methodType.get().getDefaultFunctionSignature();
        if (function.isEmpty()) {
            throw new IllegalStateException();
        }
        classWriter.visitField(9, "argumentSpec$" + interfaceMethod.getName(), Type.getDescriptor(ArgumentSpec.class), null, null);
        createdNameSet.add(interfaceMethod.getName());
    }

    private static void createMethodDelegate(ClassWriter classWriter, String wrapperInternalName, PythonLikeType delegateType, Method interfaceMethod) {
        if (!interfaceMethod.getDeclaringClass().isInterface()) {
            return;
        }
        if (interfaceMethod.isDefault()) {
            Optional<PythonKnownFunctionType> methodType = delegateType.getMethodType(interfaceMethod.getName());
            if (methodType.isEmpty()) {
                return;
            }
            Optional<PythonFunctionSignature> function = methodType.get().getDefaultFunctionSignature();
            if (function.isEmpty()) {
                return;
            }
        }
        String interfaceMethodDescriptor = Type.getMethodDescriptor((Method)interfaceMethod);
        MethodVisitor interfaceMethodVisitor = classWriter.visitMethod(1, interfaceMethod.getName(), interfaceMethodDescriptor, null, null);
        interfaceMethodVisitor = MethodVisitorAdapters.adapt(interfaceMethodVisitor, interfaceMethod.getName(), interfaceMethodDescriptor);
        for (Parameter parameter : interfaceMethod.getParameters()) {
            interfaceMethodVisitor.visitParameter(parameter.getName(), 0);
        }
        interfaceMethodVisitor.visitCode();
        interfaceMethodVisitor.visitVarInsn(25, 0);
        interfaceMethodVisitor.visitFieldInsn(180, wrapperInternalName, "delegate", delegateType.getJavaTypeDescriptor());
        interfaceMethodVisitor.visitTypeInsn(187, Type.getInternalName(IdentityHashMap.class));
        interfaceMethodVisitor.visitInsn(89);
        interfaceMethodVisitor.visitMethodInsn(183, Type.getInternalName(IdentityHashMap.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        interfaceMethodVisitor.visitVarInsn(58, interfaceMethod.getParameterCount() + 1);
        interfaceMethodVisitor.visitFieldInsn(178, wrapperInternalName, "argumentSpec$" + interfaceMethod.getName(), Type.getDescriptor(ArgumentSpec.class));
        PythonFunctionSignature functionSignature = delegateType.getMethodType(interfaceMethod.getName()).orElseThrow(() -> new IllegalArgumentException("Type %s cannot implement interface %s because it missing method %s.".formatted(delegateType, interfaceMethod.getDeclaringClass(), interfaceMethod))).getDefaultFunctionSignature().orElseThrow();
        DelegatingInterfaceImplementor.prepareParametersForMethodCallFromArgumentSpec(interfaceMethod, interfaceMethodVisitor, functionSignature.getParameterTypes().length, Type.getType((String)functionSignature.getMethodDescriptor().getMethodDescriptor()), false);
        functionSignature.getMethodDescriptor().callMethod(interfaceMethodVisitor);
        Class<?> returnType = interfaceMethod.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            interfaceMethodVisitor.visitInsn(177);
        } else {
            if (returnType.isPrimitive()) {
                JavaPythonTypeConversionImplementor.loadTypeClass(returnType, interfaceMethodVisitor);
            } else {
                interfaceMethodVisitor.visitLdcInsn((Object)Type.getType(returnType));
            }
            interfaceMethodVisitor.visitInsn(95);
            interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "convertPythonObjectToJavaType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Class.class), Type.getType(PythonLikeObject.class)}), false);
            if (returnType.isPrimitive()) {
                JavaPythonTypeConversionImplementor.unboxBoxedPrimitiveType(returnType, interfaceMethodVisitor);
                interfaceMethodVisitor.visitInsn(Type.getType(returnType).getOpcode(172));
            } else {
                interfaceMethodVisitor.visitTypeInsn(192, Type.getInternalName(returnType));
                interfaceMethodVisitor.visitInsn(176);
            }
        }
        interfaceMethodVisitor.visitMaxs(interfaceMethod.getParameterCount() + 2, 1);
        interfaceMethodVisitor.visitEnd();
    }
}

