/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.BytecodeSwitchImplementor;
import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonBytecodeToJavaBytecodeTranslator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.CollectionImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class PythonDefaultArgumentImplementor {
    public static final String ARGUMENT_PREFIX = "argument_";
    public static final String CONSTANT_PREFIX = "DEFAULT_VALUE_";
    public static final String ARGUMENT_SPEC_STATIC_FIELD_NAME = "argumentSpec";
    public static final String KEY_TUPLE_FIELD_NAME = "keyword_args";
    public static final String REMAINING_KEY_ARGUMENTS_FIELD_NAME = "remaining_keys";
    public static final String POSITIONAL_INDEX = "positional_index";

    public static String getArgumentName(int argumentIndex) {
        return ARGUMENT_PREFIX + argumentIndex;
    }

    public static String getConstantName(int defaultIndex) {
        return CONSTANT_PREFIX + defaultIndex;
    }

    public static String createDefaultArgumentFor(MethodDescriptor methodDescriptor, List<PythonLikeObject> defaultArgumentList, Map<String, Integer> argumentNameToIndexMap, Optional<Integer> extraPositionalArgumentsVariableIndex, Optional<Integer> extraKeywordArgumentsVariableIndex, ArgumentSpec<?> argumentSpec) {
        int i;
        String fieldName;
        int i2;
        String maybeClassName = "org.jpyinterpreter.synthetic." + methodDescriptor.getDeclaringClassInternalName().replace('/', '.') + "." + methodDescriptor.getMethodName() + "$$Defaults";
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(PythonLikeFunction.class)});
        classWriter.visitField(9, ARGUMENT_SPEC_STATIC_FIELD_NAME, Type.getDescriptor(ArgumentSpec.class), null, null);
        int defaultStart = methodDescriptor.getParameterTypes().length - defaultArgumentList.size();
        for (i2 = 0; i2 < defaultArgumentList.size(); ++i2) {
            fieldName = PythonDefaultArgumentImplementor.getConstantName(i2);
            classWriter.visitField(9, fieldName, methodDescriptor.getParameterTypes()[defaultStart + i2].getDescriptor(), null, null);
        }
        classWriter.visitField(18, KEY_TUPLE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class), null, null);
        classWriter.visitField(2, REMAINING_KEY_ARGUMENTS_FIELD_NAME, Type.getDescriptor(Integer.TYPE), null, null);
        classWriter.visitField(2, POSITIONAL_INDEX, Type.getDescriptor(Integer.TYPE), null, null);
        for (i2 = 0; i2 < methodDescriptor.getParameterTypes().length; ++i2) {
            fieldName = PythonDefaultArgumentImplementor.getArgumentName(i2);
            if (extraPositionalArgumentsVariableIndex.isPresent() && extraPositionalArgumentsVariableIndex.get() == i2) {
                classWriter.visitField(1, fieldName, Type.getDescriptor(PythonLikeTuple.class), null, null);
                continue;
            }
            if (extraKeywordArgumentsVariableIndex.isPresent() && extraKeywordArgumentsVariableIndex.get() == i2) {
                classWriter.visitField(1, fieldName, Type.getDescriptor(PythonLikeDict.class), null, null);
                continue;
            }
            classWriter.visitField(1, fieldName, methodDescriptor.getParameterTypes()[i2].getDescriptor(), null, null);
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeTuple.class), Type.INT_TYPE}), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, internalClassName, KEY_TUPLE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "size", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), true);
        methodVisitor.visitFieldInsn(181, internalClassName, REMAINING_KEY_ARGUMENTS_FIELD_NAME, Type.getDescriptor(Integer.TYPE));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitFieldInsn(181, internalClassName, POSITIONAL_INDEX, Type.getDescriptor(Integer.TYPE));
        for (i = 0; i < defaultArgumentList.size(); ++i) {
            int argumentIndex = i + (methodDescriptor.getParameterTypes().length - defaultArgumentList.size());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(178, internalClassName, PythonDefaultArgumentImplementor.getConstantName(i), methodDescriptor.getParameterTypes()[defaultStart + i].getDescriptor());
            methodVisitor.visitFieldInsn(181, internalClassName, PythonDefaultArgumentImplementor.getArgumentName(argumentIndex), methodDescriptor.getParameterTypes()[argumentIndex].getDescriptor());
        }
        if (extraPositionalArgumentsVariableIndex.isPresent()) {
            methodVisitor.visitVarInsn(25, 0);
            CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
            methodVisitor.visitFieldInsn(181, internalClassName, PythonDefaultArgumentImplementor.getArgumentName(extraPositionalArgumentsVariableIndex.get()), Type.getDescriptor(PythonLikeTuple.class));
        }
        if (extraKeywordArgumentsVariableIndex.isPresent()) {
            methodVisitor.visitVarInsn(25, 0);
            CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
            methodVisitor.visitFieldInsn(181, internalClassName, PythonDefaultArgumentImplementor.getArgumentName(extraKeywordArgumentsVariableIndex.get()), Type.getDescriptor(PythonLikeDict.class));
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        PythonDefaultArgumentImplementor.createAddArgumentMethod((ClassVisitor)classWriter, internalClassName, methodDescriptor, argumentNameToIndexMap, extraPositionalArgumentsVariableIndex, extraKeywordArgumentsVariableIndex, argumentSpec);
        methodVisitor = classWriter.visitMethod(9, "<clinit>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        argumentSpec.loadArgumentSpec(methodVisitor);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(179, internalClassName, ARGUMENT_SPEC_STATIC_FIELD_NAME, Type.getDescriptor(ArgumentSpec.class));
        for (i = 0; i < defaultArgumentList.size(); ++i) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn((Object)(defaultStart + i));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(ArgumentSpec.class), "getDefaultValue", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), false);
            methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[defaultStart + i].getInternalName());
            String fieldName2 = PythonDefaultArgumentImplementor.getConstantName(i);
            methodVisitor.visitFieldInsn(179, internalClassName, fieldName2, methodDescriptor.getParameterTypes()[defaultStart + i].getDescriptor());
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        return internalClassName;
    }

    private static void createAddArgumentMethod(ClassVisitor classVisitor, String classInternalName, MethodDescriptor methodDescriptor, Map<String, Integer> argumentNameToIndexMap, Optional<Integer> extraPositionalArgumentsVariableIndex, Optional<Integer> extraKeywordArgumentsVariableIndex, ArgumentSpec<?> argumentSpec) {
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, "addArgument", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class)}), null, null);
        methodVisitor.visitParameter("argument", 0);
        methodVisitor.visitCode();
        Label noMoreKeywordArguments = new Label();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, classInternalName, REMAINING_KEY_ARGUMENTS_FIELD_NAME, Type.getDescriptor(Integer.TYPE));
        methodVisitor.visitJumpInsn(153, noMoreKeywordArguments);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, classInternalName, KEY_TUPLE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, classInternalName, REMAINING_KEY_ARGUMENTS_FIELD_NAME, Type.getDescriptor(Integer.TYPE));
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(100);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonString.class));
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonString.class), "getValue", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
        BytecodeSwitchImplementor.createStringSwitch(methodVisitor, argumentNameToIndexMap.keySet(), 2, key -> {
            int index = (Integer)argumentNameToIndexMap.get(key);
            Type parameterType = methodDescriptor.getParameterTypes()[index];
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, parameterType.getInternalName());
            methodVisitor.visitFieldInsn(181, classInternalName, PythonDefaultArgumentImplementor.getArgumentName(index), parameterType.getDescriptor());
        }, () -> {
            if (extraKeywordArgumentsVariableIndex.isPresent()) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, classInternalName, PythonDefaultArgumentImplementor.getArgumentName((Integer)extraKeywordArgumentsVariableIndex.get()), Type.getDescriptor(PythonLikeDict.class));
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, classInternalName, KEY_TUPLE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, classInternalName, REMAINING_KEY_ARGUMENTS_FIELD_NAME, Type.getDescriptor(Integer.TYPE));
                methodVisitor.visitInsn(4);
                methodVisitor.visitInsn(100);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonString.class));
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeDict.class), "put", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeObject.class)}), false);
                methodVisitor.visitInsn(87);
            } else {
                methodVisitor.visitTypeInsn(187, Type.getInternalName(TypeError.class));
                methodVisitor.visitInsn(89);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, classInternalName, KEY_TUPLE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, classInternalName, REMAINING_KEY_ARGUMENTS_FIELD_NAME, Type.getDescriptor(Integer.TYPE));
                methodVisitor.visitInsn(4);
                methodVisitor.visitInsn(100);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonString.class));
                methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonString.class), "getValue", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonDefaultArgumentImplementor.class), "getUnknownKeyArgument", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[]{Type.getType(String.class)}), false);
                methodVisitor.visitMethodInsn(183, Type.getInternalName(TypeError.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
                methodVisitor.visitInsn(191);
            }
        }, false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, classInternalName, REMAINING_KEY_ARGUMENTS_FIELD_NAME, Type.getDescriptor(Integer.TYPE));
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(100);
        methodVisitor.visitFieldInsn(181, classInternalName, REMAINING_KEY_ARGUMENTS_FIELD_NAME, Type.getDescriptor(Integer.TYPE));
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(noMoreKeywordArguments);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, classInternalName, POSITIONAL_INDEX, Type.getDescriptor(Integer.TYPE));
        BytecodeSwitchImplementor.createIntSwitch(methodVisitor, IntStream.range(0, argumentSpec.getAllowPositionalArgumentCount()).boxed().collect(Collectors.toList()), index -> {
            Type parameterType = methodDescriptor.getParameterTypes()[index];
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, parameterType.getInternalName());
            methodVisitor.visitFieldInsn(181, classInternalName, PythonDefaultArgumentImplementor.getArgumentName(index), parameterType.getDescriptor());
        }, () -> {
            if (extraPositionalArgumentsVariableIndex.isPresent()) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, classInternalName, PythonDefaultArgumentImplementor.getArgumentName((Integer)extraPositionalArgumentsVariableIndex.get()), Type.getDescriptor(PythonLikeTuple.class));
                methodVisitor.visitInsn(3);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeTuple.class), "add", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.getType(PythonLikeObject.class)}), false);
            } else {
                methodVisitor.visitTypeInsn(187, Type.getInternalName(TypeError.class));
                methodVisitor.visitInsn(89);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, classInternalName, POSITIONAL_INDEX, Type.getDescriptor(Integer.TYPE));
                methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonDefaultArgumentImplementor.class), "getTooManyPositionalArguments", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[]{Type.INT_TYPE}), false);
                methodVisitor.visitMethodInsn(183, Type.getInternalName(TypeError.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
                methodVisitor.visitInsn(191);
            }
        }, false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, classInternalName, POSITIONAL_INDEX, Type.getDescriptor(Integer.TYPE));
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(100);
        methodVisitor.visitFieldInsn(181, classInternalName, POSITIONAL_INDEX, Type.getDescriptor(Integer.TYPE));
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    public static String getUnknownKeyArgument(String keyArgument) {
        return "got an unexpected keyword argument '" + keyArgument + "'";
    }

    public static String getTooManyPositionalArguments(int numOfArguments) {
        return "Got too many positional arguments (" + numOfArguments + ")";
    }
}

