/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonBytecodeToJavaBytecodeTranslator;
import ai.timefold.jpyinterpreter.PythonClassTranslator;
import ai.timefold.jpyinterpreter.PythonFunctionSignature;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.KnownCallImplementor;
import ai.timefold.jpyinterpreter.types.BoundPythonLikeFunction;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonKnownFunctionType;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.util.MethodVisitorAdapters;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class PythonOverloadImplementor {
    public static Comparator<PythonLikeType> TYPE_DEPTH_COMPARATOR = Comparator.comparingInt(PythonLikeType::getDepth).thenComparing(PythonLikeType::getTypeName).thenComparing(PythonLikeType::getJavaTypeInternalName).reversed();
    private static final List<DeferredRunner> deferredRunnerList = new ArrayList<DeferredRunner>();

    public static void deferDispatchesFor(DeferredRunner runner) {
        try {
            PythonOverloadImplementor.createDispatchesFor(runner.run());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void createDeferredDispatches() {
        while (!deferredRunnerList.isEmpty()) {
            ArrayList<DeferredRunner> deferredRunnables = new ArrayList<DeferredRunner>(deferredRunnerList);
            ArrayList deferredTypes = new ArrayList(deferredRunnables.size());
            deferredRunnables.forEach(runner -> {
                try {
                    deferredTypes.add(runner.run());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            });
            deferredTypes.forEach(PythonOverloadImplementor::createDispatchesFor);
            deferredRunnerList.subList(0, deferredRunnables.size()).clear();
        }
    }

    public static void createDispatchesFor(PythonLikeType pythonLikeType) {
        for (String methodName : pythonLikeType.getKnownMethodsDefinedByClass()) {
            PythonLikeFunction overloadDispatch = PythonOverloadImplementor.createDispatchForMethod(pythonLikeType, methodName, pythonLikeType.getMethodType(methodName).orElseThrow(), pythonLikeType.getMethodKind(methodName).orElse(PythonClassTranslator.PythonMethodKind.VIRTUAL_METHOD));
            pythonLikeType.$setAttribute(methodName, overloadDispatch);
        }
        if (pythonLikeType.getConstructorType().isPresent()) {
            PythonLikeFunction overloadDispatch = PythonOverloadImplementor.createDispatchForMethod(pythonLikeType, "__init__", pythonLikeType.getConstructorType().orElseThrow(), PythonClassTranslator.PythonMethodKind.VIRTUAL_METHOD);
            pythonLikeType.setConstructor(overloadDispatch);
            pythonLikeType.$setAttribute("__init__", overloadDispatch);
        }
    }

    private static PythonLikeFunction createDispatchForMethod(PythonLikeType pythonLikeType, String methodName, PythonKnownFunctionType knownFunctionType, PythonClassTranslator.PythonMethodKind methodKind) {
        String maybeClassName = "org.jpyinterpreter.synthetic." + pythonLikeType.getJavaTypeInternalName().replace('/', '.') + "." + methodName + "$$Dispatcher";
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        ClassWriter classWriter = new ClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(PythonLikeFunction.class)});
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        PythonOverloadImplementor.createDispatchFunction(pythonLikeType, knownFunctionType, classWriter);
        PythonOverloadImplementor.createGetTypeFunction(methodKind, classWriter);
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            Class<?> generatedClass = BuiltinTypes.asmClassLoader.loadClass(className);
            return (PythonLikeFunction)generatedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (" + className + ") despite it being just generated.", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Impossible State: Unable to invoke constructor for generated class (" + className + ").", e);
        }
    }

    private static void createGetTypeFunction(PythonClassTranslator.PythonMethodKind kind, ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        switch (kind) {
            case VIRTUAL_METHOD: {
                methodVisitor.visitFieldInsn(178, Type.getInternalName(BuiltinTypes.class), "FUNCTION_TYPE", Type.getDescriptor(PythonLikeType.class));
                break;
            }
            case STATIC_METHOD: {
                methodVisitor.visitFieldInsn(178, Type.getInternalName(BuiltinTypes.class), "STATIC_FUNCTION_TYPE", Type.getDescriptor(PythonLikeType.class));
                break;
            }
            case CLASS_METHOD: {
                methodVisitor.visitFieldInsn(178, Type.getInternalName(BuiltinTypes.class), "CLASS_FUNCTION_TYPE", Type.getDescriptor(PythonLikeType.class));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled case: " + String.valueOf((Object)kind));
            }
        }
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void createDispatchFunction(PythonLikeType type, PythonKnownFunctionType knownFunctionType, ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), null, null);
        methodVisitor = MethodVisitorAdapters.adapt(methodVisitor, "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}));
        methodVisitor.visitParameter("positionalArguments", 0);
        methodVisitor.visitParameter("namedArguments", 0);
        methodVisitor.visitParameter("callerInstance", 0);
        methodVisitor.visitCode();
        List<PythonFunctionSignature> overloadList = knownFunctionType.getOverloadFunctionSignatureList();
        Map<Integer, List<PythonFunctionSignature>> pythonFunctionSignatureByArgumentLength = overloadList.stream().filter(sig -> sig.getExtraPositionalArgumentsVariableIndex().isEmpty() && sig.getExtraKeywordArgumentsVariableIndex().isEmpty()).collect(Collectors.groupingBy(sig -> sig.getParameterTypes().length));
        Optional<PythonFunctionSignature> maybeGenericFunctionSignature = overloadList.stream().findAny();
        if (overloadList.get(0).isFromArgumentSpec() || pythonFunctionSignatureByArgumentLength.isEmpty()) {
            PythonOverloadImplementor.createGenericDispatch(methodVisitor, type, maybeGenericFunctionSignature, "");
        } else {
            int i2;
            int[] argCounts = pythonFunctionSignatureByArgumentLength.keySet().stream().sorted().mapToInt(i -> i).toArray();
            Label[] argCountLabel = new Label[argCounts.length];
            Label defaultCase = new Label();
            for (i2 = 0; i2 < argCountLabel.length; ++i2) {
                argCountLabel[i2] = new Label();
            }
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "size", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), true);
            if (!overloadList.get(0).getMethodDescriptor().getMethodType().isStatic()) {
                methodVisitor.visitInsn(2);
                methodVisitor.visitInsn(96);
            }
            methodVisitor.visitLookupSwitchInsn(defaultCase, argCounts, argCountLabel);
            for (i2 = 0; i2 < argCounts.length; ++i2) {
                methodVisitor.visitLabel(argCountLabel[i2]);
                PythonOverloadImplementor.createDispatchForArgCount(methodVisitor, argCounts[i2], type, pythonFunctionSignatureByArgumentLength.get(argCounts[i2]), maybeGenericFunctionSignature);
            }
            methodVisitor.visitLabel(defaultCase);
            PythonOverloadImplementor.createGenericDispatch(methodVisitor, type, maybeGenericFunctionSignature, "No overload has the given argcount. Possible overload(s) are: " + knownFunctionType.getOverloadFunctionSignatureList().stream().map(PythonFunctionSignature::toString).collect(Collectors.joining(",\n")));
        }
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void createDispatchForArgCount(MethodVisitor methodVisitor, int argCount, PythonLikeType type, List<PythonFunctionSignature> functionSignatureList, Optional<PythonFunctionSignature> maybeGenericDispatch) {
        int i;
        int MATCHING_OVERLOAD_SET_VARIABLE_INDEX = 3;
        methodVisitor.visitTypeInsn(187, Type.getInternalName(HashSet.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)functionSignatureList.size());
        methodVisitor.visitMethodInsn(183, Type.getInternalName(HashSet.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        for (int i2 = 0; i2 < functionSignatureList.size(); ++i2) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn((Object)i2);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Integer.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.INT_TYPE}), false);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitVarInsn(58, 3);
        int startIndex = 0;
        if (!functionSignatureList.get(0).getMethodDescriptor().getMethodType().isStatic()) {
            startIndex = 1;
        }
        methodVisitor.visitVarInsn(25, 1);
        for (int i3 = 0; i3 < argCount; ++i3) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn((Object)(i3 + startIndex));
            methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
            SortedMap<PythonLikeType, List<PythonFunctionSignature>> typeToPossibleSignatures = PythonOverloadImplementor.getTypeForParameter(functionSignatureList, i3);
            Label endOfInstanceOfIfs = new Label();
            for (PythonLikeType pythonLikeType : typeToPossibleSignatures.keySet()) {
                Label nextIf = new Label();
                methodVisitor.visitInsn(89);
                methodVisitor.visitTypeInsn(193, pythonLikeType.getJavaTypeInternalName());
                methodVisitor.visitJumpInsn(153, nextIf);
                List matchingOverloadList = (List)typeToPossibleSignatures.get(pythonLikeType);
                if (matchingOverloadList.size() != functionSignatureList.size()) {
                    methodVisitor.visitVarInsn(25, 3);
                    for (int sigIndex = 0; sigIndex < functionSignatureList.size(); ++sigIndex) {
                        if (matchingOverloadList.contains(functionSignatureList.get(sigIndex))) continue;
                        methodVisitor.visitInsn(89);
                        methodVisitor.visitLdcInsn((Object)sigIndex);
                        methodVisitor.visitMethodInsn(184, Type.getInternalName(Integer.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.INT_TYPE}), false);
                        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "remove", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true);
                        methodVisitor.visitInsn(87);
                    }
                    methodVisitor.visitInsn(87);
                    methodVisitor.visitJumpInsn(167, endOfInstanceOfIfs);
                } else {
                    methodVisitor.visitJumpInsn(167, endOfInstanceOfIfs);
                }
                methodVisitor.visitLabel(nextIf);
            }
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "clear", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), true);
            methodVisitor.visitLabel(endOfInstanceOfIfs);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitInsn(87);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "size", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), true);
        Label setIsNotEmpty = new Label();
        methodVisitor.visitJumpInsn(154, setIsNotEmpty);
        PythonOverloadImplementor.createGenericDispatch(methodVisitor, type, maybeGenericDispatch, "No overload match the given arguments. Possible overload(s) for " + argCount + " arguments are: " + functionSignatureList.stream().map(PythonFunctionSignature::toString).collect(Collectors.joining(",\n")));
        methodVisitor.visitLabel(setIsNotEmpty);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Iterable.class), "iterator", Type.getMethodDescriptor((Type)Type.getType(Iterator.class), (Type[])new Type[0]), true);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Iterator.class), "next", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(Integer.class));
        methodVisitor.visitMethodInsn(182, Type.getInternalName(Integer.class), "intValue", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
        Label defaultHandler = new Label();
        Label[] signatureIndexToDispatch = new Label[functionSignatureList.size()];
        for (i = 0; i < functionSignatureList.size(); ++i) {
            signatureIndexToDispatch[i] = new Label();
        }
        methodVisitor.visitTableSwitchInsn(0, functionSignatureList.size() - 1, defaultHandler, signatureIndexToDispatch);
        for (i = 0; i < functionSignatureList.size(); ++i) {
            methodVisitor.visitLabel(signatureIndexToDispatch[i]);
            PythonFunctionSignature matchingSignature = functionSignatureList.get(i);
            methodVisitor.visitVarInsn(25, 1);
            if (startIndex != 0) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)0);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
                methodVisitor.visitTypeInsn(192, matchingSignature.getMethodDescriptor().getDeclaringClassInternalName());
                methodVisitor.visitInsn(95);
            }
            for (int argIndex = 0; argIndex < argCount; ++argIndex) {
                PythonLikeType parameterType = matchingSignature.getParameterTypes()[argIndex];
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)(argIndex + startIndex));
                methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
                methodVisitor.visitTypeInsn(192, parameterType.getJavaTypeInternalName());
                methodVisitor.visitInsn(95);
            }
            methodVisitor.visitInsn(87);
            matchingSignature.getMethodDescriptor().callMethod(methodVisitor);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitLabel(defaultHandler);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(IllegalStateException.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)"Return signature index is out of bounds");
        methodVisitor.visitMethodInsn(183, Type.getInternalName(IllegalStateException.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitInsn(191);
    }

    private static void createGenericDispatch(MethodVisitor methodVisitor, PythonLikeType type, Optional<PythonFunctionSignature> maybeGenericDispatch, String errorMessage) {
        if (maybeGenericDispatch.isEmpty()) {
            methodVisitor.visitTypeInsn(187, Type.getInternalName(TypeError.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonOverloadImplementor.class), "getCallErrorInfo", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class)}), false);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitLdcInsn((Object)errorMessage);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), false);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(TypeError.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitInsn(191);
        } else {
            PythonFunctionSignature functionSignature = maybeGenericDispatch.get();
            if (functionSignature.getMethodDescriptor().getMethodType() != MethodDescriptor.MethodType.STATIC) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn((Object)0);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeObject.class));
                methodVisitor.visitVarInsn(25, 0);
                if (functionSignature.getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.CLASS) {
                    methodVisitor.visitMethodInsn(184, Type.getInternalName(BoundPythonLikeFunction.class), "boundToTypeOfObject", Type.getMethodDescriptor((Type)Type.getType(BoundPythonLikeFunction.class), (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeFunction.class)}), false);
                } else {
                    methodVisitor.visitTypeInsn(187, Type.getInternalName(BoundPythonLikeFunction.class));
                    methodVisitor.visitInsn(91);
                    methodVisitor.visitInsn(91);
                    methodVisitor.visitInsn(87);
                    methodVisitor.visitMethodInsn(183, Type.getInternalName(BoundPythonLikeFunction.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeFunction.class)}), false);
                }
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitInsn(89);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "size", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), true);
                methodVisitor.visitLdcInsn((Object)1);
                methodVisitor.visitInsn(95);
                methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "subList", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE}), true);
            } else {
                methodVisitor.visitVarInsn(25, 1);
            }
            methodVisitor.visitVarInsn(25, 2);
            KnownCallImplementor.callUnpackListAndMap(functionSignature.getDefaultArgumentHolderClassInternalName(), functionSignature.getMethodDescriptor(), methodVisitor);
            methodVisitor.visitInsn(176);
        }
    }

    public static String getCallErrorInfo(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> namedArgs) {
        return "Could not find an overload that accept " + positionalArgs.stream().map(arg -> arg.$getType().getTypeName()).collect(Collectors.joining(", ", "(", ") argument types. "));
    }

    private static SortedMap<PythonLikeType, List<PythonFunctionSignature>> getTypeForParameter(List<PythonFunctionSignature> functionSignatureList, int parameter) {
        TreeMap<PythonLikeType, List<PythonFunctionSignature>> out = new TreeMap<PythonLikeType, List<PythonFunctionSignature>>(TYPE_DEPTH_COMPARATOR);
        for (PythonFunctionSignature functionSignature : functionSignatureList) {
            out.computeIfAbsent(functionSignature.getParameterTypes()[parameter], type -> new ArrayList()).add(functionSignature);
        }
        return out;
    }

    public static interface DeferredRunner {
        public PythonLikeType run() throws NoSuchMethodException;
    }
}

