/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.collections;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeSet;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public class PythonLikeFrozenSet
extends AbstractPythonLikeObject
implements Set<PythonLikeObject> {
    public final Set<PythonLikeObject> delegate;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.FROZEN_SET_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.size() == 0) {
                return new PythonLikeFrozenSet();
            }
            if (positionalArguments.size() == 1) {
                return new PythonLikeFrozenSet((PythonLikeObject)positionalArguments.get(0));
            }
            throw new ValueError("frozenset expects 0 or 1 arguments, got " + positionalArguments.size());
        });
        BuiltinTypes.FROZEN_SET_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonLikeFrozenSet.class.getMethod("getLength", new Class[0]));
        BuiltinTypes.FROZEN_SET_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonLikeFrozenSet.class.getMethod("getIterator", new Class[0]));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonLikeFrozenSet.class.getMethod("containsItem", PythonLikeObject.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("isdisjoint", PythonLikeFrozenSet.class.getMethod("isDisjoint", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("isdisjoint", PythonLikeFrozenSet.class.getMethod("isDisjoint", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("issubset", PythonLikeFrozenSet.class.getMethod("isSubset", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN_OR_EQUAL, PythonLikeFrozenSet.class.getMethod("isSubset", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN, PythonLikeFrozenSet.class.getMethod("isStrictSubset", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("issubset", PythonLikeFrozenSet.class.getMethod("isSubset", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN_OR_EQUAL, PythonLikeFrozenSet.class.getMethod("isSubset", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN, PythonLikeFrozenSet.class.getMethod("isStrictSubset", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("issuperset", PythonLikeFrozenSet.class.getMethod("isSuperset", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN_OR_EQUAL, PythonLikeFrozenSet.class.getMethod("isSuperset", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN, PythonLikeFrozenSet.class.getMethod("isStrictSuperset", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("issuperset", PythonLikeFrozenSet.class.getMethod("isSuperset", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN_OR_EQUAL, PythonLikeFrozenSet.class.getMethod("isSuperset", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN, PythonLikeFrozenSet.class.getMethod("isStrictSuperset", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("union", PythonLikeFrozenSet.class.getMethod("union", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("union", PythonLikeFrozenSet.class.getMethod("union", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.OR, PythonLikeFrozenSet.class.getMethod("union", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.OR, PythonLikeFrozenSet.class.getMethod("union", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("intersection", PythonLikeFrozenSet.class.getMethod("intersection", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("intersection", PythonLikeFrozenSet.class.getMethod("intersection", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.AND, PythonLikeFrozenSet.class.getMethod("intersection", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.AND, PythonLikeFrozenSet.class.getMethod("intersection", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("difference", PythonLikeFrozenSet.class.getMethod("difference", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("difference", PythonLikeFrozenSet.class.getMethod("difference", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.SUBTRACT, PythonLikeFrozenSet.class.getMethod("difference", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.SUBTRACT, PythonLikeFrozenSet.class.getMethod("difference", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("symmetric_difference", PythonLikeFrozenSet.class.getMethod("symmetricDifference", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("symmetric_difference", PythonLikeFrozenSet.class.getMethod("symmetricDifference", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.XOR, PythonLikeFrozenSet.class.getMethod("symmetricDifference", PythonLikeSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addBinaryMethod(PythonBinaryOperator.XOR, PythonLikeFrozenSet.class.getMethod("symmetricDifference", PythonLikeFrozenSet.class));
        BuiltinTypes.FROZEN_SET_TYPE.addMethod("copy", PythonLikeFrozenSet.class.getMethod("copy", new Class[0]));
        return BuiltinTypes.FROZEN_SET_TYPE;
    }

    private static UnsupportedOperationException modificationError() {
        return new UnsupportedOperationException("frozenset cannot be modified once created");
    }

    public PythonLikeFrozenSet() {
        super(BuiltinTypes.FROZEN_SET_TYPE);
        this.delegate = new HashSet<PythonLikeObject>();
    }

    public PythonLikeFrozenSet(PythonLikeObject iterable) {
        super(BuiltinTypes.FROZEN_SET_TYPE);
        Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(iterable));
        this.delegate = new HashSet<PythonLikeObject>();
        iterator.forEachRemaining(this.delegate::add);
    }

    public void reverseAdd(PythonLikeObject item) {
        this.delegate.add(item);
    }

    public PythonInteger getLength() {
        return PythonInteger.valueOf(this.delegate.size());
    }

    public PythonBoolean containsItem(PythonLikeObject query) {
        return PythonBoolean.valueOf(this.delegate.contains(query));
    }

    public DelegatePythonIterator getIterator() {
        return new DelegatePythonIterator<PythonLikeObject>(this.delegate.iterator());
    }

    public PythonBoolean isDisjoint(PythonLikeSet other) {
        return PythonBoolean.valueOf(Collections.disjoint(this.delegate, other.delegate));
    }

    public PythonBoolean isDisjoint(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(Collections.disjoint(this.delegate, other.delegate));
    }

    public PythonBoolean isSubset(PythonLikeSet other) {
        return PythonBoolean.valueOf(other.delegate.containsAll(this.delegate));
    }

    public PythonBoolean isSubset(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(other.delegate.containsAll(this.delegate));
    }

    public PythonBoolean isStrictSubset(PythonLikeSet other) {
        return PythonBoolean.valueOf(other.delegate.containsAll(this.delegate) && !this.delegate.containsAll(other.delegate));
    }

    public PythonBoolean isStrictSubset(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(other.delegate.containsAll(this.delegate) && !this.delegate.containsAll(other.delegate));
    }

    public PythonBoolean isSuperset(PythonLikeSet other) {
        return PythonBoolean.valueOf(this.delegate.containsAll(other.delegate));
    }

    public PythonBoolean isSuperset(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(this.delegate.containsAll(other.delegate));
    }

    public PythonBoolean isStrictSuperset(PythonLikeSet other) {
        return PythonBoolean.valueOf(this.delegate.containsAll(other.delegate) && !other.delegate.containsAll(this.delegate));
    }

    public PythonBoolean isStrictSuperset(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(this.delegate.containsAll(other.delegate) && !other.delegate.containsAll(this.delegate));
    }

    public PythonLikeFrozenSet union(PythonLikeSet other) {
        PythonLikeFrozenSet out = new PythonLikeFrozenSet();
        out.delegate.addAll(this.delegate);
        out.delegate.addAll(other.delegate);
        return out;
    }

    public PythonLikeFrozenSet union(PythonLikeFrozenSet other) {
        PythonLikeFrozenSet out = new PythonLikeFrozenSet();
        out.delegate.addAll(this.delegate);
        out.delegate.addAll(other.delegate);
        return out;
    }

    public PythonLikeFrozenSet intersection(PythonLikeSet other) {
        PythonLikeFrozenSet out = new PythonLikeFrozenSet();
        out.delegate.addAll(this.delegate);
        out.delegate.retainAll(other.delegate);
        return out;
    }

    public PythonLikeFrozenSet intersection(PythonLikeFrozenSet other) {
        PythonLikeFrozenSet out = new PythonLikeFrozenSet();
        out.delegate.addAll(this.delegate);
        out.delegate.retainAll(other.delegate);
        return out;
    }

    public PythonLikeFrozenSet difference(PythonLikeSet other) {
        PythonLikeFrozenSet out = new PythonLikeFrozenSet();
        out.delegate.addAll(this.delegate);
        out.delegate.removeAll(other.delegate);
        return out;
    }

    public PythonLikeFrozenSet difference(PythonLikeFrozenSet other) {
        PythonLikeFrozenSet out = new PythonLikeFrozenSet();
        out.delegate.addAll(this.delegate);
        out.delegate.removeAll(other.delegate);
        return out;
    }

    public PythonLikeFrozenSet symmetricDifference(PythonLikeSet other) {
        PythonLikeFrozenSet out = new PythonLikeFrozenSet();
        out.delegate.addAll(this.delegate);
        other.delegate.stream().filter(Predicate.not(out.delegate::add)).forEach(out.delegate::remove);
        return out;
    }

    public PythonLikeFrozenSet symmetricDifference(PythonLikeFrozenSet other) {
        PythonLikeFrozenSet out = new PythonLikeFrozenSet();
        out.delegate.addAll(this.delegate);
        other.delegate.stream().filter(Predicate.not(out.delegate::add)).forEach(out.delegate::remove);
        return out;
    }

    public PythonLikeFrozenSet copy() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<PythonLikeObject> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.delegate.toArray(ts);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean add(PythonLikeObject pythonLikeObject) {
        throw PythonLikeFrozenSet.modificationError();
    }

    @Override
    public boolean remove(Object o) {
        throw PythonLikeFrozenSet.modificationError();
    }

    @Override
    public boolean addAll(Collection<? extends PythonLikeObject> collection) {
        throw PythonLikeFrozenSet.modificationError();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw PythonLikeFrozenSet.modificationError();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw PythonLikeFrozenSet.modificationError();
    }

    @Override
    public void clear() {
        throw PythonLikeFrozenSet.modificationError();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Set) {
            Set other = (Set)o;
            if (other.size() != this.size()) {
                return false;
            }
            return this.containsAll(other) && other.containsAll(this);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public PythonInteger $method$__hash__() {
        return PythonInteger.valueOf(this.hashCode());
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonLikeFrozenSet::registerMethods);
    }
}

