/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.PythonCompiledFunction;
import ai.timefold.jpyinterpreter.PythonGeneratorTranslator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonCell;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class GeneratorLocalVariableHelper
extends LocalVariableHelper {
    final ClassWriter classWriter;
    final String classInternalName;
    final int cellStart;
    final int freeStart;
    int maxTemps;
    Map<Integer, String> slotToLocalName;
    Map<Integer, String> slotToLocalTypeDescriptor;

    public GeneratorLocalVariableHelper(ClassWriter classWriter, String classInternalName, Type[] parameters, PythonCompiledFunction compiledFunction) {
        super(parameters, compiledFunction);
        int i;
        this.classWriter = classWriter;
        this.classInternalName = classInternalName;
        this.cellStart = compiledFunction.co_varnames.size();
        this.freeStart = compiledFunction.co_varnames.size() + compiledFunction.co_cellvars.size();
        this.slotToLocalName = new HashMap<Integer, String>();
        this.slotToLocalTypeDescriptor = new HashMap<Integer, String>();
        for (i = 0; i < compiledFunction.co_varnames.size(); ++i) {
            this.slotToLocalName.put(i, compiledFunction.co_varnames.get(i));
        }
        for (i = 0; i < compiledFunction.co_cellvars.size(); ++i) {
            this.slotToLocalName.put(i + compiledFunction.co_varnames.size(), compiledFunction.co_cellvars.get(i));
        }
        for (i = 0; i < compiledFunction.co_freevars.size(); ++i) {
            this.slotToLocalName.put(i + compiledFunction.co_varnames.size() + compiledFunction.co_cellvars.size(), compiledFunction.co_freevars.get(i));
        }
        for (i = 0; i < compiledFunction.co_varnames.size(); ++i) {
            this.slotToLocalTypeDescriptor.put(i, Type.getDescriptor(PythonLikeObject.class));
        }
        for (i = 0; i < compiledFunction.co_cellvars.size(); ++i) {
            this.slotToLocalTypeDescriptor.put(i + compiledFunction.co_varnames.size(), Type.getDescriptor(PythonCell.class));
        }
        for (i = 0; i < compiledFunction.co_freevars.size(); ++i) {
            this.slotToLocalTypeDescriptor.put(i + compiledFunction.co_varnames.size() + compiledFunction.co_cellvars.size(), Type.getDescriptor(PythonCell.class));
        }
    }

    GeneratorLocalVariableHelper(Type[] parameters, int argcount, int parameterSlotsEnd, int pythonCellVariablesStart, int pythonFreeVariablesStart, int pythonLocalVariablesSlotEnd, int pythonBoundVariables, int pythonFreeVariables, Map<Integer, Integer> boundCellIndexToVariableIndex, int currentExceptionVariableSlot, int callKeywordsSlot, Map<Integer, Integer> exceptionTableTargetToSavedStackMap, ClassWriter classWriter, String classInternalName, int maxTemps, int cellStart, int freeStart, Map<Integer, String> slotToLocalName, Map<Integer, String> slotToLocalTypeDescriptor) {
        super(parameters, argcount, parameterSlotsEnd, pythonCellVariablesStart, pythonFreeVariablesStart, pythonLocalVariablesSlotEnd, pythonBoundVariables, pythonFreeVariables, boundCellIndexToVariableIndex, currentExceptionVariableSlot, callKeywordsSlot, exceptionTableTargetToSavedStackMap);
        this.classWriter = classWriter;
        this.classInternalName = classInternalName;
        this.maxTemps = maxTemps;
        this.cellStart = cellStart;
        this.freeStart = freeStart;
        this.slotToLocalName = new HashMap<Integer, String>(slotToLocalName);
        this.slotToLocalTypeDescriptor = new HashMap<Integer, String>(slotToLocalTypeDescriptor);
    }

    @Override
    public GeneratorLocalVariableHelper copy() {
        GeneratorLocalVariableHelper out = new GeneratorLocalVariableHelper(this.parameters, this.argcount, this.parameterSlotsEnd, this.pythonCellVariablesStart, this.pythonFreeVariablesStart, this.pythonLocalVariablesSlotEnd, this.pythonBoundVariables, this.pythonFreeVariables, this.boundCellIndexToVariableIndex, this.currentExceptionVariableSlot, this.callKeywordsSlot, this.exceptionTableTargetToSavedStackMap, this.classWriter, this.classInternalName, this.maxTemps, this.cellStart, this.freeStart, this.slotToLocalName, this.slotToLocalTypeDescriptor);
        out.usedLocals = this.usedLocals;
        return out;
    }

    private String slotToFieldName(int slot) {
        return "$temp" + slot;
    }

    @Override
    public int newLocal() {
        int slot = this.pythonLocalVariablesSlotEnd + this.usedLocals;
        ++this.usedLocals;
        if (this.usedLocals > this.maxTemps) {
            this.maxTemps = this.usedLocals;
            this.classWriter.visitField(2, this.slotToFieldName(slot), Type.getDescriptor(Object.class), null, null);
        }
        return slot;
    }

    @Override
    public void freeLocal() {
        --this.usedLocals;
    }

    @Override
    public int getUsedLocals() {
        return this.usedLocals;
    }

    @Override
    public void readLocal(MethodVisitor methodVisitor, int local) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.classInternalName, this.slotToLocalName.get(local), this.slotToLocalTypeDescriptor.get(local));
    }

    @Override
    public void writeLocal(MethodVisitor methodVisitor, int local) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(181, this.classInternalName, this.slotToLocalName.get(local), this.slotToLocalTypeDescriptor.get(local));
    }

    @Override
    public void readCell(MethodVisitor methodVisitor, int cell) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.classInternalName, this.slotToLocalName.get(this.cellStart + cell), this.slotToLocalTypeDescriptor.get(this.cellStart + cell));
    }

    @Override
    public void writeCell(MethodVisitor methodVisitor, int cell) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(181, this.classInternalName, this.slotToLocalName.get(this.cellStart + cell), this.slotToLocalTypeDescriptor.get(this.cellStart + cell));
    }

    @Override
    public void writeFreeCell(MethodVisitor methodVisitor, int cell) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(181, this.classInternalName, this.slotToLocalName.get(this.freeStart + cell), this.slotToLocalTypeDescriptor.get(this.freeStart + cell));
    }

    @Override
    public void readCurrentException(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.classInternalName, "$currentException", Type.getDescriptor(Throwable.class));
    }

    @Override
    public void writeCurrentException(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(181, this.classInternalName, "$currentException", Type.getDescriptor(Throwable.class));
    }

    @Override
    public void readExceptionTableTargetStack(MethodVisitor methodVisitor, int target) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.classInternalName, PythonGeneratorTranslator.exceptionHandlerTargetStackLocal(target), Type.getDescriptor(PythonLikeObject[].class));
    }

    @Override
    public void writeExceptionTableTargetStack(MethodVisitor methodVisitor, int target) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(181, this.classInternalName, PythonGeneratorTranslator.exceptionHandlerTargetStackLocal(target), Type.getDescriptor(PythonLikeObject[].class));
    }

    @Override
    public void readTemp(MethodVisitor methodVisitor, Type type, int temp) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.classInternalName, this.slotToFieldName(temp), Type.getDescriptor(Object.class));
        switch (type.getSort()) {
            case 10: {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
                return;
            }
            case 5: {
                methodVisitor.visitTypeInsn(192, Type.getInternalName(Integer.class));
                methodVisitor.visitMethodInsn(182, Type.getInternalName(Integer.class), "intValue", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
            }
        }
        throw new IllegalArgumentException("Unsupported sort: " + type.getSort());
    }

    @Override
    public void writeTemp(MethodVisitor methodVisitor, Type type, int temp) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(95);
        switch (type.getSort()) {
            case 10: {
                break;
            }
            case 5: {
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Integer.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.INT_TYPE}), false);
            }
            default: {
                throw new IllegalArgumentException("Unsupported sort: " + type.getSort());
            }
        }
        methodVisitor.visitFieldInsn(181, this.classInternalName, this.slotToFieldName(temp), Type.getDescriptor(Object.class));
    }

    @Override
    public void incrementTemp(MethodVisitor methodVisitor, int temp) {
        this.readTemp(methodVisitor, Type.INT_TYPE, temp);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(96);
        this.writeTemp(methodVisitor, Type.INT_TYPE, temp);
    }
}

