/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import java.util.OptionalInt;

public record PythonBytecodeInstruction(String opname, int offset, int arg, String argRepr, OptionalInt startsLine, boolean isJumpTarget) {
    public static PythonBytecodeInstruction atOffset(String opname, int offset) {
        return new PythonBytecodeInstruction(opname, offset, 0, "", OptionalInt.empty(), false);
    }

    public static PythonBytecodeInstruction atOffset(OpcodeDescriptor instruction, int offset) {
        return PythonBytecodeInstruction.atOffset(instruction.name(), offset);
    }

    public PythonBytecodeInstruction withArg(int newArg) {
        return new PythonBytecodeInstruction(this.opname, this.offset, newArg, this.argRepr, this.startsLine, this.isJumpTarget);
    }

    public PythonBytecodeInstruction withArgRepr(String newArgRepr) {
        return new PythonBytecodeInstruction(this.opname, this.offset, this.arg, newArgRepr, this.startsLine, this.isJumpTarget);
    }

    public PythonBytecodeInstruction startsLine(int lineNumber) {
        return new PythonBytecodeInstruction(this.opname, this.offset, this.arg, this.argRepr, OptionalInt.of(lineNumber), this.isJumpTarget);
    }

    public PythonBytecodeInstruction withIsJumpTarget(boolean isJumpTarget) {
        return new PythonBytecodeInstruction(this.opname, this.offset, this.arg, this.argRepr, this.startsLine, isJumpTarget);
    }

    public PythonBytecodeInstruction markAsJumpTarget() {
        return new PythonBytecodeInstruction(this.opname, this.offset, this.arg, this.argRepr, this.startsLine, true);
    }

    @Override
    public String toString() {
        return "[%d] %s (%d) %s".formatted(this.offset, this.opname, this.arg, this.isJumpTarget ? "{JUMP TARGET}" : "");
    }
}

