/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonDefaultArgumentImplementor;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;

public class PythonFunctionSignature {
    private final PythonLikeType returnType;
    private final PythonLikeType[] parameterTypes;
    private final MethodDescriptor methodDescriptor;
    private final List<PythonLikeObject> defaultArgumentList;
    private final Map<String, Integer> keywordToArgumentIndexMap;
    private final Optional<Integer> extraPositionalArgumentsVariableIndex;
    private final Optional<Integer> extraKeywordArgumentsVariableIndex;
    private final String defaultArgumentHolderClassInternalName;
    private final ArgumentSpec<?> argumentSpec;
    private final boolean isFromArgumentSpec;

    private static Map<String, Integer> extractKeywordArgument(MethodDescriptor methodDescriptor) {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        int index = 0;
        for (Type parameterType : methodDescriptor.getParameterTypes()) {
            out.put("arg" + index, index);
        }
        return out;
    }

    public static PythonFunctionSignature forMethod(Method method) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(method);
        PythonLikeType returnType = JavaPythonTypeConversionImplementor.getPythonLikeType(method.getReturnType());
        PythonLikeType[] parameterTypes = new PythonLikeType[method.getParameterCount()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = JavaPythonTypeConversionImplementor.getPythonLikeType(method.getParameterTypes()[i]);
        }
        return new PythonFunctionSignature(methodDescriptor, returnType, parameterTypes);
    }

    public PythonFunctionSignature(MethodDescriptor methodDescriptor, PythonLikeType returnType, PythonLikeType ... parameterTypes) {
        this(methodDescriptor, Collections.emptyList(), PythonFunctionSignature.extractKeywordArgument(methodDescriptor), returnType, parameterTypes);
    }

    public PythonFunctionSignature(MethodDescriptor methodDescriptor, PythonLikeType returnType, List<PythonLikeType> parameterTypeList) {
        this(methodDescriptor, Collections.emptyList(), PythonFunctionSignature.extractKeywordArgument(methodDescriptor), returnType, parameterTypeList);
    }

    public PythonFunctionSignature(MethodDescriptor methodDescriptor, List<PythonLikeObject> defaultArgumentList, Map<String, Integer> keywordToArgumentIndexMap, PythonLikeType returnType, PythonLikeType ... parameterTypes) {
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.methodDescriptor = methodDescriptor;
        this.defaultArgumentList = defaultArgumentList;
        this.keywordToArgumentIndexMap = keywordToArgumentIndexMap;
        this.extraPositionalArgumentsVariableIndex = Optional.empty();
        this.extraKeywordArgumentsVariableIndex = Optional.empty();
        this.isFromArgumentSpec = false;
        this.argumentSpec = this.computeArgumentSpec();
        this.defaultArgumentHolderClassInternalName = PythonDefaultArgumentImplementor.createDefaultArgumentFor(methodDescriptor, defaultArgumentList, keywordToArgumentIndexMap, this.getExtraPositionalArgumentsVariableIndex(), this.getExtraKeywordArgumentsVariableIndex(), this.getArgumentSpec());
    }

    public PythonFunctionSignature(MethodDescriptor methodDescriptor, List<PythonLikeObject> defaultArgumentList, Map<String, Integer> keywordToArgumentIndexMap, PythonLikeType returnType, List<PythonLikeType> parameterTypesList) {
        this.returnType = returnType;
        this.parameterTypes = parameterTypesList.toArray(new PythonLikeType[0]);
        this.methodDescriptor = methodDescriptor;
        this.defaultArgumentList = defaultArgumentList;
        this.keywordToArgumentIndexMap = keywordToArgumentIndexMap;
        this.extraPositionalArgumentsVariableIndex = Optional.empty();
        this.extraKeywordArgumentsVariableIndex = Optional.empty();
        this.isFromArgumentSpec = false;
        this.argumentSpec = this.computeArgumentSpec();
        this.defaultArgumentHolderClassInternalName = PythonDefaultArgumentImplementor.createDefaultArgumentFor(methodDescriptor, defaultArgumentList, keywordToArgumentIndexMap, this.getExtraPositionalArgumentsVariableIndex(), this.getExtraKeywordArgumentsVariableIndex(), this.getArgumentSpec());
    }

    public PythonFunctionSignature(MethodDescriptor methodDescriptor, List<PythonLikeObject> defaultArgumentList, Map<String, Integer> keywordToArgumentIndexMap, PythonLikeType returnType, List<PythonLikeType> parameterTypesList, Optional<Integer> extraPositionalArgumentsVariableIndex, Optional<Integer> extraKeywordArgumentsVariableIndex) {
        this.returnType = returnType;
        this.parameterTypes = parameterTypesList.toArray(new PythonLikeType[0]);
        this.methodDescriptor = methodDescriptor;
        this.defaultArgumentList = defaultArgumentList;
        this.keywordToArgumentIndexMap = keywordToArgumentIndexMap;
        this.extraPositionalArgumentsVariableIndex = extraPositionalArgumentsVariableIndex;
        this.extraKeywordArgumentsVariableIndex = extraKeywordArgumentsVariableIndex;
        this.isFromArgumentSpec = false;
        this.argumentSpec = this.computeArgumentSpec();
        this.defaultArgumentHolderClassInternalName = PythonDefaultArgumentImplementor.createDefaultArgumentFor(methodDescriptor, defaultArgumentList, keywordToArgumentIndexMap, extraPositionalArgumentsVariableIndex, extraKeywordArgumentsVariableIndex, this.getArgumentSpec());
    }

    public PythonFunctionSignature(MethodDescriptor methodDescriptor, List<PythonLikeObject> defaultArgumentList, Map<String, Integer> keywordToArgumentIndexMap, PythonLikeType returnType, List<PythonLikeType> parameterTypesList, Optional<Integer> extraPositionalArgumentsVariableIndex, Optional<Integer> extraKeywordArgumentsVariableIndex, ArgumentSpec<?> argumentSpec) {
        this.returnType = returnType;
        this.parameterTypes = parameterTypesList.toArray(new PythonLikeType[0]);
        this.methodDescriptor = methodDescriptor;
        this.defaultArgumentList = defaultArgumentList;
        this.keywordToArgumentIndexMap = keywordToArgumentIndexMap;
        this.extraPositionalArgumentsVariableIndex = extraPositionalArgumentsVariableIndex;
        this.extraKeywordArgumentsVariableIndex = extraKeywordArgumentsVariableIndex;
        this.argumentSpec = argumentSpec;
        this.isFromArgumentSpec = true;
        this.defaultArgumentHolderClassInternalName = PythonDefaultArgumentImplementor.createDefaultArgumentFor(methodDescriptor, defaultArgumentList, keywordToArgumentIndexMap, extraPositionalArgumentsVariableIndex, extraKeywordArgumentsVariableIndex, argumentSpec);
    }

    private ArgumentSpec<?> computeArgumentSpec() {
        int i;
        ArgumentSpec argumentSpec = ArgumentSpec.forFunctionReturning(this.getMethodDescriptor().getMethodName(), this.getReturnType().getJavaTypeInternalName());
        for (i = 0; i < this.getParameterTypes().length - this.getDefaultArgumentList().size(); ++i) {
            if (this.getExtraPositionalArgumentsVariableIndex().isPresent() && this.getExtraPositionalArgumentsVariableIndex().get() == i || this.getExtraKeywordArgumentsVariableIndex().isPresent() && this.getExtraKeywordArgumentsVariableIndex().get() == i) continue;
            int argIndex = i;
            Optional<String> argumentName = this.getKeywordToArgumentIndexMap().entrySet().stream().filter(e -> ((Integer)e.getValue()).equals(argIndex)).map(Map.Entry::getKey).findAny();
            argumentSpec = argumentName.isEmpty() ? argumentSpec.addArgument("$arg" + i, this.getParameterTypes()[i].getJavaTypeInternalName()) : argumentSpec.addArgument(argumentName.get(), this.getParameterTypes()[i].getJavaTypeInternalName());
        }
        for (i = this.getParameterTypes().length - this.getDefaultArgumentList().size(); i < this.getParameterTypes().length; ++i) {
            if (this.getExtraPositionalArgumentsVariableIndex().isPresent() && this.getExtraPositionalArgumentsVariableIndex().get() == i || this.getExtraKeywordArgumentsVariableIndex().isPresent() && this.getExtraKeywordArgumentsVariableIndex().get() == i) continue;
            PythonLikeObject defaultValue = this.getDefaultArgumentList().get(this.getDefaultArgumentList().size() - (this.getParameterTypes().length - i));
            int argIndex = i;
            Optional<String> argumentName = this.getKeywordToArgumentIndexMap().entrySet().stream().filter(e -> ((Integer)e.getValue()).equals(argIndex)).map(Map.Entry::getKey).findAny();
            argumentSpec = argumentName.isEmpty() ? argumentSpec.addArgument("$arg" + i, this.getParameterTypes()[i].getJavaTypeInternalName(), defaultValue) : argumentSpec.addArgument(argumentName.get(), this.getParameterTypes()[i].getJavaTypeInternalName(), defaultValue);
        }
        if (this.getExtraPositionalArgumentsVariableIndex().isPresent()) {
            argumentSpec = argumentSpec.addExtraPositionalVarArgument("*vargs");
        }
        if (this.getExtraKeywordArgumentsVariableIndex().isPresent()) {
            argumentSpec = argumentSpec.addExtraKeywordVarArgument("**kwargs");
        }
        return argumentSpec;
    }

    public ArgumentSpec<?> getArgumentSpec() {
        return this.argumentSpec;
    }

    public PythonLikeType getReturnType() {
        return this.returnType;
    }

    public PythonLikeType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public boolean isFromArgumentSpec() {
        return this.isFromArgumentSpec;
    }

    public List<PythonLikeObject> getDefaultArgumentList() {
        return this.defaultArgumentList;
    }

    public Map<String, Integer> getKeywordToArgumentIndexMap() {
        return this.keywordToArgumentIndexMap;
    }

    public Optional<Integer> getExtraPositionalArgumentsVariableIndex() {
        return this.extraPositionalArgumentsVariableIndex;
    }

    public Optional<Integer> getExtraKeywordArgumentsVariableIndex() {
        return this.extraKeywordArgumentsVariableIndex;
    }

    public String getDefaultArgumentHolderClassInternalName() {
        return this.defaultArgumentHolderClassInternalName;
    }

    public boolean isVirtualMethod() {
        switch (this.getMethodDescriptor().getMethodType()) {
            case VIRTUAL: 
            case INTERFACE: 
            case CONSTRUCTOR: {
                return true;
            }
        }
        return false;
    }

    public boolean isClassMethod() {
        return this.getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.CLASS;
    }

    public boolean isStaticMethod() {
        return this.getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.STATIC;
    }

    private int getPositionalParameterCount(int originalPositionalParameterCount) {
        if (this.getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.CLASS) {
            return originalPositionalParameterCount + 1;
        }
        return originalPositionalParameterCount;
    }

    private List<PythonLikeType> getCallParameterList(List<PythonLikeType> callStackTypeList) {
        if (this.getMethodDescriptor().getMethodType() == MethodDescriptor.MethodType.CLASS) {
            ArrayList<PythonLikeType> actualCallParameters = new ArrayList<PythonLikeType>();
            actualCallParameters.add(BuiltinTypes.TYPE_TYPE);
            actualCallParameters.addAll(callStackTypeList);
            return actualCallParameters;
        }
        return callStackTypeList;
    }

    public boolean matchesParameters(PythonLikeType ... callParameters) {
        return this.getArgumentSpec().verifyMatchesCallSignature(this.getPositionalParameterCount(callParameters.length), Collections.emptyList(), this.getCallParameterList(List.of(callParameters)));
    }

    public boolean matchesParameters(int positionalArgumentCount, List<String> keywordArgumentNameList, List<PythonLikeType> callStackTypeList) {
        return this.getArgumentSpec().verifyMatchesCallSignature(this.getPositionalParameterCount(positionalArgumentCount), keywordArgumentNameList, this.getCallParameterList(callStackTypeList));
    }

    public boolean moreSpecificThan(PythonFunctionSignature other) {
        if (other.getParameterTypes().length < this.getParameterTypes().length && (other.getExtraPositionalArgumentsVariableIndex().isPresent() || other.getExtraKeywordArgumentsVariableIndex().isPresent())) {
            return true;
        }
        if (other.getParameterTypes().length > this.getParameterTypes().length && (this.getExtraPositionalArgumentsVariableIndex().isPresent() || this.getExtraKeywordArgumentsVariableIndex().isPresent())) {
            return false;
        }
        if (other.getParameterTypes().length != this.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < this.getParameterTypes().length; ++i) {
            PythonLikeType overloadParameterType = this.getParameterTypes()[i];
            PythonLikeType otherParameterType = other.getParameterTypes()[i];
            if (otherParameterType.equals(overloadParameterType) || !otherParameterType.isSubclassOf(overloadParameterType)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonFunctionSignature that = (PythonFunctionSignature)o;
        return this.getReturnType().equals(that.getReturnType()) && Arrays.equals(this.getParameterTypes(), that.getParameterTypes()) && this.getExtraPositionalArgumentsVariableIndex().equals(that.getExtraPositionalArgumentsVariableIndex()) && this.getExtraKeywordArgumentsVariableIndex().equals(that.getExtraKeywordArgumentsVariableIndex());
    }

    public int hashCode() {
        int result = Objects.hash(this.getReturnType(), this.getExtraPositionalArgumentsVariableIndex(), this.getExtraKeywordArgumentsVariableIndex());
        result = 31 * result + Arrays.hashCode(this.getParameterTypes());
        return result;
    }

    public String toString() {
        return this.getMethodDescriptor().getMethodName() + Arrays.stream(this.getParameterTypes()).map(PythonLikeType::toString).collect(Collectors.joining(", ", "(", ") -> ")) + String.valueOf(this.getReturnType());
    }
}

