/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.BinaryDunderBuiltin;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonByteArray;
import ai.timefold.jpyinterpreter.types.PythonBytes;
import ai.timefold.jpyinterpreter.types.PythonLikeComparable;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonSlice;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeList;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.lookup.IndexError;
import ai.timefold.jpyinterpreter.types.errors.lookup.LookupError;
import ai.timefold.jpyinterpreter.types.errors.unicode.UnicodeDecodeError;
import ai.timefold.jpyinterpreter.types.errors.unicode.UnicodeEncodeError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.util.DefaultFormatSpec;
import ai.timefold.jpyinterpreter.util.StringFormatter;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningImmutable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PythonString
extends AbstractPythonLikeObject
implements PythonLikeComparable<PythonString>,
PlanningImmutable {
    public final String value;
    public static final PythonString EMPTY = new PythonString("");

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        PythonLikeComparable.setup(BuiltinTypes.STRING_TYPE);
        BuiltinTypes.STRING_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.size() == 1) {
                return UnaryDunderBuiltin.STR.invoke((PythonLikeObject)positionalArguments.get(0));
            }
            if (positionalArguments.size() == 2) {
                if (!(positionalArguments.get(0) instanceof PythonBytes) || !(positionalArguments.get(1) instanceof PythonString)) {
                    throw new TypeError();
                }
                return ((PythonBytes)positionalArguments.get(0)).decode((PythonString)positionalArguments.get(1));
            }
            if (positionalArguments.size() == 3) {
                if (!(positionalArguments.get(0) instanceof PythonBytes && positionalArguments.get(1) instanceof PythonString && positionalArguments.get(2) instanceof PythonString)) {
                    throw new TypeError();
                }
                return ((PythonBytes)positionalArguments.get(0)).decode((PythonString)positionalArguments.get(1), (PythonString)positionalArguments.get(2));
            }
            throw new ValueError("str expects 1 or 3 arguments, got " + positionalArguments.size());
        });
        BuiltinTypes.STRING_TYPE.addUnaryMethod(PythonUnaryOperator.REPRESENTATION, PythonString.class.getMethod("repr", new Class[0]));
        BuiltinTypes.STRING_TYPE.addUnaryMethod(PythonUnaryOperator.AS_STRING, PythonString.class.getMethod("asString", new Class[0]));
        BuiltinTypes.STRING_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonString.class.getMethod("getIterator", new Class[0]));
        BuiltinTypes.STRING_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonString.class.getMethod("getLength", new Class[0]));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonString.class.getMethod("getCharAt", PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonString.class.getMethod("getSubstring", PythonSlice.class));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonString.class.getMethod("containsSubstring", PythonString.class));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.ADD, PythonString.class.getMethod("concat", PythonString.class));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonString.class.getMethod("repeat", PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonString.class.getMethod("interpolate", PythonLikeObject.class));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonString.class.getMethod("interpolate", PythonLikeTuple.class));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonString.class.getMethod("interpolate", PythonLikeDict.class));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.FORMAT, PythonString.class.getMethod("formatSelf", new Class[0]));
        BuiltinTypes.STRING_TYPE.addBinaryMethod(PythonBinaryOperator.FORMAT, PythonString.class.getMethod("formatSelf", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("capitalize", PythonString.class.getMethod("capitalize", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("casefold", PythonString.class.getMethod("casefold", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("center", PythonString.class.getMethod("center", PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("center", PythonString.class.getMethod("center", PythonInteger.class, PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("count", PythonString.class.getMethod("count", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("count", PythonString.class.getMethod("count", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("count", PythonString.class.getMethod("count", PythonString.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("endswith", PythonString.class.getMethod("endsWith", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("endswith", PythonString.class.getMethod("endsWith", PythonLikeTuple.class));
        BuiltinTypes.STRING_TYPE.addMethod("endswith", PythonString.class.getMethod("endsWith", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("endswith", PythonString.class.getMethod("endsWith", PythonLikeTuple.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("endswith", PythonString.class.getMethod("endsWith", PythonString.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("endswith", PythonString.class.getMethod("endsWith", PythonLikeTuple.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("expandtabs", PythonString.class.getMethod("expandTabs", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("expandtabs", PythonString.class.getMethod("expandTabs", PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("find", PythonString.class.getMethod("findSubstringIndex", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("find", PythonString.class.getMethod("findSubstringIndex", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("find", PythonString.class.getMethod("findSubstringIndex", PythonString.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("format", ArgumentSpec.forFunctionReturning("format", PythonString.class.getName()).addExtraPositionalVarArgument("vargs").addExtraKeywordVarArgument("kwargs").asPythonFunctionSignature(PythonString.class.getMethod("format", List.class, Map.class)));
        BuiltinTypes.STRING_TYPE.addMethod("format_map", PythonString.class.getMethod("formatMap", PythonLikeDict.class));
        BuiltinTypes.STRING_TYPE.addMethod("index", PythonString.class.getMethod("findSubstringIndexOrError", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("index", PythonString.class.getMethod("findSubstringIndexOrError", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("index", PythonString.class.getMethod("findSubstringIndexOrError", PythonString.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("isalnum", PythonString.class.getMethod("isAlphaNumeric", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isalpha", PythonString.class.getMethod("isAlpha", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isascii", PythonString.class.getMethod("isAscii", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isdecimal", PythonString.class.getMethod("isDecimal", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isdigit", PythonString.class.getMethod("isDigit", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isidentifier", PythonString.class.getMethod("isIdentifier", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("islower", PythonString.class.getMethod("isLower", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isnumeric", PythonString.class.getMethod("isNumeric", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isprintable", PythonString.class.getMethod("isPrintable", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isspace", PythonString.class.getMethod("isSpace", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("istitle", PythonString.class.getMethod("isTitle", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("isupper", PythonString.class.getMethod("isUpper", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("join", PythonString.class.getMethod("join", PythonLikeObject.class));
        BuiltinTypes.STRING_TYPE.addMethod("ljust", PythonString.class.getMethod("leftJustify", PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("ljust", PythonString.class.getMethod("leftJustify", PythonInteger.class, PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("lower", PythonString.class.getMethod("lower", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("lstrip", PythonString.class.getMethod("leftStrip", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("lstrip", PythonString.class.getMethod("leftStrip", PythonNone.class));
        BuiltinTypes.STRING_TYPE.addMethod("lstrip", PythonString.class.getMethod("leftStrip", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("partition", PythonString.class.getMethod("partition", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("removeprefix", PythonString.class.getMethod("removePrefix", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("removesuffix", PythonString.class.getMethod("removeSuffix", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("replace", PythonString.class.getMethod("replaceAll", PythonString.class, PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("replace", PythonString.class.getMethod("replaceUpToCount", PythonString.class, PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("rfind", PythonString.class.getMethod("rightFindSubstringIndex", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("rfind", PythonString.class.getMethod("rightFindSubstringIndex", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("rfind", PythonString.class.getMethod("rightFindSubstringIndex", PythonString.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("rindex", PythonString.class.getMethod("rightFindSubstringIndexOrError", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("rindex", PythonString.class.getMethod("rightFindSubstringIndexOrError", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("rindex", PythonString.class.getMethod("rightFindSubstringIndexOrError", PythonString.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("rjust", PythonString.class.getMethod("rightJustify", PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("rjust", PythonString.class.getMethod("rightJustify", PythonInteger.class, PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("rpartition", PythonString.class.getMethod("rightPartition", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("rsplit", PythonString.class.getMethod("rightSplit", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("rsplit", PythonString.class.getMethod("rightSplit", PythonNone.class));
        BuiltinTypes.STRING_TYPE.addMethod("rsplit", PythonString.class.getMethod("rightSplit", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("rsplit", PythonString.class.getMethod("rightSplit", PythonNone.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("rsplit", PythonString.class.getMethod("rightSplit", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("rstrip", PythonString.class.getMethod("rightStrip", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("rstrip", PythonString.class.getMethod("rightStrip", PythonNone.class));
        BuiltinTypes.STRING_TYPE.addMethod("rstrip", PythonString.class.getMethod("rightStrip", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("split", PythonString.class.getMethod("split", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("split", PythonString.class.getMethod("split", PythonNone.class));
        BuiltinTypes.STRING_TYPE.addMethod("split", PythonString.class.getMethod("split", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("split", PythonString.class.getMethod("split", PythonNone.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("split", PythonString.class.getMethod("split", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("splitlines", PythonString.class.getMethod("splitLines", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("splitlines", PythonString.class.getMethod("splitLines", PythonBoolean.class));
        BuiltinTypes.STRING_TYPE.addMethod("startswith", PythonString.class.getMethod("startsWith", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("startswith", PythonString.class.getMethod("startsWith", PythonLikeTuple.class));
        BuiltinTypes.STRING_TYPE.addMethod("startswith", PythonString.class.getMethod("startsWith", PythonString.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("startswith", PythonString.class.getMethod("startsWith", PythonLikeTuple.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("startswith", PythonString.class.getMethod("startsWith", PythonString.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("startswith", PythonString.class.getMethod("startsWith", PythonLikeTuple.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.STRING_TYPE.addMethod("strip", PythonString.class.getMethod("strip", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("strip", PythonString.class.getMethod("strip", PythonNone.class));
        BuiltinTypes.STRING_TYPE.addMethod("strip", PythonString.class.getMethod("strip", PythonString.class));
        BuiltinTypes.STRING_TYPE.addMethod("swapcase", PythonString.class.getMethod("swapCase", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("title", PythonString.class.getMethod("title", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("translate", PythonString.class.getMethod("translate", PythonLikeObject.class));
        BuiltinTypes.STRING_TYPE.addMethod("upper", PythonString.class.getMethod("upper", new Class[0]));
        BuiltinTypes.STRING_TYPE.addMethod("zfill", PythonString.class.getMethod("zfill", PythonInteger.class));
        return BuiltinTypes.STRING_TYPE;
    }

    public PythonString(String value) {
        super(BuiltinTypes.STRING_TYPE);
        this.value = value;
    }

    public static PythonString valueOf(String value) {
        return new PythonString(value);
    }

    public String getValue() {
        return this.value;
    }

    public final PythonBytes asAsciiBytes() {
        char[] charData = this.value.toCharArray();
        int length = 0;
        for (char charDatum : charData) {
            if (charDatum < '\u00ff') {
                ++length;
                continue;
            }
            length += 2;
        }
        byte[] out = new byte[length];
        int outIndex = 0;
        for (char charDatum : charData) {
            if (charDatum < '\u00ff') {
                out[outIndex] = (byte)charDatum;
                ++outIndex;
                continue;
            }
            out[outIndex] = (byte)((charDatum & 0xFF00) >> 8);
            out[++outIndex] = (byte)(charDatum & 0xFF);
            ++outIndex;
        }
        return new PythonBytes(out);
    }

    public final PythonByteArray asAsciiByteArray() {
        return new PythonByteArray(this.asAsciiBytes().value);
    }

    public PythonBytes encode() {
        try {
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).encode(CharBuffer.wrap(this.value));
            byte[] out = new byte[byteBuffer.limit()];
            byteBuffer.get(out);
            return new PythonBytes(out);
        }
        catch (CharacterCodingException e) {
            throw new UnicodeEncodeError(e.getMessage());
        }
    }

    public PythonBytes encode(PythonString charset) {
        try {
            ByteBuffer byteBuffer = Charset.forName(charset.value).newEncoder().onMalformedInput(CodingErrorAction.REPORT).encode(CharBuffer.wrap(this.value));
            byte[] out = new byte[byteBuffer.limit()];
            byteBuffer.get(out);
            return new PythonBytes(out);
        }
        catch (CharacterCodingException e) {
            throw new UnicodeDecodeError(e.getMessage());
        }
    }

    public PythonBytes encode(PythonString charset, PythonString errorActionString) {
        CodingErrorAction errorAction = switch (errorActionString.value) {
            case "strict" -> CodingErrorAction.REPORT;
            case "ignore" -> CodingErrorAction.IGNORE;
            case "replace" -> CodingErrorAction.REPLACE;
            default -> throw new ValueError(String.valueOf(errorActionString.repr()) + " is not a valid value for errors. Possible values are: \"strict\", \"ignore\", \"replace\".");
        };
        try {
            ByteBuffer byteBuffer = Charset.forName(charset.value).newEncoder().onMalformedInput(errorAction).encode(CharBuffer.wrap(this.value));
            byte[] out = new byte[byteBuffer.limit()];
            byteBuffer.get(out);
            return new PythonBytes(out);
        }
        catch (CharacterCodingException e) {
            throw new UnicodeDecodeError(e.getMessage());
        }
    }

    public int length() {
        return this.value.length();
    }

    public PythonInteger getLength() {
        return PythonInteger.valueOf(this.value.length());
    }

    public PythonString getCharAt(PythonInteger position) {
        int index = PythonSlice.asIntIndexForLength(position, this.value.length());
        if (index >= this.value.length()) {
            throw new IndexError("position " + String.valueOf(position) + " larger than string length " + this.value.length());
        }
        if (index < 0) {
            throw new IndexError("position " + String.valueOf(position) + " is less than 0");
        }
        return new PythonString(Character.toString(this.value.charAt(index)));
    }

    public PythonString getSubstring(PythonSlice slice) {
        int length = this.value.length();
        int start = slice.getStartIndex(length);
        int stop = slice.getStopIndex(length);
        int step = slice.getStrideLength();
        if (step == 1) {
            if (stop <= start) {
                return PythonString.valueOf("");
            }
            return PythonString.valueOf(this.value.substring(start, stop));
        }
        StringBuilder out = new StringBuilder();
        if (step > 0) {
            for (int i = start; i < stop; i += step) {
                out.append(this.value.charAt(i));
            }
        } else {
            for (int i = start; i > stop; i += step) {
                out.append(this.value.charAt(i));
            }
        }
        return PythonString.valueOf(out.toString());
    }

    public PythonBoolean containsSubstring(PythonString substring) {
        return PythonBoolean.valueOf(this.value.contains(substring.value));
    }

    public PythonString concat(PythonString other) {
        if (this.value.isEmpty()) {
            return other;
        }
        if (other.value.isEmpty()) {
            return this;
        }
        return PythonString.valueOf(this.value + other.value);
    }

    public PythonString repeat(PythonInteger times) {
        int timesAsInt = times.value.intValueExact();
        if (timesAsInt <= 0) {
            return EMPTY;
        }
        if (timesAsInt == 1) {
            return this;
        }
        return PythonString.valueOf(this.value.repeat(timesAsInt));
    }

    public DelegatePythonIterator getIterator() {
        return new DelegatePythonIterator(this.value.chars().mapToObj(charVal -> new PythonString(Character.toString(charVal))).iterator());
    }

    public PythonString capitalize() {
        if (this.value.isEmpty()) {
            return this;
        }
        return PythonString.valueOf(Character.toTitleCase(this.value.charAt(0)) + this.value.substring(1).toLowerCase());
    }

    public PythonString title() {
        return this.title(ignored -> true);
    }

    public PythonString title(IntPredicate predicate) {
        if (this.value.isEmpty()) {
            return this;
        }
        int length = this.value.length();
        boolean previousIsWordBoundary = true;
        StringBuilder out = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char character = this.value.charAt(i);
            if (predicate.test(character)) {
                if (previousIsWordBoundary) {
                    out.append(Character.toTitleCase(character));
                } else {
                    out.append(Character.toLowerCase(character));
                }
            } else {
                out.append(character);
            }
            previousIsWordBoundary = !Character.isAlphabetic(character);
        }
        return PythonString.valueOf(out.toString());
    }

    public PythonString casefold() {
        return PythonString.valueOf(this.value.toUpperCase().toLowerCase());
    }

    public PythonString swapCase() {
        return this.withModifiedCodepoints(CharacterCase::swapCase);
    }

    public PythonString lower() {
        return PythonString.valueOf(this.value.toLowerCase());
    }

    public PythonString upper() {
        return PythonString.valueOf(this.value.toUpperCase());
    }

    public PythonString withModifiedCodepoints(IntUnaryOperator modifier) {
        return PythonString.valueOf(this.value.codePoints().map(modifier).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString());
    }

    public PythonString center(PythonInteger width) {
        return this.center(width, PythonString.valueOf(" "));
    }

    public PythonString center(PythonInteger width, PythonString fillChar) {
        int widthAsInt = width.value.intValueExact();
        if (widthAsInt <= this.value.length()) {
            return this;
        }
        int extraWidth = widthAsInt - this.value.length();
        int rightPadding = extraWidth / 2;
        int leftPadding = rightPadding + (extraWidth & 1);
        if (fillChar.value.length() != 1) {
            throw new TypeError("The fill character must be exactly one character long");
        }
        String fillCharAsString = fillChar.value;
        return PythonString.valueOf(fillCharAsString.repeat(leftPadding) + this.value + fillCharAsString.repeat(rightPadding));
    }

    public PythonString rightJustify(PythonInteger width) {
        return this.rightJustify(width, PythonString.valueOf(" "));
    }

    public PythonString rightJustify(PythonInteger width, PythonString fillChar) {
        int widthAsInt = width.value.intValueExact();
        if (widthAsInt <= this.value.length()) {
            return this;
        }
        int leftPadding = widthAsInt - this.value.length();
        if (fillChar.value.length() != 1) {
            throw new TypeError("The fill character must be exactly one character long");
        }
        return PythonString.valueOf(fillChar.value.repeat(leftPadding) + this.value);
    }

    public PythonString leftJustify(PythonInteger width) {
        return this.leftJustify(width, PythonString.valueOf(" "));
    }

    public PythonString leftJustify(PythonInteger width, PythonString fillChar) {
        int widthAsInt = width.value.intValueExact();
        if (widthAsInt <= this.value.length()) {
            return this;
        }
        int rightPadding = widthAsInt - this.value.length();
        if (fillChar.value.length() != 1) {
            throw new TypeError("The fill character must be exactly one character long");
        }
        return PythonString.valueOf(this.value + fillChar.value.repeat(rightPadding));
    }

    public PythonInteger count(PythonString sub) {
        Matcher matcher = Pattern.compile(Pattern.quote(sub.value)).matcher(this.value);
        return PythonInteger.valueOf(matcher.results().count());
    }

    public PythonInteger count(PythonString sub, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        Matcher matcher = Pattern.compile(Pattern.quote(sub.value)).matcher(this.value.substring(startIndex));
        return PythonInteger.valueOf(matcher.results().count());
    }

    public PythonInteger count(PythonString sub, PythonInteger start, PythonInteger end) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length());
        Matcher matcher = Pattern.compile(Pattern.quote(sub.value)).matcher(this.value.substring(startIndex, endIndex));
        return PythonInteger.valueOf(matcher.results().count());
    }

    public PythonBoolean startsWith(PythonString prefix) {
        return PythonBoolean.valueOf(this.value.startsWith(prefix.value));
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonString> prefixTuple) {
        for (PythonString prefix : prefixTuple) {
            if (!this.value.startsWith(prefix.value)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean startsWith(PythonString prefix, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        return PythonBoolean.valueOf(this.value.substring(startIndex).startsWith(prefix.value));
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonString> prefixTuple, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        String toCheck = this.value.substring(startIndex);
        for (PythonString prefix : prefixTuple) {
            if (!toCheck.startsWith(prefix.value)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean startsWith(PythonString prefix, PythonInteger start, PythonInteger end) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length());
        return PythonBoolean.valueOf(this.value.substring(startIndex, endIndex).startsWith(prefix.value));
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonString> prefixTuple, PythonInteger start, PythonInteger end) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length());
        String toCheck = this.value.substring(startIndex, endIndex);
        for (PythonString prefix : prefixTuple) {
            if (!toCheck.startsWith(prefix.value)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean endsWith(PythonString suffix) {
        return PythonBoolean.valueOf(this.value.endsWith(suffix.value));
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonString> suffixTuple) {
        for (PythonString suffix : suffixTuple) {
            if (!this.value.endsWith(suffix.value)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean endsWith(PythonString suffix, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        return PythonBoolean.valueOf(this.value.substring(startIndex).endsWith(suffix.value));
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonString> suffixTuple, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        String toCheck = this.value.substring(startIndex);
        for (PythonString suffix : suffixTuple) {
            if (!toCheck.endsWith(suffix.value)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean endsWith(PythonString suffix, PythonInteger start, PythonInteger end) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length());
        return PythonBoolean.valueOf(this.value.substring(startIndex, endIndex).endsWith(suffix.value));
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonString> suffixTuple, PythonInteger start, PythonInteger end) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length());
        String toCheck = this.value.substring(startIndex, endIndex);
        for (PythonString suffix : suffixTuple) {
            if (!toCheck.endsWith(suffix.value)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonString expandTabs() {
        return this.expandTabs(PythonInteger.valueOf(8));
    }

    public PythonString expandTabs(PythonInteger tabsize) {
        int tabsizeAsInt = tabsize.value.intValueExact();
        int column = 0;
        int length = this.value.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char character = this.value.charAt(i);
            if (character == '\n' || character == '\r') {
                builder.append(character);
                column = 0;
                continue;
            }
            if (character == '\t') {
                int remainder = tabsizeAsInt - column % tabsizeAsInt;
                builder.append(" ".repeat(remainder));
                column += remainder;
                continue;
            }
            builder.append(character);
            ++column;
        }
        return PythonString.valueOf(builder.toString());
    }

    public PythonInteger findSubstringIndex(PythonString substring) {
        return PythonInteger.valueOf(this.value.indexOf(substring.value));
    }

    public PythonInteger findSubstringIndex(PythonString substring, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int result = this.value.indexOf(substring.value, startIndex);
        return PythonInteger.valueOf(result);
    }

    public PythonInteger findSubstringIndex(PythonString substring, PythonInteger start, PythonInteger end) {
        int endIndex;
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int result = this.value.substring(startIndex, endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length())).indexOf(substring.value);
        return PythonInteger.valueOf(result < 0 ? result : result + startIndex);
    }

    public PythonInteger rightFindSubstringIndex(PythonString substring) {
        return PythonInteger.valueOf(this.value.lastIndexOf(substring.value));
    }

    public PythonInteger rightFindSubstringIndex(PythonString substring, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int result = this.value.substring(startIndex).lastIndexOf(substring.value);
        return PythonInteger.valueOf(result < 0 ? result : result + startIndex);
    }

    public PythonInteger rightFindSubstringIndex(PythonString substring, PythonInteger start, PythonInteger end) {
        int endIndex;
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int result = this.value.substring(startIndex, endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length())).lastIndexOf(substring.value);
        return PythonInteger.valueOf(result < 0 ? result : result + startIndex);
    }

    public PythonString format(List<PythonLikeObject> positionalArguments, Map<PythonString, PythonLikeObject> namedArguments) {
        return PythonString.valueOf(StringFormatter.format(this.value, positionalArguments, namedArguments));
    }

    public PythonString formatMap(PythonLikeDict dict) {
        return this.format(Collections.emptyList(), dict);
    }

    public PythonString formatSelf() {
        return this;
    }

    public PythonString formatSelf(PythonString spec) {
        if (spec.value.isEmpty()) {
            return this;
        }
        DefaultFormatSpec formatSpec = DefaultFormatSpec.fromStringSpec(spec);
        StringBuilder out = new StringBuilder();
        switch (formatSpec.conversionType.orElse(DefaultFormatSpec.ConversionType.STRING)) {
            case STRING: {
                out.append(this.value);
                break;
            }
            default: {
                throw new ValueError("Invalid conversion type for str: " + String.valueOf(formatSpec.conversionType));
            }
        }
        StringFormatter.align(out, formatSpec, DefaultFormatSpec.AlignmentOption.LEFT_ALIGN);
        return PythonString.valueOf(out.toString());
    }

    public PythonString interpolate(PythonLikeObject object) {
        if (object instanceof PythonLikeTuple) {
            return this.interpolate((PythonLikeTuple)object);
        }
        if (object instanceof PythonLikeDict) {
            return this.interpolate((PythonLikeDict)object);
        }
        return this.interpolate(PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{object}));
    }

    public PythonString interpolate(PythonLikeTuple tuple) {
        return PythonString.valueOf(StringFormatter.printfInterpolate((CharSequence)this.value, tuple, StringFormatter.PrintfStringType.STRING));
    }

    public PythonString interpolate(PythonLikeDict dict) {
        return PythonString.valueOf(StringFormatter.printfInterpolate((CharSequence)this.value, dict, StringFormatter.PrintfStringType.STRING));
    }

    public PythonInteger findSubstringIndexOrError(PythonString substring) {
        int result = this.value.indexOf(substring.value);
        if (result == -1) {
            throw new ValueError("substring not found");
        }
        return PythonInteger.valueOf(result);
    }

    public PythonInteger findSubstringIndexOrError(PythonString substring, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int result = this.value.indexOf(substring.value, startIndex);
        if (result == -1) {
            throw new ValueError("substring not found");
        }
        return PythonInteger.valueOf(result);
    }

    public PythonInteger findSubstringIndexOrError(PythonString substring, PythonInteger start, PythonInteger end) {
        int endIndex;
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int result = this.value.substring(startIndex, endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length())).indexOf(substring.value);
        if (result == -1) {
            throw new ValueError("substring not found");
        }
        return PythonInteger.valueOf(result + startIndex);
    }

    public PythonInteger rightFindSubstringIndexOrError(PythonString substring) {
        int result = this.value.lastIndexOf(substring.value);
        if (result == -1) {
            throw new ValueError("substring not found");
        }
        return PythonInteger.valueOf(result);
    }

    public PythonInteger rightFindSubstringIndexOrError(PythonString substring, PythonInteger start) {
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int result = this.value.substring(startIndex).lastIndexOf(substring.value);
        if (result == -1) {
            throw new ValueError("substring not found");
        }
        return PythonInteger.valueOf(result + startIndex);
    }

    public PythonInteger rightFindSubstringIndexOrError(PythonString substring, PythonInteger start, PythonInteger end) {
        int endIndex;
        int startIndex = PythonSlice.asValidStartIntIndexForLength(start, this.value.length());
        int result = this.value.substring(startIndex, endIndex = PythonSlice.asValidEndIntIndexForLength(end, this.value.length())).lastIndexOf(substring.value);
        if (result == -1) {
            throw new ValueError("substring not found");
        }
        return PythonInteger.valueOf(result + startIndex);
    }

    private PythonBoolean allCharactersHaveProperty(IntPredicate predicate) {
        int length = this.value.length();
        if (length == 0) {
            return PythonBoolean.FALSE;
        }
        for (int i = 0; i < length; ++i) {
            char character = this.value.charAt(i);
            if (predicate.test(character)) continue;
            return PythonBoolean.FALSE;
        }
        return PythonBoolean.TRUE;
    }

    public PythonBoolean isAlphaNumeric() {
        return this.allCharactersHaveProperty(character -> Character.isLetter(character) || Character.getNumericValue(character) != -1);
    }

    public PythonBoolean isAlpha() {
        return this.allCharactersHaveProperty(Character::isLetter);
    }

    public PythonBoolean isAscii() {
        if (this.value.isEmpty()) {
            return PythonBoolean.TRUE;
        }
        return this.allCharactersHaveProperty(character -> character <= 127);
    }

    public PythonBoolean isDecimal() {
        return this.allCharactersHaveProperty(Character::isDigit);
    }

    private boolean isSuperscriptOrSubscript(int character) {
        String characterName = Character.getName(character);
        return characterName.contains("SUPERSCRIPT") || characterName.contains("SUBSCRIPT");
    }

    public PythonBoolean isDigit() {
        return this.allCharactersHaveProperty(character -> {
            if (Character.getType(character) == 9) {
                return true;
            }
            return Character.isDigit(character) || Character.getNumericValue(character) >= 0 && this.isSuperscriptOrSubscript(character);
        });
    }

    public PythonBoolean isIdentifier() {
        int length = this.value.length();
        if (length == 0) {
            return PythonBoolean.FALSE;
        }
        char firstChar = this.value.charAt(0);
        if (!PythonString.isPythonIdentifierStart(firstChar)) {
            return PythonBoolean.FALSE;
        }
        for (int i = 1; i < length; ++i) {
            char character = this.value.charAt(i);
            if (PythonString.isPythonIdentifierPart(character)) continue;
            return PythonBoolean.FALSE;
        }
        return PythonBoolean.TRUE;
    }

    private static boolean isPythonIdentifierStart(char character) {
        if (Character.isLetter(character)) {
            return true;
        }
        if (Character.getType(character) == 10) {
            return true;
        }
        switch (character) {
            case '_': 
            case '\u1885': 
            case '\u1886': 
            case '\u2118': 
            case '\u212e': 
            case '\u309b': 
            case '\u309c': {
                return true;
            }
        }
        return false;
    }

    private static boolean isPythonIdentifierPart(char character) {
        if (PythonString.isPythonIdentifierStart(character)) {
            return true;
        }
        switch (Character.getType(character)) {
            case 6: 
            case 8: 
            case 9: 
            case 23: {
                return true;
            }
        }
        switch (character) {
            case '\u00b7': 
            case '\u0387': 
            case '\u19da': {
                return true;
            }
        }
        return character >= '\u1369' && character <= '\u1371';
    }

    private static boolean hasCase(int character) {
        return Character.isUpperCase(character) || Character.isLowerCase(character) || Character.isTitleCase(character);
    }

    private boolean hasCaseCharacters() {
        return !this.allCharactersHaveProperty(character -> !PythonString.hasCase(character)).getBooleanValue();
    }

    public PythonBoolean isLower() {
        if (this.hasCaseCharacters()) {
            return this.allCharactersHaveProperty(character -> !PythonString.hasCase(character) || Character.isLowerCase(character));
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean isNumeric() {
        return this.allCharactersHaveProperty(character -> {
            switch (Character.getType(character)) {
                case 9: 
                case 11: {
                    return true;
                }
            }
            return !Character.isLetter(character) && Character.getNumericValue(character) != -1;
        });
    }

    private static boolean isCharacterPrintable(int character) {
        if (character == 32) {
            return true;
        }
        switch (Character.getType(character)) {
            case 0: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                return false;
            }
        }
        return true;
    }

    public PythonBoolean isPrintable() {
        if (this.value.isEmpty()) {
            return PythonBoolean.TRUE;
        }
        return this.allCharactersHaveProperty(PythonString::isCharacterPrintable);
    }

    public PythonBoolean isSpace() {
        return PythonBoolean.valueOf(!this.value.isEmpty() && this.value.isBlank());
    }

    public PythonBoolean isUpper() {
        if (this.hasCaseCharacters()) {
            return this.allCharactersHaveProperty(character -> !PythonString.hasCase(character) || Character.isUpperCase(character));
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean isTitle() {
        int length = this.value.length();
        if (length == 0) {
            return PythonBoolean.FALSE;
        }
        CharacterCase previousType = CharacterCase.UNCASED;
        for (int i = 0; i < length; ++i) {
            char character = this.value.charAt(i);
            CharacterCase characterCase = CharacterCase.getCase(character);
            if (characterCase == CharacterCase.UNCASED && Character.isLetter(character)) {
                return PythonBoolean.FALSE;
            }
            switch (previousType) {
                case UNCASED: {
                    if (characterCase == CharacterCase.UPPER) break;
                    return PythonBoolean.FALSE;
                }
                case UPPER: 
                case LOWER: {
                    if (characterCase != CharacterCase.UPPER) break;
                    return PythonBoolean.FALSE;
                }
            }
            previousType = characterCase;
        }
        return PythonBoolean.TRUE;
    }

    public PythonString join(PythonLikeObject iterable) {
        PythonIterator iterator = (PythonIterator)UnaryDunderBuiltin.ITERATOR.invoke(iterable);
        int index = 0;
        StringBuilder out = new StringBuilder();
        while (iterator.hasNext()) {
            PythonLikeObject maybeString = iterator.nextPythonItem();
            if (!(maybeString instanceof PythonString)) {
                throw new TypeError("sequence item " + index + ": expected str instance, " + maybeString.$getType().getTypeName() + " found");
            }
            PythonString string = (PythonString)maybeString;
            out.append(string.value);
            if (iterator.hasNext()) {
                out.append(this.value);
            }
            ++index;
        }
        return PythonString.valueOf(out.toString());
    }

    public PythonString strip() {
        return PythonString.valueOf(this.value.strip());
    }

    public PythonString strip(PythonNone ignored) {
        return this.strip();
    }

    public PythonString strip(PythonString toStrip) {
        int start;
        int length = this.value.length();
        int end = length - 1;
        for (start = 0; start < length && toStrip.value.indexOf(this.value.charAt(start)) != -1; ++start) {
        }
        if (start == length) {
            return EMPTY;
        }
        while (end >= start && toStrip.value.indexOf(this.value.charAt(end)) != -1) {
            --end;
        }
        return PythonString.valueOf(this.value.substring(start, end + 1));
    }

    public PythonString leftStrip() {
        return PythonString.valueOf(this.value.stripLeading());
    }

    public PythonString leftStrip(PythonNone ignored) {
        return this.leftStrip();
    }

    public PythonString leftStrip(PythonString toStrip) {
        int length = this.value.length();
        for (int i = 0; i < length; ++i) {
            if (toStrip.value.indexOf(this.value.charAt(i)) != -1) continue;
            return PythonString.valueOf(this.value.substring(i));
        }
        return EMPTY;
    }

    public PythonString rightStrip() {
        return PythonString.valueOf(this.value.stripTrailing());
    }

    public PythonString rightStrip(PythonNone ignored) {
        return this.rightStrip();
    }

    public PythonString rightStrip(PythonString toStrip) {
        int length = this.value.length();
        for (int i = length - 1; i >= 0; --i) {
            if (toStrip.value.indexOf(this.value.charAt(i)) != -1) continue;
            return PythonString.valueOf(this.value.substring(0, i + 1));
        }
        return EMPTY;
    }

    public PythonLikeTuple partition(PythonString seperator) {
        int firstIndex = this.value.indexOf(seperator.value);
        if (firstIndex != -1) {
            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonString[]{PythonString.valueOf(this.value.substring(0, firstIndex)), seperator, PythonString.valueOf(this.value.substring(firstIndex + seperator.value.length()))});
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonString[]{this, EMPTY, EMPTY});
    }

    public PythonLikeTuple rightPartition(PythonString seperator) {
        int lastIndex = this.value.lastIndexOf(seperator.value);
        if (lastIndex != -1) {
            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonString[]{PythonString.valueOf(this.value.substring(0, lastIndex)), seperator, PythonString.valueOf(this.value.substring(lastIndex + seperator.value.length()))});
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonString[]{EMPTY, EMPTY, this});
    }

    public PythonString removePrefix(PythonString prefix) {
        if (this.value.startsWith(prefix.value)) {
            return new PythonString(this.value.substring(prefix.value.length()));
        }
        return this;
    }

    public PythonString removeSuffix(PythonString suffix) {
        if (this.value.endsWith(suffix.value)) {
            return new PythonString(this.value.substring(0, this.value.length() - suffix.value.length()));
        }
        return this;
    }

    public PythonString replaceAll(PythonString old, PythonString replacement) {
        return PythonString.valueOf(this.value.replaceAll(Pattern.quote(old.value), replacement.value));
    }

    public PythonString replaceUpToCount(PythonString old, PythonString replacement, PythonInteger count) {
        int countAsInt = count.value.intValueExact();
        if (countAsInt < 0) {
            return this.replaceAll(old, replacement);
        }
        Matcher matcher = Pattern.compile(Pattern.quote(old.value)).matcher(this.value);
        StringBuilder out = new StringBuilder();
        int start = 0;
        while (countAsInt > 0 && matcher.find()) {
            out.append(this.value, start, matcher.start());
            out.append(replacement.value);
            start = matcher.end();
            --countAsInt;
        }
        out.append(this.value.substring(start));
        return PythonString.valueOf(out.toString());
    }

    public PythonLikeList<PythonString> split() {
        return Arrays.stream(this.value.stripLeading().split("\\s+")).map(PythonString::valueOf).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonLikeList<PythonString> split(PythonNone ignored) {
        return this.split();
    }

    public PythonLikeList<PythonString> split(PythonString seperator) {
        return Arrays.stream(this.value.split(Pattern.quote(seperator.value), -1)).map(PythonString::valueOf).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonLikeList<PythonString> split(PythonString seperator, PythonInteger maxSplits) {
        int maxSplitsAsInt = maxSplits.value.intValueExact();
        if (maxSplitsAsInt == -1) {
            return this.split(seperator);
        }
        return Arrays.stream(this.value.split(Pattern.quote(seperator.value), maxSplitsAsInt + 1)).map(PythonString::valueOf).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonLikeList<PythonString> split(PythonNone ignored, PythonInteger maxSplits) {
        int maxSplitsAsInt = maxSplits.value.intValueExact();
        if (maxSplitsAsInt == -1) {
            return this.split();
        }
        return Arrays.stream(this.value.stripLeading().split("\\s+", maxSplitsAsInt + 1)).map(PythonString::valueOf).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonLikeList<PythonString> rightSplit() {
        return this.split();
    }

    public PythonLikeList<PythonString> rightSplit(PythonNone ignored) {
        return this.split();
    }

    public PythonLikeList<PythonString> rightSplit(PythonString seperator) {
        return this.split(seperator);
    }

    public PythonLikeList<PythonString> rightSplit(PythonString seperator, PythonInteger maxSplits) {
        int maxSplitsAsInt = maxSplits.value.intValueExact();
        if (maxSplitsAsInt == -1) {
            return this.split(seperator);
        }
        String reversedValue = new StringBuilder(this.value.stripTrailing()).reverse().toString();
        String reversedSeperator = new StringBuilder(seperator.value).reverse().toString();
        return Arrays.stream(reversedValue.split(Pattern.quote(reversedSeperator), maxSplitsAsInt + 1)).map(reversedPart -> PythonString.valueOf(new StringBuilder((String)reversedPart).reverse().toString())).collect(Collectors.collectingAndThen(Collectors.toCollection(PythonLikeList::new), l -> {
            Collections.reverse(l);
            return l;
        }));
    }

    public PythonLikeList<PythonString> rightSplit(PythonNone ignored, PythonInteger maxSplits) {
        int maxSplitsAsInt = maxSplits.value.intValueExact();
        if (maxSplitsAsInt == -1) {
            return this.split();
        }
        String reversedValue = new StringBuilder(this.value.stripTrailing()).reverse().toString();
        return Arrays.stream(reversedValue.split("\\s+", maxSplitsAsInt + 1)).map(reversedPart -> PythonString.valueOf(new StringBuilder((String)reversedPart).reverse().toString())).collect(Collectors.collectingAndThen(Collectors.toCollection(PythonLikeList::new), l -> {
            Collections.reverse(l);
            return l;
        }));
    }

    public PythonLikeList<PythonString> splitLines() {
        if (this.value.isEmpty()) {
            return new PythonLikeList<PythonString>();
        }
        return Arrays.stream(this.value.split("\\R")).map(PythonString::valueOf).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonLikeList<PythonString> splitLines(PythonBoolean keepEnds) {
        if (!keepEnds.getBooleanValue()) {
            return this.splitLines();
        }
        return Arrays.stream(this.value.split("(?<=\\R)")).map(PythonString::valueOf).collect(Collectors.collectingAndThen(Collectors.toCollection(PythonLikeList::new), l -> {
            int i;
            for (i = 0; i < l.size() - 1; ++i) {
                if (!((PythonString)l.get((int)i)).value.endsWith("\r") || !((PythonString)l.get((int)(i + 1))).value.startsWith("\n")) continue;
                l.set(i, PythonString.valueOf(((PythonString)l.get((int)i)).value + ((PythonString)l.remove((int)(i + 1))).value));
                --i;
            }
            if (!l.isEmpty() && ((PythonString)l.get((int)i)).value.isEmpty()) {
                l.remove(i);
            }
            return l;
        }));
    }

    public PythonString translate(PythonLikeObject object) {
        return PythonString.valueOf(this.value.codePoints().flatMap(codePoint -> {
            try {
                PythonLikeObject translated = BinaryDunderBuiltin.GET_ITEM.invoke(object, PythonInteger.valueOf(codePoint));
                if (translated == PythonNone.INSTANCE) {
                    return IntStream.empty();
                }
                if (translated instanceof PythonInteger) {
                    return IntStream.of(((PythonInteger)translated).value.intValueExact());
                }
                if (translated instanceof PythonString) {
                    return ((PythonString)translated).value.codePoints();
                }
                throw new TypeError("character mapping must return integer, None or str");
            }
            catch (LookupError e) {
                return IntStream.of(codePoint);
            }
        }).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString());
    }

    public PythonString zfill(PythonInteger width) {
        int widthAsInt = width.value.intValueExact();
        if (widthAsInt <= this.value.length()) {
            return this;
        }
        int leftPadding = widthAsInt - this.value.length();
        if (!(this.value.isEmpty() || this.value.charAt(0) != '+' && this.value.charAt(0) != '-')) {
            return PythonString.valueOf(this.value.charAt(0) + "0".repeat(leftPadding) + this.value.substring(1));
        }
        return PythonString.valueOf("0".repeat(leftPadding) + this.value);
    }

    @Override
    public int compareTo(PythonString pythonString) {
        return this.value.compareTo(pythonString.value);
    }

    @Override
    public PythonString $method$__format__(PythonLikeObject specObject) {
        if (specObject == PythonNone.INSTANCE) {
            return this.formatSelf();
        }
        if (!(specObject instanceof PythonString)) {
            throw new TypeError("__format__ argument 0 has incorrect type (expecting str or None)");
        }
        PythonString spec = (PythonString)specObject;
        return this.formatSelf(spec);
    }

    public PythonString repr() {
        return PythonString.valueOf("'" + this.value.codePoints().flatMap(character -> {
            if (character == 92) {
                return IntStream.of(92, 92);
            }
            if (PythonString.isCharacterPrintable(character)) {
                return IntStream.of(character);
            }
            switch (character) {
                case 13: {
                    return IntStream.of(92, 114);
                }
                case 10: {
                    return IntStream.of(92, 110);
                }
                case 9: {
                    return IntStream.of(92, 116);
                }
            }
            if (character < 65535) {
                return String.format("u%04x", character).codePoints();
            }
            return String.format("U%08x", character).codePoints();
        }).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString() + "'");
    }

    public PythonString asString() {
        return this;
    }

    @Override
    public PythonString $method$__str__() {
        return this;
    }

    @Override
    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            return s.equals(this.value);
        }
        if (o instanceof PythonString) {
            PythonString s = (PythonString)o;
            return s.value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public PythonInteger $method$__hash__() {
        return PythonInteger.valueOf(this.hashCode());
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonString::registerMethods);
    }

    static enum CharacterCase {
        UNCASED,
        LOWER,
        UPPER;


        public static CharacterCase getCase(int character) {
            if (Character.isLowerCase(character)) {
                return LOWER;
            }
            if (Character.isUpperCase(character)) {
                return UPPER;
            }
            return UNCASED;
        }

        public static int swapCase(int character) {
            if (Character.isLowerCase(character)) {
                return Character.toUpperCase(character);
            }
            if (Character.isUpperCase(character)) {
                return Character.toLowerCase(character);
            }
            return character;
        }
    }
}

