/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentWeakIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<Key<K>, V> map;
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private transient Set<Map.Entry<K, V>> entry;

    public ConcurrentWeakIdentityHashMap(int initialCapacity) {
        this.map = new ConcurrentHashMap<Key<K>, V>(initialCapacity);
    }

    public ConcurrentWeakIdentityHashMap() {
        this.map = new ConcurrentHashMap<Key<K>, V>();
    }

    @Override
    public V get(Object key) {
        this.purgeKeys();
        return this.map.get(new Key<Object>(key, (ReferenceQueue<Object>)null));
    }

    @Override
    public V put(K key, V value) {
        this.purgeKeys();
        return this.map.put(new Key<K>(key, this.queue), value);
    }

    @Override
    public int size() {
        this.purgeKeys();
        return this.map.size();
    }

    private void purgeKeys() {
        Reference<K> reference;
        while ((reference = this.queue.poll()) != null) {
            this.map.remove(reference);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entry;
        return entrySet == null ? (this.entry = new EntrySet()) : entrySet;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.purgeKeys();
        return this.map.putIfAbsent(new Key<K>(key, this.queue), value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(new Key<Object>(key, (ReferenceQueue<Object>)null));
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.purgeKeys();
        return this.map.remove(new Key<Object>(key, (ReferenceQueue<Object>)null), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.purgeKeys();
        return this.map.replace(new Key<K>(key, null), oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        this.purgeKeys();
        return this.map.replace(new Key<K>(key, null), value);
    }

    @Override
    public boolean containsKey(Object key) {
        this.purgeKeys();
        return this.map.containsKey(new Key<Object>(key, (ReferenceQueue<Object>)null));
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        this.map.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        this.purgeKeys();
        return this.map.containsValue(value);
    }

    private static class Key<T>
    extends WeakReference<T> {
        private final int hash;

        Key(T t, ReferenceQueue<T> queue) {
            super(t, queue);
            if (t == null) {
                throw new NullPointerException();
            }
            this.hash = System.identityHashCode(t);
        }

        public boolean equals(Object o) {
            Key other;
            return this == o || o instanceof Key && (other = (Key)o).get() == this.get();
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iter(ConcurrentWeakIdentityHashMap.this.map.entrySet().iterator());
        }

        @Override
        public int size() {
            return ConcurrentWeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentWeakIdentityHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentWeakIdentityHashMap.this.get(e.getKey()) == e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentWeakIdentityHashMap.this.remove(e.getKey(), e.getValue());
        }
    }

    private class Entry
    extends AbstractMap.SimpleEntry<K, V> {
        Entry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            ConcurrentWeakIdentityHashMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)obj;
                return this.getKey() == e.getKey() && this.getValue() == e.getValue();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }
    }

    private class Iter
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Key<K>, V>> it;
        private Map.Entry<K, V> nextValue;

        Iter(Iterator<Map.Entry<Key<K>, V>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != null) {
                return true;
            }
            while (this.it.hasNext()) {
                Map.Entry entry = this.it.next();
                Object key = entry.getKey().get();
                if (key != null) {
                    this.nextValue = new Entry(key, entry.getValue());
                    return true;
                }
                this.it.remove();
            }
            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry entry = this.nextValue;
            this.nextValue = null;
            return entry;
        }

        @Override
        public void remove() {
            this.it.remove();
            this.nextValue = null;
        }
    }
}

