/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.ValueSourceInfo;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.OpcodeWithoutSource;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class StackMetadata {
    public static final StackMetadata DEAD_CODE = new StackMetadata();
    public final LocalVariableHelper localVariableHelper;
    private final List<ValueSourceInfo> stackValueSources;
    private final List<ValueSourceInfo> localVariableValueSources;
    private final List<ValueSourceInfo> cellVariableValueSources;
    private List<String> callKeywordNameList;

    private StackMetadata() {
        this.localVariableHelper = null;
        this.stackValueSources = null;
        this.localVariableValueSources = null;
        this.cellVariableValueSources = null;
        this.callKeywordNameList = null;
    }

    public StackMetadata(LocalVariableHelper localVariableHelper) {
        int i;
        this.localVariableHelper = localVariableHelper;
        this.stackValueSources = new ArrayList<ValueSourceInfo>();
        this.localVariableValueSources = new ArrayList<ValueSourceInfo>(localVariableHelper.getNumberOfLocalVariables());
        this.cellVariableValueSources = new ArrayList<ValueSourceInfo>(localVariableHelper.getNumberOfCells());
        for (i = 0; i < localVariableHelper.getNumberOfLocalVariables(); ++i) {
            this.localVariableValueSources.add(null);
        }
        for (i = 0; i < localVariableHelper.getNumberOfCells(); ++i) {
            this.cellVariableValueSources.add(ValueSourceInfo.of((Opcode)new OpcodeWithoutSource(), BuiltinTypes.BASE_TYPE, new ValueSourceInfo[0]));
        }
        this.callKeywordNameList = Collections.emptyList();
    }

    private StackMetadata(LocalVariableHelper localVariableHelper, List<ValueSourceInfo> stackValueSources, List<ValueSourceInfo> localVariableValueSources, List<ValueSourceInfo> cellVariableValueSources, List<String> callKeywordNameList) {
        this.localVariableHelper = localVariableHelper;
        this.stackValueSources = stackValueSources;
        this.localVariableValueSources = localVariableValueSources;
        this.cellVariableValueSources = cellVariableValueSources;
        this.callKeywordNameList = callKeywordNameList;
    }

    public boolean isDeadCode() {
        return this == DEAD_CODE;
    }

    public int getStackSize() {
        return this.stackValueSources.size();
    }

    private int getListIndexForStackIndex(int stackIndex) {
        return this.stackValueSources.size() - stackIndex - 1;
    }

    public ValueSourceInfo getValueSourceForStackIndex(int index) {
        return this.stackValueSources.get(this.getListIndexForStackIndex(index));
    }

    public List<ValueSourceInfo> getValueSourcesUpToStackIndex(int index) {
        return this.stackValueSources.subList(this.stackValueSources.size() - index, this.stackValueSources.size());
    }

    public PythonLikeType getTypeAtStackIndex(int index) {
        ValueSourceInfo valueSourceInfo = this.stackValueSources.get(this.getListIndexForStackIndex(index));
        if (valueSourceInfo != null) {
            return valueSourceInfo.valueType;
        }
        return BuiltinTypes.BASE_TYPE;
    }

    public ValueSourceInfo getLocalVariableValueSource(int index) {
        return this.localVariableValueSources.get(index);
    }

    public ValueSourceInfo getCellVariableValueSource(int index) {
        return this.cellVariableValueSources.get(index);
    }

    public PythonLikeType getTOSType() {
        return this.getTypeAtStackIndex(0);
    }

    public ValueSourceInfo getTOSValueSource() {
        return this.getValueSourceForStackIndex(0);
    }

    public StackMetadata copy() {
        StackMetadata out = new StackMetadata(this.localVariableHelper, new ArrayList<ValueSourceInfo>(this.stackValueSources), new ArrayList<ValueSourceInfo>(this.localVariableValueSources), new ArrayList<ValueSourceInfo>(this.cellVariableValueSources), this.callKeywordNameList);
        return out;
    }

    public StackMetadata unifyWith(StackMetadata other) {
        int i;
        if (this == DEAD_CODE) {
            return other;
        }
        if (other == DEAD_CODE) {
            return this;
        }
        StackMetadata out = this.copy();
        if (out.stackValueSources.size() != other.stackValueSources.size() || out.localVariableValueSources.size() != other.localVariableValueSources.size() || out.cellVariableValueSources.size() != other.cellVariableValueSources.size()) {
            throw new IllegalArgumentException("Impossible State: Bytecode stack metadata size does not match when unifying (" + out.stackValueSources.stream().map(valueSource -> valueSource.valueType.toString()).collect(Collectors.joining(", ", "[", "]")) + ") with (" + other.stackValueSources.stream().map(valueSource -> valueSource.valueType.toString()).collect(Collectors.joining(", ", "[", "]")) + ")");
        }
        for (i = 0; i < out.stackValueSources.size(); ++i) {
            out.stackValueSources.set(i, StackMetadata.unifyTypes(this.stackValueSources.get(i), other.stackValueSources.get(i)));
        }
        for (i = 0; i < out.localVariableValueSources.size(); ++i) {
            out.localVariableValueSources.set(i, StackMetadata.unifyTypes(this.localVariableValueSources.get(i), other.localVariableValueSources.get(i)));
        }
        for (i = 0; i < out.cellVariableValueSources.size(); ++i) {
            out.cellVariableValueSources.set(i, StackMetadata.unifyTypes(this.cellVariableValueSources.get(i), other.cellVariableValueSources.get(i)));
        }
        return out;
    }

    private static ValueSourceInfo unifyTypes(ValueSourceInfo a, ValueSourceInfo b) {
        if (Objects.equals(a, b)) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.unifyWith(b);
    }

    public StackMetadata push(ValueSourceInfo type) {
        StackMetadata out = this.copy();
        out.stackValueSources.add(type);
        return out;
    }

    public StackMetadata set(int index, ValueSourceInfo type) {
        StackMetadata out = this.copy();
        out.stackValueSources.set(this.getListIndexForStackIndex(index), type);
        return out;
    }

    public StackMetadata pushTemp(PythonLikeType type) {
        return this.push(ValueSourceInfo.of((Opcode)new OpcodeWithoutSource(), type, new ValueSourceInfo[0]));
    }

    public StackMetadata push(ValueSourceInfo ... types) {
        StackMetadata out = this.copy();
        out.stackValueSources.addAll(Arrays.asList(types));
        return out;
    }

    public StackMetadata pushTemps(PythonLikeType ... types) {
        StackMetadata out = this.copy();
        for (PythonLikeType type : types) {
            out.stackValueSources.add(ValueSourceInfo.of((Opcode)new OpcodeWithoutSource(), type, new ValueSourceInfo[0]));
        }
        return out;
    }

    public StackMetadata stack(ValueSourceInfo ... types) {
        StackMetadata out = this.copy();
        out.stackValueSources.clear();
        out.stackValueSources.addAll(Arrays.asList(types));
        return out;
    }

    public StackMetadata pop() {
        StackMetadata out = this.copy();
        out.stackValueSources.remove(this.stackValueSources.size() - 1);
        return out;
    }

    public StackMetadata pop(int count) {
        StackMetadata out = this.copy();
        out.stackValueSources.subList(this.stackValueSources.size() - count, this.stackValueSources.size()).clear();
        return out;
    }

    public StackMetadata setLocalVariableValueSource(int index, ValueSourceInfo type) {
        StackMetadata out = this.copy();
        out.localVariableValueSources.set(index, type);
        return out;
    }

    public StackMetadata locals(ValueSourceInfo ... types) {
        if (types.length != this.localVariableValueSources.size()) {
            throw new IllegalArgumentException("Length mismatch: expected an array with {" + this.localVariableValueSources.size() + "} elements but got {" + Arrays.toString(types) + "}");
        }
        StackMetadata out = this.copy();
        for (int i = 0; i < types.length; ++i) {
            out.localVariableValueSources.set(i, types[i]);
        }
        return out;
    }

    public StackMetadata setCellVariableValueSource(int index, ValueSourceInfo type) {
        StackMetadata out = this.copy();
        out.cellVariableValueSources.set(index, type);
        return out;
    }

    public List<String> getCallKeywordNameList() {
        return this.callKeywordNameList;
    }

    public StackMetadata setCallKeywordNameList(List<String> callKeywordNameList) {
        StackMetadata out = this.copy();
        out.callKeywordNameList = callKeywordNameList;
        return out;
    }

    public String toString() {
        return "StackMetadata { stack: " + this.stackValueSources.toString() + "; locals: " + this.localVariableValueSources.toString() + "; cells: " + this.cellVariableValueSources.toString() + "; }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this == DEAD_CODE || o == DEAD_CODE) {
            return false;
        }
        StackMetadata that = (StackMetadata)o;
        return this.stackValueSources.equals(that.stackValueSources) && this.localVariableValueSources.equals(that.localVariableValueSources) && this.cellVariableValueSources.equals(that.cellVariableValueSources);
    }

    public int hashCode() {
        return Objects.hash(this.stackValueSources, this.localVariableValueSources, this.cellVariableValueSources);
    }
}

