/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.descriptor;

import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;

public final class VersionMapping {
    private final NavigableMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>> versionToMappingMap;

    public VersionMapping() {
        this.versionToMappingMap = new TreeMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>>();
    }

    private VersionMapping(NavigableMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>> versionToMappingMap) {
        this.versionToMappingMap = versionToMappingMap;
    }

    public static VersionMapping unimplemented() {
        return new VersionMapping();
    }

    public static VersionMapping constantMapping(Function<PythonBytecodeInstruction, Opcode> mapper) {
        return new VersionMapping().map(PythonVersion.MINIMUM_PYTHON_VERSION, Objects.requireNonNull(mapper));
    }

    public static VersionMapping constantMapping(BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode> mapper) {
        return new VersionMapping().map(PythonVersion.MINIMUM_PYTHON_VERSION, Objects.requireNonNull(mapper));
    }

    public VersionMapping map(PythonVersion version, Function<PythonBytecodeInstruction, Opcode> mapper) {
        TreeMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>> mapCopy = new TreeMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>>((SortedMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>>)this.versionToMappingMap);
        mapCopy.put(version, (instruction, ignored) -> (Opcode)mapper.apply((PythonBytecodeInstruction)instruction));
        return new VersionMapping(mapCopy);
    }

    public VersionMapping map(PythonVersion version, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode> mapper) {
        TreeMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>> mapCopy = new TreeMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>>((SortedMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>>)this.versionToMappingMap);
        mapCopy.put(version, mapper);
        return new VersionMapping(mapCopy);
    }

    public VersionMapping mapWithLabels(PythonVersion version, BiFunction<PythonBytecodeInstruction, Integer, Opcode> mapper, ToIntBiFunction<PythonBytecodeInstruction, PythonVersion> labelMapper) {
        TreeMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>> mapCopy = new TreeMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>>((SortedMap<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>>)this.versionToMappingMap);
        mapCopy.put(version, (instruction, actualVersion) -> (Opcode)mapper.apply((PythonBytecodeInstruction)instruction, labelMapper.applyAsInt((PythonBytecodeInstruction)instruction, (PythonVersion)actualVersion)));
        return new VersionMapping(mapCopy);
    }

    public Opcode getOpcodeForVersion(PythonBytecodeInstruction instruction, PythonVersion pythonVersion) {
        Map.Entry<PythonVersion, BiFunction<PythonBytecodeInstruction, PythonVersion, Opcode>> mappingForVersion = this.versionToMappingMap.floorEntry(pythonVersion);
        if (mappingForVersion == null) {
            throw new UnsupportedOperationException("Could not find implementation for Opcode %s for Python version %s (instruction %s)".formatted(instruction.opname(), pythonVersion, instruction));
        }
        return mappingForVersion.getValue().apply(instruction, pythonVersion);
    }
}

