/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.numeric;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonFloat;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.types.numeric.PythonNumber;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningImmutable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class PythonDecimal
extends AbstractPythonLikeObject
implements PythonNumber,
PlanningImmutable {
    public final BigDecimal value;
    private static final ThreadLocal<MathContext> threadMathContext = ThreadLocal.withInitial(() -> new MathContext(28, RoundingMode.HALF_EVEN));

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.DECIMAL_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.size() == 0) {
                return new PythonDecimal(BigDecimal.ZERO);
            }
            if (positionalArguments.size() == 1) {
                return PythonDecimal.from((PythonLikeObject)positionalArguments.get(0));
            }
            if (positionalArguments.size() == 2) {
                throw new ValueError("context constructor not supported");
            }
            throw new TypeError("function takes at most 2 arguments, got " + positionalArguments.size());
        });
        for (Method method : PythonDecimal.class.getDeclaredMethods()) {
            if (!method.getName().startsWith("$method$")) continue;
            BuiltinTypes.DECIMAL_TYPE.addMethod(method.getName().substring("$method$".length()), method);
        }
        return BuiltinTypes.DECIMAL_TYPE;
    }

    public PythonDecimal(BigDecimal value) {
        super(BuiltinTypes.DECIMAL_TYPE);
        this.value = value;
    }

    public static PythonDecimal from(PythonLikeObject value) {
        if (value instanceof PythonInteger) {
            PythonInteger integer = (PythonInteger)value;
            return PythonDecimal.valueOf(integer);
        }
        if (value instanceof PythonFloat) {
            PythonFloat pythonFloat = (PythonFloat)value;
            return PythonDecimal.valueOf(pythonFloat);
        }
        if (value instanceof PythonString) {
            PythonString str = (PythonString)value;
            return PythonDecimal.valueOf(str);
        }
        throw new TypeError("conversion from %s to Decimal is not supported".formatted(value.$getType().getTypeName()));
    }

    public static PythonDecimal $method$from_float(PythonFloat value) {
        return new PythonDecimal(new BigDecimal(value.value, threadMathContext.get()));
    }

    public static PythonDecimal valueOf(PythonInteger value) {
        return new PythonDecimal(new BigDecimal(value.value, threadMathContext.get()));
    }

    public static PythonDecimal valueOf(PythonFloat value) {
        return new PythonDecimal(new BigDecimal(value.value, threadMathContext.get()));
    }

    public static PythonDecimal valueOf(PythonString value) {
        return PythonDecimal.valueOf(value.value);
    }

    public static PythonDecimal valueOf(String value) {
        return new PythonDecimal(new BigDecimal(value, threadMathContext.get()));
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public PythonString $method$__repr__() {
        return PythonString.valueOf("Decimal('%s')".formatted(this.value.toPlainString()));
    }

    @Override
    public String toString() {
        return this.value.toPlainString();
    }

    public PythonString $method$toPlainString() {
        return PythonString.valueOf(this.value.toPlainString());
    }

    public boolean equals(Object o) {
        if (o instanceof PythonNumber) {
            PythonNumber number = (PythonNumber)o;
            return this.compareTo(number) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.$method$__hash__().value.intValue();
    }

    @Override
    public PythonInteger $method$__hash__() {
        int scale = this.value.scale();
        if (scale <= 0) {
            return PythonNumber.computeHash(new PythonInteger(this.value.toBigInteger()), PythonInteger.ONE);
        }
        BigDecimal scaledValue = this.value.movePointRight(scale);
        return PythonNumber.computeHash(new PythonInteger(scaledValue.toBigInteger()), new PythonInteger(BigInteger.TEN.pow(scale)));
    }

    public PythonBoolean $method$__bool__() {
        return PythonBoolean.valueOf(this.value.compareTo(BigDecimal.ZERO) != 0);
    }

    public PythonInteger $method$__int__() {
        return PythonInteger.valueOf(this.value.toBigInteger());
    }

    public PythonFloat $method$__float__() {
        return PythonFloat.valueOf(this.value.doubleValue());
    }

    public PythonDecimal $method$__pos__() {
        return this;
    }

    public PythonDecimal $method$__neg__() {
        return new PythonDecimal(this.value.negate());
    }

    public PythonDecimal $method$__abs__() {
        return new PythonDecimal(this.value.abs());
    }

    public PythonBoolean $method$__lt__(PythonDecimal other) {
        return PythonBoolean.valueOf(this.value.compareTo(other.value) < 0);
    }

    public PythonBoolean $method$__lt__(PythonInteger other) {
        return this.$method$__lt__(PythonDecimal.valueOf(other));
    }

    public PythonBoolean $method$__lt__(PythonFloat other) {
        return this.$method$__lt__(PythonDecimal.valueOf(other));
    }

    public PythonBoolean $method$__le__(PythonDecimal other) {
        return PythonBoolean.valueOf(this.value.compareTo(other.value) <= 0);
    }

    public PythonBoolean $method$__le__(PythonInteger other) {
        return this.$method$__le__(PythonDecimal.valueOf(other));
    }

    public PythonBoolean $method$__le__(PythonFloat other) {
        return this.$method$__le__(PythonDecimal.valueOf(other));
    }

    public PythonBoolean $method$__gt__(PythonDecimal other) {
        return PythonBoolean.valueOf(this.value.compareTo(other.value) > 0);
    }

    public PythonBoolean $method$__gt__(PythonInteger other) {
        return this.$method$__gt__(PythonDecimal.valueOf(other));
    }

    public PythonBoolean $method$__gt__(PythonFloat other) {
        return this.$method$__gt__(PythonDecimal.valueOf(other));
    }

    public PythonBoolean $method$__ge__(PythonDecimal other) {
        return PythonBoolean.valueOf(this.value.compareTo(other.value) >= 0);
    }

    public PythonBoolean $method$__ge__(PythonInteger other) {
        return this.$method$__ge__(PythonDecimal.valueOf(other));
    }

    public PythonBoolean $method$__ge__(PythonFloat other) {
        return this.$method$__ge__(PythonDecimal.valueOf(other));
    }

    public PythonBoolean $method$__eq__(PythonDecimal other) {
        return PythonBoolean.valueOf(this.value.compareTo(other.value) == 0);
    }

    public PythonBoolean $method$__eq__(PythonInteger other) {
        return PythonBoolean.valueOf(this.value.compareTo(new BigDecimal(other.value)) == 0);
    }

    public PythonBoolean $method$__eq__(PythonFloat other) {
        return PythonBoolean.valueOf(this.value.compareTo(new BigDecimal(other.value)) == 0);
    }

    public PythonBoolean $method$__neq__(PythonDecimal other) {
        return this.$method$__eq__(other).not();
    }

    public PythonBoolean $method$__neq__(PythonInteger other) {
        return this.$method$__eq__(other).not();
    }

    public PythonBoolean $method$__neq__(PythonFloat other) {
        return this.$method$__eq__(other).not();
    }

    public PythonDecimal $method$__add__(PythonDecimal other) {
        return new PythonDecimal(this.value.add(other.value, threadMathContext.get()));
    }

    public PythonDecimal $method$__add__(PythonInteger other) {
        return this.$method$__add__(PythonDecimal.valueOf(other));
    }

    public PythonDecimal $method$__radd__(PythonInteger other) {
        return PythonDecimal.valueOf(other).$method$__add__(this);
    }

    public PythonDecimal $method$__sub__(PythonDecimal other) {
        return new PythonDecimal(this.value.subtract(other.value, threadMathContext.get()));
    }

    public PythonDecimal $method$__sub__(PythonInteger other) {
        return this.$method$__sub__(PythonDecimal.valueOf(other));
    }

    public PythonDecimal $method$__rsub__(PythonInteger other) {
        return PythonDecimal.valueOf(other).$method$__sub__(this);
    }

    public PythonDecimal $method$__mul__(PythonDecimal other) {
        return new PythonDecimal(this.value.multiply(other.value, threadMathContext.get()));
    }

    public PythonDecimal $method$__mul__(PythonInteger other) {
        return this.$method$__mul__(PythonDecimal.valueOf(other));
    }

    public PythonDecimal $method$__rmul__(PythonInteger other) {
        return PythonDecimal.valueOf(other).$method$__mul__(this);
    }

    public PythonDecimal $method$__truediv__(PythonDecimal other) {
        return new PythonDecimal(this.value.divide(other.value, threadMathContext.get()));
    }

    public PythonDecimal $method$__truediv__(PythonInteger other) {
        return this.$method$__truediv__(PythonDecimal.valueOf(other));
    }

    public PythonDecimal $method$__rtruediv__(PythonInteger other) {
        return PythonDecimal.valueOf(other).$method$__truediv__(this);
    }

    public PythonDecimal $method$__floordiv__(PythonDecimal other) {
        BigDecimal newSignNum = switch (this.value.signum() * other.value.signum()) {
            case -1 -> BigDecimal.ONE.negate();
            case 0 -> BigDecimal.ZERO;
            case 1 -> BigDecimal.ONE;
            default -> throw new IllegalStateException("Unexpected signum (%d).".formatted(this.value.signum() * other.value.signum()));
        };
        return new PythonDecimal(this.value.abs().divideToIntegralValue(other.value.abs()).multiply(newSignNum, threadMathContext.get()));
    }

    public PythonDecimal $method$__floordiv__(PythonInteger other) {
        return this.$method$__floordiv__(PythonDecimal.valueOf(other));
    }

    public PythonDecimal $method$__rfloordiv__(PythonInteger other) {
        return PythonDecimal.valueOf(other).$method$__floordiv__(this);
    }

    public PythonDecimal $method$__mod__(PythonDecimal other) {
        return new PythonDecimal(this.value.subtract(this.$method$__floordiv__((PythonDecimal)other).value.multiply(other.value, threadMathContext.get())));
    }

    public PythonDecimal $method$__mod__(PythonInteger other) {
        return this.$method$__mod__(PythonDecimal.valueOf(other));
    }

    public PythonDecimal $method$__rmod__(PythonInteger other) {
        return PythonDecimal.valueOf(other).$method$__mod__(this);
    }

    public PythonDecimal $method$__pow__(PythonDecimal other) {
        if (other.value.stripTrailingZeros().scale() <= 0) {
            return new PythonDecimal(this.value.pow(other.value.intValue(), threadMathContext.get()));
        }
        return new PythonDecimal(new BigDecimal(Math.pow(this.value.doubleValue(), other.value.doubleValue()), threadMathContext.get()));
    }

    public PythonDecimal $method$__pow__(PythonInteger other) {
        return this.$method$__pow__(PythonDecimal.valueOf(other));
    }

    public PythonDecimal $method$__rpow__(PythonInteger other) {
        return PythonDecimal.valueOf(other).$method$__mod__(this);
    }

    public PythonInteger $method$adjusted() {
        return PythonInteger.valueOf(this.value.unscaledValue().toString().length() - 1 - this.value.scale());
    }

    public PythonLikeTuple<PythonInteger> $method$as_integer_ratio() {
        BigDecimal[] parts = this.value.divideAndRemainder(BigDecimal.ONE);
        BigDecimal integralPart = parts[0];
        BigDecimal fractionPart = parts[1];
        if (fractionPart.compareTo(BigDecimal.ZERO) == 0) {
            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonInteger[]{PythonInteger.valueOf(integralPart.toBigInteger()), PythonInteger.ONE});
        }
        int scale = fractionPart.scale();
        BigInteger scaledDenominator = BigDecimal.ONE.movePointRight(scale).toBigInteger();
        BigInteger scaledIntegralPart = integralPart.movePointRight(scale).toBigInteger();
        BigInteger scaledFractionPart = fractionPart.movePointRight(scale).toBigInteger();
        BigInteger scaledNumerator = scaledIntegralPart.add(scaledFractionPart);
        BigInteger commonFactors = scaledNumerator.gcd(scaledDenominator);
        BigInteger reducedNumerator = scaledNumerator.divide(commonFactors);
        BigInteger reducedDenominator = scaledDenominator.divide(commonFactors);
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonInteger[]{PythonInteger.valueOf(reducedNumerator), PythonInteger.valueOf(reducedDenominator)});
    }

    public PythonLikeTuple<PythonLikeObject> $method$as_tuple() {
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{PythonInteger.valueOf(this.value.signum() >= 0 ? 0 : 1), this.value.unscaledValue().abs().toString().chars().mapToObj(digit -> PythonInteger.valueOf(digit - 48)).collect(Collectors.toCollection(PythonLikeTuple::new)), PythonInteger.valueOf(-this.value.scale())});
    }

    public PythonDecimal $method$canonical() {
        return this;
    }

    public PythonDecimal $method$compare(PythonDecimal other) {
        return new PythonDecimal(BigDecimal.valueOf(this.value.compareTo(other.value)));
    }

    public PythonDecimal $method$compare_signal(PythonDecimal other) {
        return this.$method$compare(other);
    }

    public PythonDecimal $method$compare_total(PythonDecimal other) {
        PythonDecimal result = this.$method$compare(other);
        if (result.value.compareTo(BigDecimal.ZERO) != 0) {
            return result;
        }
        int sigNum = this.value.scale() - other.value.scale();
        if (sigNum < 0) {
            return new PythonDecimal(BigDecimal.ONE);
        }
        if (sigNum > 0) {
            return new PythonDecimal(BigDecimal.valueOf(-1L));
        }
        return result;
    }

    public PythonDecimal $method$compare_total_mag(PythonDecimal other) {
        return new PythonDecimal(this.value.abs()).$method$compare_total(new PythonDecimal(other.value.abs()));
    }

    public PythonDecimal $method$conjugate() {
        return this;
    }

    public PythonDecimal $method$copy_abs() {
        return new PythonDecimal(this.value.abs());
    }

    public PythonDecimal $method$copy_negate() {
        return new PythonDecimal(this.value.negate());
    }

    public PythonDecimal $method$copy_sign(PythonDecimal other) {
        int signChange = this.value.signum() * other.value.signum();
        BigDecimal multiplier = switch (signChange) {
            case -1 -> BigDecimal.valueOf(-1L);
            case 0, 1 -> BigDecimal.ONE;
            default -> throw new IllegalStateException("Unexpected signum (%d).".formatted(signChange));
        };
        return new PythonDecimal(this.value.multiply(multiplier));
    }

    private static BigDecimal getEToPrecision(int precision) {
        return PythonDecimal.getESubPowerToPrecision(BigDecimal.ONE, precision);
    }

    private static BigDecimal getESubPowerToPrecision(BigDecimal value, int precision) {
        BigDecimal numerator = BigDecimal.ONE;
        BigDecimal denominator = BigDecimal.ONE;
        BigDecimal total = BigDecimal.ZERO;
        MathContext extendedContext = new MathContext(precision + 8, RoundingMode.HALF_EVEN);
        for (int index = 1; index < 100; ++index) {
            total = total.add(numerator.divide(denominator, extendedContext), extendedContext);
            numerator = numerator.multiply(value);
            denominator = denominator.multiply(BigDecimal.valueOf(index));
        }
        return total;
    }

    private static BigDecimal getEPower(BigDecimal value, int precision) {
        int extendedPrecision = precision + 8;
        BigDecimal e = PythonDecimal.getEToPrecision(extendedPrecision);
        int integralPart = value.toBigInteger().intValue();
        BigDecimal fractionPart = value.remainder(BigDecimal.ONE);
        return e.pow(integralPart).multiply(PythonDecimal.getESubPowerToPrecision(fractionPart, extendedPrecision), threadMathContext.get());
    }

    public PythonDecimal $method$exp() {
        int precision = threadMathContext.get().getPrecision();
        return new PythonDecimal(PythonDecimal.getEPower(this.value, precision));
    }

    public PythonDecimal $method$fma(PythonDecimal multiplier, PythonDecimal summand) {
        return new PythonDecimal(this.value.multiply(multiplier.value).add(summand.value, threadMathContext.get()));
    }

    public PythonDecimal $method$fma(PythonInteger multiplier, PythonDecimal summand) {
        return this.$method$fma(PythonDecimal.valueOf(multiplier), summand);
    }

    public PythonDecimal $method$fma(PythonDecimal multiplier, PythonInteger summand) {
        return this.$method$fma(multiplier, PythonDecimal.valueOf(summand));
    }

    public PythonDecimal $method$fma(PythonInteger multiplier, PythonInteger summand) {
        return this.$method$fma(PythonDecimal.valueOf(multiplier), PythonDecimal.valueOf(summand));
    }

    public PythonBoolean $method$is_canonical() {
        return PythonBoolean.TRUE;
    }

    public PythonBoolean $method$is_finite() {
        return PythonBoolean.TRUE;
    }

    public PythonBoolean $method$is_infinite() {
        return PythonBoolean.FALSE;
    }

    public PythonBoolean $method$is_nan() {
        return PythonBoolean.FALSE;
    }

    public PythonBoolean $method$is_normal() {
        return PythonBoolean.TRUE;
    }

    public PythonBoolean $method$is_qnan() {
        return PythonBoolean.FALSE;
    }

    public PythonBoolean $method$is_signed() {
        return this.value.compareTo(BigDecimal.ZERO) < 0 ? PythonBoolean.TRUE : PythonBoolean.FALSE;
    }

    public PythonBoolean $method$is_snan() {
        return PythonBoolean.FALSE;
    }

    public PythonBoolean $method$is_subnormal() {
        return PythonBoolean.FALSE;
    }

    public PythonBoolean $method$is_zero() {
        return this.value.compareTo(BigDecimal.ZERO) == 0 ? PythonBoolean.TRUE : PythonBoolean.FALSE;
    }

    public PythonDecimal $method$ln() {
        return new PythonDecimal(new BigDecimal(Math.log(this.value.doubleValue()), threadMathContext.get()));
    }

    public PythonDecimal $method$log10() {
        return new PythonDecimal(new BigDecimal(Math.log10(this.value.doubleValue()), threadMathContext.get()));
    }

    public PythonDecimal $method$logb() {
        return new PythonDecimal(BigDecimal.valueOf(this.value.precision() - this.value.scale() - 1));
    }

    private static PythonDecimal logicalOp(BiPredicate<Boolean, Boolean> op, BigDecimal a, BigDecimal b) {
        if (a.scale() < 0 || b.scale() < 0) {
            throw new ValueError("Invalid Operation: both operands must be positive integers consisting of 1's and 0's");
        }
        Object aText = a.toPlainString();
        Object bText = b.toPlainString();
        if (((String)aText).length() > ((String)bText).length()) {
            bText = "0".repeat(((String)aText).length() - ((String)bText).length()) + (String)bText;
        } else if (((String)aText).length() < ((String)bText).length()) {
            aText = "0".repeat(((String)bText).length() - ((String)aText).length()) + (String)aText;
        }
        int digitCount = ((String)aText).length();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < digitCount; ++i) {
            boolean aBit = switch (((String)aText).charAt(i)) {
                case '0' -> false;
                case '1' -> true;
                default -> throw new ValueError("Invalid Operation: first operand (%s) is not a positive integer consisting of 1's and 0's".formatted(a));
            };
            boolean bBit = switch (((String)bText).charAt(i)) {
                case '0' -> false;
                case '1' -> true;
                default -> throw new ValueError("Invalid Operation: second operand (%s) is not a positive integer consisting of 1's and 0's".formatted(b));
            };
            result.append(op.test(aBit, bBit) ? (char)'1' : '0');
        }
        return new PythonDecimal(new BigDecimal(result.toString()));
    }

    public PythonDecimal $method$logical_and(PythonDecimal other) {
        return PythonDecimal.logicalOp(Boolean::logicalAnd, this.value, other.value);
    }

    public PythonDecimal $method$logical_or(PythonDecimal other) {
        return PythonDecimal.logicalOp(Boolean::logicalOr, this.value, other.value);
    }

    public PythonDecimal $method$logical_xor(PythonDecimal other) {
        return PythonDecimal.logicalOp(Boolean::logicalXor, this.value, other.value);
    }

    public PythonDecimal $method$logical_invert() {
        return PythonDecimal.logicalOp(Boolean::logicalXor, this.value, new BigDecimal("1".repeat(threadMathContext.get().getPrecision())));
    }

    public PythonDecimal $method$max(PythonDecimal other) {
        return new PythonDecimal(this.value.max(other.value));
    }

    public PythonDecimal $method$max_mag(PythonDecimal other) {
        int result = this.$method$compare_total_mag((PythonDecimal)other).value.intValue();
        if (result >= 0) {
            return this;
        }
        return other;
    }

    public PythonDecimal $method$min(PythonDecimal other) {
        return new PythonDecimal(this.value.min(other.value));
    }

    public PythonDecimal $method$min_mag(PythonDecimal other) {
        int result = this.$method$compare_total_mag((PythonDecimal)other).value.intValue();
        if (result <= 0) {
            return this;
        }
        return other;
    }

    private BigDecimal getLastPlaceUnit(MathContext mathContext) {
        int remainingPrecision = mathContext.getPrecision() - this.value.stripTrailingZeros().precision();
        return BigDecimal.ONE.movePointLeft(this.value.scale() + remainingPrecision + 1);
    }

    public PythonDecimal $method$next_minus() {
        MathContext context = new MathContext(threadMathContext.get().getPrecision(), RoundingMode.FLOOR);
        BigDecimal lastPlaceUnit = this.getLastPlaceUnit(context);
        return new PythonDecimal(this.value.subtract(lastPlaceUnit, context));
    }

    public PythonDecimal $method$next_plus() {
        MathContext context = new MathContext(threadMathContext.get().getPrecision(), RoundingMode.CEILING);
        BigDecimal lastPlaceUnit = this.getLastPlaceUnit(context);
        return new PythonDecimal(this.value.add(lastPlaceUnit, context));
    }

    public PythonDecimal $method$next_toward(PythonDecimal other) {
        int result = this.$method$compare((PythonDecimal)other).value.intValue();
        switch (result) {
            case -1: {
                return this.$method$next_plus();
            }
            case 1: {
                return this.$method$next_minus();
            }
            case 0: {
                return this;
            }
        }
        throw new IllegalStateException();
    }

    public PythonDecimal $method$normalize() {
        return new PythonDecimal(this.value.stripTrailingZeros());
    }

    public PythonString $method$number_class() {
        int result = this.value.compareTo(BigDecimal.ZERO);
        if (result < 0) {
            return PythonString.valueOf("-Normal");
        }
        if (result > 0) {
            return PythonString.valueOf("+Normal");
        }
        return PythonString.valueOf("+Zero");
    }

    public PythonDecimal $method$quantize(PythonDecimal other) {
        return new PythonDecimal(this.value.setScale(other.value.scale(), threadMathContext.get().getRoundingMode()));
    }

    public PythonDecimal $method$radix() {
        return new PythonDecimal(BigDecimal.TEN);
    }

    public PythonDecimal $method$remainder_near(PythonDecimal other) {
        BigDecimal floorQuotient = this.$method$__floordiv__((PythonDecimal)other).value;
        PythonDecimal firstRemainder = new PythonDecimal(this.value.subtract(floorQuotient.multiply(other.value, threadMathContext.get())));
        PythonDecimal secondRemainder = other.$method$__sub__(firstRemainder).$method$__neg__();
        int comparison = firstRemainder.$method$compare_total_mag((PythonDecimal)secondRemainder).value.intValue();
        return switch (comparison) {
            case -1 -> firstRemainder;
            case 1 -> secondRemainder;
            case 0 -> {
                if (floorQuotient.longValue() % 2L == 0L) {
                    yield firstRemainder;
                }
                yield secondRemainder;
            }
            default -> throw new IllegalStateException();
        };
    }

    public PythonDecimal $method$rotate(PythonInteger other) {
        int amount = -other.value.intValue();
        if (amount == 0) {
            return this;
        }
        int precision = threadMathContext.get().getPrecision();
        if (Math.abs(amount) > precision) {
            throw new ValueError("other must be between -%d and %d".formatted(amount, amount));
        }
        Object digitString = this.value.unscaledValue().toString();
        digitString = "0".repeat(precision - ((String)digitString).length()) + (String)digitString;
        if (amount < 0) {
            amount = precision + amount;
        }
        String rotatedResult = ((String)digitString).substring(precision - amount, precision) + ((String)digitString).substring(0, precision - amount);
        BigInteger unscaledResult = new BigInteger(rotatedResult);
        return new PythonDecimal(new BigDecimal(unscaledResult, this.value.scale()));
    }

    public PythonBoolean $method$same_quantum(PythonDecimal other) {
        return PythonBoolean.valueOf(this.value.ulp().compareTo(other.value.ulp()) == 0);
    }

    public PythonDecimal $method$scaleb(PythonInteger other) {
        return new PythonDecimal(this.value.movePointRight(other.value.intValue()));
    }

    public PythonDecimal $method$shift(PythonInteger other) {
        int amount = other.value.intValue();
        if (amount == 0) {
            return this;
        }
        int precision = threadMathContext.get().getPrecision();
        if (Math.abs(amount) > precision) {
            throw new ValueError("other must be between -%d and %d".formatted(amount, amount));
        }
        return new PythonDecimal(this.value.movePointLeft(amount));
    }

    public PythonDecimal $method$sqrt() {
        return new PythonDecimal(this.value.sqrt(threadMathContext.get()));
    }

    public PythonString $method$to_eng_string() {
        return new PythonString(this.value.toEngineeringString());
    }

    public PythonInteger $method$to_integral() {
        return this.$method$to_integral_value();
    }

    public PythonInteger $method$to_integral_exact() {
        return this.$method$to_integral_value();
    }

    public PythonInteger $method$to_integral_value() {
        return new PythonInteger(this.value.divideToIntegralValue(BigDecimal.ONE, threadMathContext.get()).toBigInteger());
    }

    public PythonInteger $method$__round__() {
        BigInteger first = this.value.toBigInteger();
        BigInteger second = first.add(BigInteger.ONE);
        BigDecimal firstDiff = this.value.subtract(new BigDecimal(first));
        BigDecimal secondDiff = new BigDecimal(second).subtract(this.value);
        int comparison = firstDiff.compareTo(secondDiff);
        return switch (comparison) {
            case -1 -> new PythonInteger(first);
            case 1 -> new PythonInteger(second);
            case 0 -> {
                if (first.intValue() % 2 == 0) {
                    yield new PythonInteger(first);
                }
                yield new PythonInteger(second);
            }
            default -> throw new IllegalStateException();
        };
    }

    public PythonLikeObject $method$__round__(PythonLikeObject maybePrecision) {
        if (maybePrecision instanceof PythonNone) {
            return this.$method$__round__();
        }
        if (!(maybePrecision instanceof PythonInteger)) {
            throw new ValueError("ndigits must be an integer");
        }
        PythonInteger precision = (PythonInteger)maybePrecision;
        BigInteger integralPart = this.value.toBigInteger();
        return new PythonDecimal(this.value.round(new MathContext(integralPart.toString().length() + precision.value.intValue(), threadMathContext.get().getRoundingMode())));
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonDecimal::registerMethods);
    }
}

