/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.drl;

import ai.timefold.solver.constraint.drl.DrlScoreDirectorFactory;
import ai.timefold.solver.constraint.drl.TimefoldRuleEventListener;
import ai.timefold.solver.constraint.drl.holder.AbstractScoreHolder;
import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;

public class DrlScoreDirector<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirector<Solution_, Score_, DrlScoreDirectorFactory<Solution_, Score_>> {
    public static final String GLOBAL_SCORE_HOLDER_KEY = "scoreHolder";
    protected KieSession kieSession;
    protected AbstractScoreHolder<Score_> scoreHolder;

    public DrlScoreDirector(DrlScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public KieSession getKieSession() {
        return this.kieSession;
    }

    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.resetKieSession();
    }

    private void resetKieSession() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
        this.kieSession = ((DrlScoreDirectorFactory)this.scoreDirectorFactory).newKieSession();
        ((RuleEventManager)this.kieSession).addEventListener((RuleEventListener)new TimefoldRuleEventListener());
        this.resetScoreHolder();
        this.getSolutionDescriptor().visitAll(this.workingSolution, arg_0 -> ((KieSession)this.kieSession).insert(arg_0));
    }

    private void resetScoreHolder() {
        this.scoreHolder = AbstractScoreHolder.buildScoreHolder(this.getScoreDefinition(), this.constraintMatchEnabledPreference);
        ((DrlScoreDirectorFactory)this.scoreDirectorFactory).getRuleToConstraintWeightExtractorMap().forEach((rule, extractor) -> {
            Score constraintWeight = (Score)extractor.apply(this.workingSolution);
            this.getSolutionDescriptor().validateConstraintWeight(rule.getPackageName(), rule.getName(), constraintWeight);
            this.scoreHolder.configureConstraintWeight((Rule)rule, constraintWeight);
        });
        this.kieSession.setGlobal(GLOBAL_SCORE_HOLDER_KEY, this.scoreHolder);
    }

    public Score_ calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        this.kieSession.fireAllRules();
        Score_ score = this.scoreHolder.extractScore(this.workingInitScore);
        this.setCalculatedScore((Score)score);
        return score;
    }

    public boolean isConstraintMatchEnabled() {
        return this.scoreHolder.isConstraintMatchEnabled();
    }

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getConstraintMatchTotalMap().");
        }
        this.kieSession.fireAllRules();
        return this.scoreHolder.getConstraintMatchTotalMap();
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getIndictmentMap().");
        }
        this.kieSession.fireAllRules();
        return this.scoreHolder.getIndictmentMap();
    }

    public boolean requiresFlushing() {
        return true;
    }

    public void close() {
        super.close();
        if (this.kieSession != null) {
            this.kieSession.dispose();
            this.kieSession = null;
        }
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @" + PlanningEntity.class.getSimpleName() + ".");
        }
        if (this.kieSession.getFactHandle(entity) != null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was already added to this ScoreDirector. Usually the cause is that that specific instance was already in your Solution's entities and you probably want to use before/afterVariableChanged() instead.");
        }
        this.kieSession.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.update(entity, variableDescriptor.getVariableName());
        super.afterVariableChanged(variableDescriptor, entity);
    }

    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        this.update(entity, variableDescriptor.getVariableName());
        super.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    private void update(Object entity, String variableName) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            this.kieSession.insert(entity);
        } else {
            this.kieSession.update(factHandle, entity, new String[]{variableName});
        }
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.deleteIfExists(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    private void deleteIfExists(Object factOrEntity) {
        FactHandle factHandle = this.kieSession.getFactHandle(factOrEntity);
        if (factHandle != null) {
            this.kieSession.delete(factHandle);
        }
    }

    public void afterProblemFactAdded(Object problemFact) {
        if (this.kieSession.getFactHandle(problemFact) != null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was already added to this ScoreDirector.\nMaybe that specific instance is already in the " + PlanningSolution.class.getSimpleName() + "'s problem fact members (" + this.getSolutionDescriptor().getProblemFactMemberAndProblemFactCollectionMemberNames() + ").\nMaybe use before/afterProblemPropertyChanged() instead of before/afterProblemFactAdded().");
        }
        this.kieSession.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFactOrEntity);
        if (factHandle == null) {
            this.kieSession.insert(problemFactOrEntity);
        } else {
            this.kieSession.update(factHandle, problemFactOrEntity);
        }
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    public void afterProblemFactRemoved(Object problemFact) {
        this.deleteIfExists(problemFact);
        super.afterProblemFactRemoved(problemFact);
    }
}

