/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.drl.holder;

import ai.timefold.solver.constraint.drl.holder.AbstractScoreHolder;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfiguration;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintWeight;
import ai.timefold.solver.core.api.score.buildin.hardsoft.HardSoftScore;
import ai.timefold.solver.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;

public final class HardSoftScoreHolderImpl
extends AbstractScoreHolder<HardSoftScore>
implements HardSoftScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.IntMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.IntMatchExecutor>();
    protected final Map<Rule, AbstractScoreHolder.ScoreMatchExecutor<HardSoftScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, AbstractScoreHolder.ScoreMatchExecutor<HardSoftScore>>();
    protected int hardScore;
    protected int softScore;

    public HardSoftScoreHolderImpl(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardSoftScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        AbstractScoreHolder.IntMatchExecutor matchExecutor = constraintWeight.isZero() ? (kcontext, matchWeight) -> {} : (constraintWeight.softScore() == 0 ? (kcontext, matchWeight) -> this.addHardConstraintMatch(kcontext, constraintWeight.hardScore() * matchWeight) : (constraintWeight.hardScore() == 0 ? (kcontext, matchWeight) -> this.addSoftConstraintMatch(kcontext, constraintWeight.softScore() * matchWeight) : (kcontext, matchWeight) -> this.addMultiConstraintMatch(kcontext, constraintWeight.hardScore() * matchWeight, constraintWeight.softScore() * matchWeight)));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch(kcontext, constraintWeight.hardScore() * weightMultiplier.hardScore(), constraintWeight.softScore() * weightMultiplier.softScore()));
    }

    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1);
    }

    public void penalize(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    public void penalize(RuleContext kcontext, int hardWeightMultiplier, int softWeightMultiplier) {
        this.impactScore(kcontext, -hardWeightMultiplier, -softWeightMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    public void reward(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, int hardWeightMultiplier, int softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier, softWeightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.IntMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a long weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeLong() to penalize().");
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a BigDecimal weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeBigDecimal() to penalize().");
    }

    private void impactScore(RuleContext kcontext, int hardWeightMultiplier, int softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.ScoreMatchExecutor<HardSoftScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardSoftScore.of((int)hardWeightMultiplier, (int)softWeightMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardWeight) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardSoftScore.ofHard((int)hardWeight));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softWeight) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardSoftScore.ofSoft((int)softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, int hardWeight, int softWeight) {
        this.hardScore += hardWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.softScore -= softWeight;
        }, () -> HardSoftScore.of((int)hardWeight, (int)softWeight));
    }

    @Override
    public HardSoftScore extractScore(int initScore) {
        return HardSoftScore.ofUninitialized((int)initScore, (int)this.hardScore, (int)this.softScore);
    }
}

