/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.JustificationsSupplier;
import ai.timefold.solver.constraint.streams.common.inliner.ScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import java.math.BigDecimal;

final class BendableBigDecimalScoreContext
extends ScoreContext<BendableBigDecimalScore> {
    private final int hardScoreLevelCount;
    private final int softScoreLevelCount;
    private final int scoreLevel;
    private final BigDecimal scoreLevelWeight;
    private final IntBigDecimalConsumer softScoreLevelUpdater;
    private final IntBigDecimalConsumer hardScoreLevelUpdater;

    public BendableBigDecimalScoreContext(AbstractScoreInliner<BendableBigDecimalScore> parent, Constraint constraint, BendableBigDecimalScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, int scoreLevel, BigDecimal scoreLevelWeight, IntBigDecimalConsumer hardScoreLevelUpdater, IntBigDecimalConsumer softScoreLevelUpdater) {
        super(parent, constraint, constraintWeight);
        this.hardScoreLevelCount = hardScoreLevelCount;
        this.softScoreLevelCount = softScoreLevelCount;
        this.scoreLevel = scoreLevel;
        this.scoreLevelWeight = scoreLevelWeight;
        this.softScoreLevelUpdater = softScoreLevelUpdater;
        this.hardScoreLevelUpdater = hardScoreLevelUpdater;
    }

    public BendableBigDecimalScoreContext(AbstractScoreInliner<BendableBigDecimalScore> parent, Constraint constraint, BendableBigDecimalScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, IntBigDecimalConsumer hardScoreLevelUpdater, IntBigDecimalConsumer softScoreLevelUpdater) {
        this(parent, constraint, constraintWeight, hardScoreLevelCount, softScoreLevelCount, -1, BigDecimal.ZERO, hardScoreLevelUpdater, softScoreLevelUpdater);
    }

    public UndoScoreImpacter changeSoftScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal softImpact = this.scoreLevelWeight.multiply(matchWeight);
        this.softScoreLevelUpdater.accept(this.scoreLevel, softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreLevelUpdater.accept(this.scoreLevel, softImpact.negate());
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableBigDecimalScore.ofSoft((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (BigDecimal)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal hardImpact = this.scoreLevelWeight.multiply(matchWeight);
        this.hardScoreLevelUpdater.accept(this.scoreLevel, hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreLevelUpdater.accept(this.scoreLevel, hardImpact.negate());
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableBigDecimalScore.ofHard((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (BigDecimal)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal[] hardImpacts = new BigDecimal[this.hardScoreLevelCount];
        BigDecimal[] softImpacts = new BigDecimal[this.softScoreLevelCount];
        for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
            BigDecimal hardImpact;
            hardImpacts[hardScoreLevel] = hardImpact = ((BendableBigDecimalScore)this.constraintWeight).hardScore(hardScoreLevel).multiply(matchWeight);
            this.hardScoreLevelUpdater.accept(hardScoreLevel, hardImpact);
        }
        for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
            BigDecimal softImpact;
            softImpacts[softScoreLevel] = softImpact = ((BendableBigDecimalScore)this.constraintWeight).softScore(softScoreLevel).multiply(matchWeight);
            this.softScoreLevelUpdater.accept(softScoreLevel, softImpact);
        }
        UndoScoreImpacter undoScoreImpact = () -> {
            for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
                this.hardScoreLevelUpdater.accept(hardScoreLevel, hardImpacts[hardScoreLevel].negate());
            }
            for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
                this.softScoreLevelUpdater.accept(softScoreLevel, softImpacts[softScoreLevel].negate());
            }
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableBigDecimalScore.of((BigDecimal[])hardImpacts, (BigDecimal[])softImpacts), justificationsSupplier);
    }

    public static interface IntBigDecimalConsumer {
        public void accept(int var1, BigDecimal var2);
    }
}

