/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.JustificationsSupplier;
import ai.timefold.solver.constraint.streams.common.inliner.ScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.bendable.BendableScore;
import ai.timefold.solver.core.api.score.stream.Constraint;

final class BendableScoreContext
extends ScoreContext<BendableScore> {
    private final int hardScoreLevelCount;
    private final int softScoreLevelCount;
    private final int scoreLevel;
    private final int scoreLevelWeight;
    private final IntBiConsumer softScoreLevelUpdater;
    private final IntBiConsumer hardScoreLevelUpdater;

    public BendableScoreContext(AbstractScoreInliner<BendableScore> parent, Constraint constraint, BendableScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, int scoreLevel, int scoreLevelWeight, IntBiConsumer hardScoreLevelUpdater, IntBiConsumer softScoreLevelUpdater) {
        super(parent, constraint, constraintWeight);
        this.hardScoreLevelCount = hardScoreLevelCount;
        this.softScoreLevelCount = softScoreLevelCount;
        this.scoreLevel = scoreLevel;
        this.scoreLevelWeight = scoreLevelWeight;
        this.softScoreLevelUpdater = softScoreLevelUpdater;
        this.hardScoreLevelUpdater = hardScoreLevelUpdater;
    }

    public BendableScoreContext(AbstractScoreInliner<BendableScore> parent, Constraint constraint, BendableScore constraintWeight, int hardScoreLevelCount, int softScoreLevelCount, IntBiConsumer hardScoreLevelUpdater, IntBiConsumer softScoreLevelUpdater) {
        this(parent, constraint, constraintWeight, hardScoreLevelCount, softScoreLevelCount, -1, -1, hardScoreLevelUpdater, softScoreLevelUpdater);
    }

    public UndoScoreImpacter changeSoftScoreBy(int matchWeight, JustificationsSupplier justificationsSupplier) {
        int softImpact = this.scoreLevelWeight * matchWeight;
        this.softScoreLevelUpdater.accept(this.scoreLevel, softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreLevelUpdater.accept(this.scoreLevel, -softImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableScore.ofSoft((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (int)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(int matchWeight, JustificationsSupplier justificationsSupplier) {
        int hardImpact = this.scoreLevelWeight * matchWeight;
        this.hardScoreLevelUpdater.accept(this.scoreLevel, hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreLevelUpdater.accept(this.scoreLevel, -hardImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableScore.ofHard((int)this.hardScoreLevelCount, (int)this.softScoreLevelCount, (int)this.scoreLevel, (int)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(int matchWeight, JustificationsSupplier justificationsSupplier) {
        int[] hardImpacts = new int[this.hardScoreLevelCount];
        int[] softImpacts = new int[this.softScoreLevelCount];
        for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
            int hardImpact;
            hardImpacts[hardScoreLevel] = hardImpact = ((BendableScore)this.constraintWeight).hardScore(hardScoreLevel) * matchWeight;
            this.hardScoreLevelUpdater.accept(hardScoreLevel, hardImpact);
        }
        for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
            int softImpact;
            softImpacts[softScoreLevel] = softImpact = ((BendableScore)this.constraintWeight).softScore(softScoreLevel) * matchWeight;
            this.softScoreLevelUpdater.accept(softScoreLevel, softImpact);
        }
        UndoScoreImpacter undoScoreImpact = () -> {
            for (int hardScoreLevel = 0; hardScoreLevel < this.hardScoreLevelCount; ++hardScoreLevel) {
                this.hardScoreLevelUpdater.accept(hardScoreLevel, -hardImpacts[hardScoreLevel]);
            }
            for (int softScoreLevel = 0; softScoreLevel < this.softScoreLevelCount; ++softScoreLevel) {
                this.softScoreLevelUpdater.accept(softScoreLevel, -softImpacts[softScoreLevel]);
            }
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, BendableScore.of((int[])hardImpacts, (int[])softImpacts), justificationsSupplier);
    }

    public static interface IntBiConsumer {
        public void accept(int var1, int var2);
    }
}

