/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.JustificationsSupplier;
import ai.timefold.solver.constraint.streams.common.inliner.ScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import java.util.function.IntConsumer;

final class HardMediumSoftScoreContext
extends ScoreContext<HardMediumSoftScore> {
    private final IntConsumer softScoreUpdater;
    private final IntConsumer mediumScoreUpdater;
    private final IntConsumer hardScoreUpdater;

    public HardMediumSoftScoreContext(AbstractScoreInliner<HardMediumSoftScore> parent, Constraint constraint, HardMediumSoftScore constraintWeight, IntConsumer hardScoreUpdater, IntConsumer mediumScoreUpdater, IntConsumer softScoreUpdater) {
        super(parent, constraint, constraintWeight);
        this.softScoreUpdater = softScoreUpdater;
        this.mediumScoreUpdater = mediumScoreUpdater;
        this.hardScoreUpdater = hardScoreUpdater;
    }

    public UndoScoreImpacter changeSoftScoreBy(int matchWeight, JustificationsSupplier justificationsSupplier) {
        int softImpact = ((HardMediumSoftScore)this.constraintWeight).softScore() * matchWeight;
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreUpdater.accept(-softImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftScore.ofSoft((int)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeMediumScoreBy(int matchWeight, JustificationsSupplier justificationsSupplier) {
        int mediumImpact = ((HardMediumSoftScore)this.constraintWeight).mediumScore() * matchWeight;
        this.mediumScoreUpdater.accept(mediumImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.mediumScoreUpdater.accept(-mediumImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftScore.ofMedium((int)mediumImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(int matchWeight, JustificationsSupplier justificationsSupplier) {
        int hardImpact = ((HardMediumSoftScore)this.constraintWeight).hardScore() * matchWeight;
        this.hardScoreUpdater.accept(hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreUpdater.accept(-hardImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftScore.ofHard((int)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(int matchWeight, JustificationsSupplier justificationsSupplier) {
        int hardImpact = ((HardMediumSoftScore)this.constraintWeight).hardScore() * matchWeight;
        int mediumImpact = ((HardMediumSoftScore)this.constraintWeight).mediumScore() * matchWeight;
        int softImpact = ((HardMediumSoftScore)this.constraintWeight).softScore() * matchWeight;
        this.hardScoreUpdater.accept(hardImpact);
        this.mediumScoreUpdater.accept(mediumImpact);
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> {
            this.hardScoreUpdater.accept(-hardImpact);
            this.mediumScoreUpdater.accept(-mediumImpact);
            this.softScoreUpdater.accept(-softImpact);
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftScore.of((int)hardImpact, (int)mediumImpact, (int)softImpact), justificationsSupplier);
    }
}

