/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.HardSoftLongScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.WeightedScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import ai.timefold.solver.core.api.score.stream.Constraint;

final class HardSoftLongScoreInliner
extends AbstractScoreInliner<HardSoftLongScore> {
    private long hardScore;
    private long softScore;

    HardSoftLongScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter<HardSoftLongScore, HardSoftLongScoreContext> buildWeightedScoreImpacter(Constraint constraint, HardSoftLongScore constraintWeight) {
        this.validateConstraintWeight(constraint, constraintWeight);
        HardSoftLongScoreContext context = new HardSoftLongScoreContext(this, constraint, constraintWeight, impact -> this.hardScore += impact, impact -> this.softScore += impact);
        if (constraintWeight.softScore() == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, justificationsSupplier) -> ctx.changeHardScoreBy(matchWeight, justificationsSupplier));
        }
        if (constraintWeight.hardScore() == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, justificationsSupplier) -> ctx.changeSoftScoreBy(matchWeight, justificationsSupplier));
        }
        return WeightedScoreImpacter.of(context, (ctx, matchWeight, justificationsSupplier) -> ctx.changeScoreBy(matchWeight, justificationsSupplier));
    }

    @Override
    public HardSoftLongScore extractScore(int initScore) {
        return HardSoftLongScore.ofUninitialized((int)initScore, (long)this.hardScore, (long)this.softScore);
    }

    public String toString() {
        return HardSoftLongScore.class.getSimpleName() + " inliner";
    }
}

