/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.core.api.function.PentaFunction;
import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class JustificationsSupplier {
    private final Function<Score<?>, ConstraintJustification> constraintJustificationSupplier;
    private final Supplier<Collection<Object>> indictedObjectsSupplier;

    public static JustificationsSupplier empty() {
        return new JustificationsSupplier(x$0 -> DefaultConstraintJustification.of((Score)x$0, (Object[])new Object[0]), Collections::emptyList);
    }

    public static <A> JustificationsSupplier of(Constraint constraint, BiFunction<A, Score<?>, ConstraintJustification> justificationMapping, Function<A, Collection<Object>> indictedObjectsMapping, A a) {
        Function<Score<?>, ConstraintJustification> explainingJustificationMapping = impact -> {
            try {
                return (ConstraintJustification)justificationMapping.apply(a, (Score<?>)impact);
            }
            catch (Exception e) {
                throw JustificationsSupplier.createJustificationException(constraint, e, a);
            }
        };
        Supplier<Collection<Object>> explainingIndictedObjectsSupplier = () -> {
            try {
                return (Collection)indictedObjectsMapping.apply(a);
            }
            catch (Exception e) {
                throw JustificationsSupplier.createIndictmentException(constraint, e, a);
            }
        };
        return new JustificationsSupplier(explainingJustificationMapping, explainingIndictedObjectsSupplier);
    }

    private static RuntimeException createJustificationException(Constraint constraint, Exception cause, Object ... facts) {
        throw new IllegalStateException("Consequence of a constraint (" + constraint.getConstraintId() + ") threw an exception creating constraint justification from a tuple (" + JustificationsSupplier.factsToString(facts) + ").", cause);
    }

    private static String factsToString(Object ... facts) {
        return Arrays.stream(facts).map(Object::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    private static RuntimeException createIndictmentException(Constraint constraint, Exception cause, Object ... facts) {
        throw new IllegalStateException("Consequence of a constraint (" + constraint.getConstraintId() + ") threw an exception collecting indicted objects from a tuple (" + JustificationsSupplier.factsToString(facts) + ").", cause);
    }

    public static <A, B> JustificationsSupplier of(Constraint constraint, TriFunction<A, B, Score<?>, ConstraintJustification> justificationMapping, BiFunction<A, B, Collection<Object>> indictedObjectsMapping, A a, B b) {
        Function<Score<?>, ConstraintJustification> explainingJustificationMapping = impact -> {
            try {
                return (ConstraintJustification)justificationMapping.apply(a, b, impact);
            }
            catch (Exception e) {
                throw JustificationsSupplier.createJustificationException(constraint, e, a, b);
            }
        };
        Supplier<Collection<Object>> explainingIndictedObjectsSupplier = () -> {
            try {
                return (Collection)indictedObjectsMapping.apply(a, b);
            }
            catch (Exception e) {
                throw JustificationsSupplier.createIndictmentException(constraint, e, a, b);
            }
        };
        return new JustificationsSupplier(explainingJustificationMapping, explainingIndictedObjectsSupplier);
    }

    public static <A, B, C> JustificationsSupplier of(Constraint constraint, QuadFunction<A, B, C, Score<?>, ConstraintJustification> justificationMapping, TriFunction<A, B, C, Collection<Object>> indictedObjectsMapping, A a, B b, C c) {
        Function<Score<?>, ConstraintJustification> explainingJustificationMapping = impact -> {
            try {
                return (ConstraintJustification)justificationMapping.apply(a, b, c, impact);
            }
            catch (Exception e) {
                throw JustificationsSupplier.createJustificationException(constraint, e, a, b, c);
            }
        };
        Supplier<Collection<Object>> explainingIndictedObjectsSupplier = () -> {
            try {
                return (Collection)indictedObjectsMapping.apply(a, b, c);
            }
            catch (Exception e) {
                throw JustificationsSupplier.createIndictmentException(constraint, e, a, b, c);
            }
        };
        return new JustificationsSupplier(explainingJustificationMapping, explainingIndictedObjectsSupplier);
    }

    public static <A, B, C, D> JustificationsSupplier of(Constraint constraint, PentaFunction<A, B, C, D, Score<?>, ConstraintJustification> justificationMapping, QuadFunction<A, B, C, D, Collection<Object>> indictedObjectsMapping, A a, B b, C c, D d) {
        Function<Score<?>, ConstraintJustification> explainingJustificationMapping = impact -> {
            try {
                return (ConstraintJustification)justificationMapping.apply(a, b, c, d, impact);
            }
            catch (Exception e) {
                throw JustificationsSupplier.createJustificationException(constraint, e, a, b, c, d);
            }
        };
        Supplier<Collection<Object>> explainingIndictedObjectsSupplier = () -> {
            try {
                return (Collection)indictedObjectsMapping.apply(a, b, c, d);
            }
            catch (Exception e) {
                throw JustificationsSupplier.createIndictmentException(constraint, e, a, b, c, d);
            }
        };
        return new JustificationsSupplier(explainingJustificationMapping, explainingIndictedObjectsSupplier);
    }

    private JustificationsSupplier(Function<Score<?>, ConstraintJustification> constraintJustificationSupplier, Supplier<Collection<Object>> indictedObjectsSupplier) {
        this.constraintJustificationSupplier = Objects.requireNonNull(constraintJustificationSupplier);
        this.indictedObjectsSupplier = Objects.requireNonNull(indictedObjectsSupplier);
    }

    public ConstraintJustification createConstraintJustification(Score<?> impact) {
        return this.constraintJustificationSupplier.apply(impact);
    }

    public Collection<Object> createIndictedObjects() {
        return this.indictedObjectsSupplier.get();
    }
}

