/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.AbstractConstraint;
import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.BendableBigDecimalScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.WeightedScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;

final class BendableBigDecimalScoreInliner
extends AbstractScoreInliner<BendableBigDecimalScore> {
    final BigDecimal[] hardScores;
    final BigDecimal[] softScores;

    BendableBigDecimalScoreInliner(Map<Constraint, BendableBigDecimalScore> constraintWeightMap, boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintWeightMap, constraintMatchEnabled);
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    @Override
    public WeightedScoreImpacter<BendableBigDecimalScore, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> constraint) {
        Integer singleLevel = null;
        BendableBigDecimalScore constraintWeight = (BendableBigDecimalScore)this.constraintWeightMap.get(constraint);
        for (int i = 0; i < constraintWeight.levelsSize(); ++i) {
            if (constraintWeight.hardOrSoftScore(i).equals(BigDecimal.ZERO)) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            boolean isHardScore = singleLevel < constraintWeight.hardLevelsSize();
            int level = isHardScore ? singleLevel : singleLevel - constraintWeight.hardLevelsSize();
            BendableBigDecimalScoreContext context = new BendableBigDecimalScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, level, constraintWeight.hardOrSoftScore(singleLevel.intValue()));
            if (isHardScore) {
                return WeightedScoreImpacter.of(context, BendableBigDecimalScoreContext::changeHardScoreBy);
            }
            return WeightedScoreImpacter.of(context, BendableBigDecimalScoreContext::changeSoftScoreBy);
        }
        BendableBigDecimalScoreContext context = new BendableBigDecimalScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length);
        return WeightedScoreImpacter.of(context, BendableBigDecimalScoreContext::changeScoreBy);
    }

    @Override
    public BendableBigDecimalScore extractScore(int initScore) {
        return BendableBigDecimalScore.ofUninitialized((int)initScore, (BigDecimal[])Arrays.copyOf(this.hardScores, this.hardScores.length), (BigDecimal[])Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

