/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.JustificationsSupplier;
import ai.timefold.solver.constraint.streams.common.inliner.ScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import java.math.BigDecimal;
import java.util.function.Consumer;

final class HardSoftBigDecimalScoreContext
extends ScoreContext<HardSoftBigDecimalScore> {
    private final Consumer<BigDecimal> softScoreUpdater;
    private final Consumer<BigDecimal> hardScoreUpdater;

    public HardSoftBigDecimalScoreContext(AbstractScoreInliner<HardSoftBigDecimalScore> parent, Constraint constraint, HardSoftBigDecimalScore constraintWeight, Consumer<BigDecimal> hardScoreUpdater, Consumer<BigDecimal> softScoreUpdater) {
        super(parent, constraint, constraintWeight);
        this.softScoreUpdater = softScoreUpdater;
        this.hardScoreUpdater = hardScoreUpdater;
    }

    public UndoScoreImpacter changeSoftScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal softImpact = ((HardSoftBigDecimalScore)this.constraintWeight).softScore().multiply(matchWeight);
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreUpdater.accept(softImpact.negate());
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftBigDecimalScore.ofSoft((BigDecimal)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal hardImpact = ((HardSoftBigDecimalScore)this.constraintWeight).hardScore().multiply(matchWeight);
        this.hardScoreUpdater.accept(hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreUpdater.accept(hardImpact.negate());
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftBigDecimalScore.ofHard((BigDecimal)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal hardImpact = ((HardSoftBigDecimalScore)this.constraintWeight).hardScore().multiply(matchWeight);
        BigDecimal softImpact = ((HardSoftBigDecimalScore)this.constraintWeight).softScore().multiply(matchWeight);
        this.hardScoreUpdater.accept(hardImpact);
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> {
            this.hardScoreUpdater.accept(hardImpact.negate());
            this.softScoreUpdater.accept(softImpact.negate());
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftBigDecimalScore.of((BigDecimal)hardImpact, (BigDecimal)softImpact), justificationsSupplier);
    }
}

