/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.inliner;

import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.constraint.streams.common.inliner.JustificationsSupplier;
import ai.timefold.solver.constraint.streams.common.inliner.ScoreContext;
import ai.timefold.solver.constraint.streams.common.inliner.UndoScoreImpacter;
import ai.timefold.solver.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import java.util.function.LongConsumer;

final class HardSoftLongScoreContext
extends ScoreContext<HardSoftLongScore> {
    private final LongConsumer softScoreUpdater;
    private final LongConsumer hardScoreUpdater;

    public HardSoftLongScoreContext(AbstractScoreInliner<HardSoftLongScore> parent, Constraint constraint, HardSoftLongScore constraintWeight, LongConsumer hardScoreUpdater, LongConsumer softScoreUpdater) {
        super(parent, constraint, constraintWeight);
        this.softScoreUpdater = softScoreUpdater;
        this.hardScoreUpdater = hardScoreUpdater;
    }

    public UndoScoreImpacter changeSoftScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long softImpact = ((HardSoftLongScore)this.constraintWeight).softScore() * matchWeight;
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreUpdater.accept(-softImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftLongScore.ofSoft((long)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long hardImpact = ((HardSoftLongScore)this.constraintWeight).hardScore() * matchWeight;
        this.hardScoreUpdater.accept(hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreUpdater.accept(-hardImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftLongScore.ofHard((long)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long hardImpact = ((HardSoftLongScore)this.constraintWeight).hardScore() * matchWeight;
        long softImpact = ((HardSoftLongScore)this.constraintWeight).softScore() * matchWeight;
        this.hardScoreUpdater.accept(hardImpact);
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> {
            this.hardScoreUpdater.accept(-hardImpact);
            this.softScoreUpdater.accept(-softImpact);
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftLongScore.of((long)hardImpact, (long)softImpact), justificationsSupplier);
    }
}

