/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.common.quad;

import ai.timefold.solver.constraint.streams.common.ScoreImpactType;
import ai.timefold.solver.core.api.function.PentaFunction;
import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntQuadFunction;
import ai.timefold.solver.core.api.function.ToLongQuadFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintBuilder;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

public interface InnerQuadConstraintStream<A, B, C, D>
extends QuadConstraintStream<A, B, C, D> {
    public static <A, B, C, D> PentaFunction<A, B, C, D, Score<?>, DefaultConstraintJustification> createDefaultJustificationMapping() {
        return (a, b, c, d, score) -> DefaultConstraintJustification.of((Score)score, (Object)a, (Object)b, (Object)c, (Object)d);
    }

    public static <A, B, C, D> QuadFunction<A, B, C, D, Collection<?>> createDefaultIndictedObjectsMapping() {
        return List::of;
    }

    public boolean guaranteesDistinct();

    default public QuadConstraintStream<A, B, C, D> distinct() {
        if (this.guaranteesDistinct()) {
            return this;
        }
        return this.groupBy((a, b, c, d) -> a, (a, b, c, d) -> b, (a, b, c, d) -> c, (a, b, c, d) -> d);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> penalize(Score_ constraintWeight, ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> penalizeLong(Score_ constraintWeight, ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> penalizeBigDecimal(Score_ constraintWeight, QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> penalizeConfigurable(ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> penalizeConfigurableLong(ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> penalizeConfigurableBigDecimal(QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> reward(Score_ constraintWeight, ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> rewardLong(Score_ constraintWeight, ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> rewardBigDecimal(Score_ constraintWeight, QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> rewardConfigurable(ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> rewardConfigurableLong(ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> rewardConfigurableBigDecimal(QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> impact(Score_ constraintWeight, ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> impactLong(Score_ constraintWeight, ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> impactBigDecimal(Score_ constraintWeight, QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> impactConfigurable(ToIntQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> impactConfigurableLong(ToLongQuadFunction<A, B, C, D> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    default public QuadConstraintBuilder<A, B, C, D, ?> impactConfigurableBigDecimal(QuadFunction<A, B, C, D, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> innerImpact(Score_ var1, ToIntQuadFunction<A, B, C, D> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> innerImpact(Score_ var1, ToLongQuadFunction<A, B, C, D> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> QuadConstraintBuilder<A, B, C, D, Score_> innerImpact(Score_ var1, QuadFunction<A, B, C, D, BigDecimal> var2, ScoreImpactType var3);

    default public Constraint penalize(String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    default public Constraint penalizeConfigurable(String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintName);
    }

    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    default public Constraint reward(String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    default public Constraint rewardConfigurable(String constraintName) {
        return this.rewardConfigurable().asConstraint(constraintName);
    }

    default public Constraint rewardConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    default public Constraint impact(String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintPackage, constraintName);
    }
}

