/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet;

import ai.timefold.solver.constraint.streams.bavet.common.Propagator;
import ai.timefold.solver.constraint.streams.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.constraint.streams.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class BavetConstraintSession<Score_ extends Score<Score_>> {
    private final AbstractScoreInliner<Score_> scoreInliner;
    private final Map<Class<?>, List<AbstractForEachUniNode<Object>>> declaredClassToNodeMap;
    private final Propagator[][] layeredNodes;
    private final Map<Class<?>, AbstractForEachUniNode<Object>[]> effectiveClassToNodeArrayMap;

    BavetConstraintSession(AbstractScoreInliner<Score_> scoreInliner) {
        this(scoreInliner, Collections.emptyMap(), new Propagator[0][0]);
    }

    BavetConstraintSession(AbstractScoreInliner<Score_> scoreInliner, Map<Class<?>, List<AbstractForEachUniNode<Object>>> declaredClassToNodeMap, Propagator[][] layeredNodes) {
        this.scoreInliner = scoreInliner;
        this.declaredClassToNodeMap = declaredClassToNodeMap;
        this.layeredNodes = layeredNodes;
        this.effectiveClassToNodeArrayMap = new IdentityHashMap(declaredClassToNodeMap.size());
    }

    public void insert(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.insert(fact);
        }
    }

    private AbstractForEachUniNode<Object>[] findNodes(Class<?> factClass) {
        AbstractForEachUniNode<Object>[] nodeArray = this.effectiveClassToNodeArrayMap.get(factClass);
        if (nodeArray == null) {
            nodeArray = (AbstractForEachUniNode[])this.declaredClassToNodeMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(factClass)).map(Map.Entry::getValue).flatMap(Collection::stream).toArray(AbstractForEachUniNode[]::new);
            this.effectiveClassToNodeArrayMap.put(factClass, nodeArray);
        }
        return nodeArray;
    }

    public void update(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.update(fact);
        }
    }

    public void retract(Object fact) {
        Class<?> factClass = fact.getClass();
        for (AbstractForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.retract(fact);
        }
    }

    public Score_ calculateScore(int initScore) {
        int layerCount = this.layeredNodes.length;
        for (int layerIndex = 0; layerIndex < layerCount; ++layerIndex) {
            this.calculateScoreInLayer(layerIndex);
        }
        return this.scoreInliner.extractScore(initScore);
    }

    private void calculateScoreInLayer(int layerIndex) {
        Propagator[] nodesInLayer = this.layeredNodes[layerIndex];
        int nodeCount = nodesInLayer.length;
        if (nodeCount == 1) {
            nodesInLayer[0].propagateEverything();
        } else {
            for (Propagator node : nodesInLayer) {
                node.propagateRetracts();
            }
            for (Propagator node : nodesInLayer) {
                node.propagateUpdates();
            }
            for (Propagator node : nodesInLayer) {
                node.propagateInserts();
            }
        }
    }

    public AbstractScoreInliner<Score_> getScoreInliner() {
        return this.scoreInliner;
    }

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        return this.scoreInliner.getConstraintIdToConstraintMatchTotalMap();
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.scoreInliner.getIndictmentMap();
    }
}

