/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.bi;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.bi.ConcatBiBiNode;
import ai.timefold.solver.constraint.streams.bavet.bi.ConcatBiUniNode;
import ai.timefold.solver.constraint.streams.bavet.bi.ConcatUniBiNode;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractConcatNode;
import ai.timefold.solver.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetConcatConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeBiConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeUniConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.BiTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.api.score.Score;
import java.util.Objects;
import java.util.Set;

public final class BavetConcatBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetConcatConstraintStream<Solution_> {
    private final BavetAbstractConstraintStream<Solution_> leftParent;
    private final BavetAbstractConstraintStream<Solution_> rightParent;
    private final ConcatNodeConstructor<A, B> nodeConstructor;

    public BavetConcatBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeUniConstraintStream<Solution_, A> leftParent, BavetForeBridgeBiConstraintStream<Solution_, A, B> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatUniBiNode::new;
    }

    public BavetConcatBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeBiConstraintStream<Solution_, A, B> leftParent, BavetForeBridgeBiConstraintStream<Solution_, A, B> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatBiBiNode::new;
    }

    public BavetConcatBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeBiConstraintStream<Solution_, A, B> leftParent, BavetForeBridgeUniConstraintStream<Solution_, A> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.nodeConstructor = ConcatBiUniNode::new;
    }

    @Override
    public boolean guaranteesDistinct() {
        if (this.leftParent instanceof BavetAbstractBiConstraintStream && this.rightParent instanceof BavetAbstractBiConstraintStream) {
            return false;
        }
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        int leftCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource());
        int rightCloneStoreIndex = buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        AbstractConcatNode<?, ?, ?> node = this.nodeConstructor.apply(downstream, leftCloneStoreIndex, rightCloneStoreIndex, outputStoreSize);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetConcatBiConstraintStream other = (BavetConcatBiConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent());
    }

    public String toString() {
        return "Concat() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.rightParent;
    }

    private static interface ConcatNodeConstructor<A, B> {
        public AbstractConcatNode<?, ?, ?> apply(TupleLifecycle<BiTuple<A, B>> var1, int var2, int var3, int var4);
    }
}

