/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.bi;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.bi.IndexedJoinBiNode;
import ai.timefold.solver.constraint.streams.bavet.bi.UnindexedJoinBiNode;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractJoinNode;
import ai.timefold.solver.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetJoinConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeUniConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.index.IndexerFactory;
import ai.timefold.solver.constraint.streams.bavet.common.index.JoinerUtils;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.common.bi.DefaultBiJoiner;
import ai.timefold.solver.core.api.score.Score;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

public final class BavetJoinBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetForeBridgeUniConstraintStream<Solution_, A> leftParent;
    private final BavetForeBridgeUniConstraintStream<Solution_, B> rightParent;
    private final DefaultBiJoiner<A, B> joiner;
    private final BiPredicate<A, B> filtering;

    public BavetJoinBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeUniConstraintStream<Solution_, A> leftParent, BavetForeBridgeUniConstraintStream<Solution_, B> rightParent, DefaultBiJoiner<A, B> joiner, BiPredicate<A, B> filtering) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory(this.joiner);
        AbstractJoinNode node = indexerFactory.hasJoiners() ? new IndexedJoinBiNode(JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, this.filtering, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1, indexerFactory.buildIndexer(true), indexerFactory.buildIndexer(false)) : new UnindexedJoinBiNode(buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, this.filtering, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetJoinBiConstraintStream other = (BavetJoinBiConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent()) && Objects.equals(this.joiner, other.joiner) && Objects.equals(this.filtering, other.filtering);
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent(), this.joiner, this.filtering);
    }

    public String toString() {
        return "BiJoin() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.rightParent;
    }
}

