/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractNode;
import ai.timefold.solver.constraint.streams.bavet.common.Propagator;
import ai.timefold.solver.constraint.streams.bavet.common.StaticPropagationQueue;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.LeftTupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.RightTupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleState;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.function.Consumer;

public abstract class AbstractJoinNode<LeftTuple_ extends AbstractTuple, Right_, OutTuple_ extends AbstractTuple>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    protected final int inputStoreIndexLeftOutTupleList;
    protected final int inputStoreIndexRightOutTupleList;
    private final boolean isFiltering;
    private final int outputStoreIndexLeftOutEntry;
    private final int outputStoreIndexRightOutEntry;
    private final StaticPropagationQueue<OutTuple_> propagationQueue;

    protected AbstractJoinNode(int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightOutTupleList, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, int outputStoreIndexLeftOutEntry, int outputStoreIndexRightOutEntry) {
        this.inputStoreIndexLeftOutTupleList = inputStoreIndexLeftOutTupleList;
        this.inputStoreIndexRightOutTupleList = inputStoreIndexRightOutTupleList;
        this.isFiltering = isFiltering;
        this.outputStoreIndexLeftOutEntry = outputStoreIndexLeftOutEntry;
        this.outputStoreIndexRightOutEntry = outputStoreIndexRightOutEntry;
        this.propagationQueue = new StaticPropagationQueue<OutTuple_>(nextNodesTupleLifecycle);
    }

    protected abstract OutTuple_ createOutTuple(LeftTuple_ var1, UniTuple<Right_> var2);

    protected abstract void setOutTupleLeftFacts(OutTuple_ var1, LeftTuple_ var2);

    protected abstract void setOutTupleRightFact(OutTuple_ var1, UniTuple<Right_> var2);

    protected abstract boolean testFiltering(LeftTuple_ var1, UniTuple<Right_> var2);

    protected final void insertOutTuple(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        OutTuple_ outTuple = this.createOutTuple(leftTuple, rightTuple);
        ElementAwareList outTupleListLeft = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftOutTupleList);
        ElementAwareListEntry outEntryLeft = outTupleListLeft.add(outTuple);
        ((AbstractTuple)outTuple).setStore(this.outputStoreIndexLeftOutEntry, outEntryLeft);
        ElementAwareList outTupleListRight = (ElementAwareList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
        ElementAwareListEntry outEntryRight = outTupleListRight.add(outTuple);
        ((AbstractTuple)outTuple).setStore(this.outputStoreIndexRightOutEntry, outEntryRight);
        this.propagationQueue.insert(outTuple);
    }

    protected final void insertOutTupleFiltered(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        if (!this.isFiltering || this.testFiltering(leftTuple, rightTuple)) {
            this.insertOutTuple(leftTuple, rightTuple);
        }
    }

    protected final void innerUpdateLeft(LeftTuple_ leftTuple, Consumer<Consumer<UniTuple<Right_>>> rightTupleConsumer) {
        ElementAwareList outTupleListLeft = (ElementAwareList)((AbstractTuple)leftTuple).getStore(this.inputStoreIndexLeftOutTupleList);
        if (!this.isFiltering) {
            for (AbstractTuple outTuple : outTupleListLeft) {
                this.updateOutTupleLeft(outTuple, leftTuple);
            }
        } else {
            rightTupleConsumer.accept(rightTuple -> {
                ElementAwareList rightOutList = (ElementAwareList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
                this.processOutTupleUpdate(leftTuple, (UniTuple<Right_>)rightTuple, (ElementAwareList<OutTuple_>)rightOutList, (ElementAwareList<OutTuple_>)outTupleListLeft, this.outputStoreIndexRightOutEntry);
            });
        }
    }

    private void updateOutTupleLeft(OutTuple_ outTuple, LeftTuple_ leftTuple) {
        this.setOutTupleLeftFacts(outTuple, leftTuple);
        this.doUpdateOutTuple(outTuple);
    }

    private void doUpdateOutTuple(OutTuple_ outTuple) {
        TupleState state = ((AbstractTuple)outTuple).state;
        if (!state.isActive()) {
            throw new IllegalStateException("Impossible state: The tuple (" + ((AbstractTuple)outTuple).state + ") in node (" + this + ") is in an unexpected state (" + ((AbstractTuple)outTuple).state + ").");
        }
        if (state != TupleState.OK) {
            return;
        }
        this.propagationQueue.update(outTuple);
    }

    protected final void innerUpdateRight(UniTuple<Right_> rightTuple, Consumer<Consumer<LeftTuple_>> leftTupleConsumer) {
        ElementAwareList outTupleListRight = (ElementAwareList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
        if (!this.isFiltering) {
            for (AbstractTuple outTuple : outTupleListRight) {
                this.setOutTupleRightFact(outTuple, rightTuple);
                this.doUpdateOutTuple(outTuple);
            }
        } else {
            leftTupleConsumer.accept(leftTuple -> {
                ElementAwareList leftOutList = (ElementAwareList)leftTuple.getStore(this.inputStoreIndexLeftOutTupleList);
                this.processOutTupleUpdate(leftTuple, rightTuple, leftOutList, outTupleListRight, this.outputStoreIndexLeftOutEntry);
            });
        }
    }

    private void processOutTupleUpdate(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple, ElementAwareList<OutTuple_> outList, ElementAwareList<OutTuple_> outTupleList, int outputStoreIndexOutEntry) {
        OutTuple_ outTuple = this.findOutTuple(outTupleList, outList, outputStoreIndexOutEntry);
        if (this.testFiltering(leftTuple, rightTuple)) {
            if (outTuple == null) {
                this.insertOutTuple(leftTuple, rightTuple);
            } else {
                this.updateOutTupleLeft(outTuple, leftTuple);
            }
        } else if (outTuple != null) {
            this.retractOutTuple(outTuple);
        }
    }

    private OutTuple_ findOutTuple(ElementAwareList<OutTuple_> outTupleList, ElementAwareList<OutTuple_> outList, int outputStoreIndexOutEntry) {
        for (AbstractTuple outTuple : outTupleList) {
            ElementAwareListEntry outEntry = (ElementAwareListEntry)outTuple.getStore(outputStoreIndexOutEntry);
            ElementAwareList outEntryList = outEntry.getList();
            if (outList != outEntryList) continue;
            return (OutTuple_)outTuple;
        }
        return null;
    }

    protected final void retractOutTuple(OutTuple_ outTuple) {
        ElementAwareListEntry outEntryLeft = (ElementAwareListEntry)((AbstractTuple)outTuple).removeStore(this.outputStoreIndexLeftOutEntry);
        outEntryLeft.remove();
        ElementAwareListEntry outEntryRight = (ElementAwareListEntry)((AbstractTuple)outTuple).removeStore(this.outputStoreIndexRightOutEntry);
        outEntryRight.remove();
        TupleState state = ((AbstractTuple)outTuple).state;
        if (!state.isActive()) {
            throw new IllegalStateException("Impossible state: The tuple (" + ((AbstractTuple)outTuple).state + ") in node (" + this + ") is in an unexpected state (" + ((AbstractTuple)outTuple).state + ").");
        }
        this.propagationQueue.retract(outTuple, state == TupleState.CREATING ? TupleState.ABORTING : TupleState.DYING);
    }

    @Override
    public Propagator getPropagator() {
        return this.propagationQueue;
    }
}

