/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.common;

import ai.timefold.solver.constraint.streams.bavet.common.AbstractNode;
import ai.timefold.solver.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.GroupNodeConstructor;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.ConstraintStream;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import java.util.List;
import java.util.Objects;

final class GroupNodeConstructorWithoutAccumulate<Tuple_ extends AbstractTuple>
implements GroupNodeConstructor<Tuple_> {
    private final Object equalityKey;
    private final GroupNodeConstructor.NodeConstructorWithoutAccumulate<Tuple_> nodeConstructorFunction;

    public GroupNodeConstructorWithoutAccumulate(Object equalityKey, GroupNodeConstructor.NodeConstructorWithoutAccumulate<Tuple_> nodeConstructorFunction) {
        this.equalityKey = equalityKey;
        this.nodeConstructorFunction = nodeConstructorFunction;
    }

    @Override
    public <Solution_, Score_ extends Score<Score_>> void build(NodeBuildHelper<Score_> buildHelper, BavetAbstractConstraintStream<Solution_> parentTupleSource, BavetAbstractConstraintStream<Solution_> aftStream, List<? extends ConstraintStream> aftStreamChildList, BavetAbstractConstraintStream<Solution_> bridgeStream, List<? extends ConstraintStream> bridgeStreamChildList, EnvironmentMode environmentMode) {
        if (!bridgeStreamChildList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + bridgeStream + ") has an non-empty childStreamList (" + bridgeStreamChildList + ") but it's a groupBy bridge.");
        }
        int groupStoreIndex = buildHelper.reserveTupleStoreIndex(parentTupleSource);
        TupleLifecycle tupleLifecycle = buildHelper.getAggregatedTupleLifecycle(aftStreamChildList);
        int outputStoreSize = buildHelper.extractTupleStoreSize(aftStream);
        AbstractNode node = this.nodeConstructorFunction.apply(groupStoreIndex, tupleLifecycle, outputStoreSize, environmentMode);
        buildHelper.addNode(node, bridgeStream);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GroupNodeConstructorWithoutAccumulate that = (GroupNodeConstructorWithoutAccumulate)object;
        return Objects.equals(this.equalityKey, that.equalityKey);
    }

    public int hashCode() {
        return Objects.hash(this.equalityKey);
    }
}

