/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.quad;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractIfExistsNode;
import ai.timefold.solver.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetIfExistsConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeUniConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.index.IndexerFactory;
import ai.timefold.solver.constraint.streams.bavet.common.index.JoinerUtils;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.quad.BavetAbstractQuadConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.quad.IndexedIfExistsQuadNode;
import ai.timefold.solver.constraint.streams.bavet.quad.UnindexedIfExistsQuadNode;
import ai.timefold.solver.constraint.streams.common.penta.DefaultPentaJoiner;
import ai.timefold.solver.core.api.function.PentaPredicate;
import ai.timefold.solver.core.api.score.Score;
import java.util.Objects;
import java.util.Set;

final class BavetIfExistsQuadConstraintStream<Solution_, A, B, C, D, E>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D>
implements BavetIfExistsConstraintStream<Solution_> {
    private final BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parentABCD;
    private final BavetForeBridgeUniConstraintStream<Solution_, E> parentBridgeE;
    private final boolean shouldExist;
    private final DefaultPentaJoiner<A, B, C, D, E> joiner;
    private final PentaPredicate<A, B, C, D, E> filtering;

    public BavetIfExistsQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parentABCD, BavetForeBridgeUniConstraintStream<Solution_, E> parentBridgeE, boolean shouldExist, DefaultPentaJoiner<A, B, C, D, E> joiner, PentaPredicate<A, B, C, D, E> filtering) {
        super(constraintFactory, parentABCD.getRetrievalSemantics());
        this.parentABCD = parentABCD;
        this.parentBridgeE = parentBridgeE;
        this.shouldExist = shouldExist;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.parentABCD.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parentABCD.collectActiveConstraintStreams(constraintStreamSet);
        this.parentBridgeE.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getTupleSource() {
        return this.parentABCD.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory(this.joiner);
        AbstractIfExistsNode node = indexerFactory.hasJoiners() ? (this.filtering == null ? new IndexedIfExistsQuadNode(this.shouldExist, JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource()), downstream, indexerFactory.buildIndexer(true), indexerFactory.buildIndexer(false)) : new IndexedIfExistsQuadNode(this.shouldExist, JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource()), downstream, indexerFactory.buildIndexer(true), indexerFactory.buildIndexer(false), this.filtering)) : (this.filtering == null ? new UnindexedIfExistsQuadNode(this.shouldExist, buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource()), downstream) : new UnindexedIfExistsQuadNode(this.shouldExist, buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource()), downstream, this.filtering));
        buildHelper.addNode(node, this, this, this.parentBridgeE);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetIfExistsQuadConstraintStream that = (BavetIfExistsQuadConstraintStream)object;
        return this.shouldExist == that.shouldExist && Objects.equals(this.parentABCD, that.parentABCD) && Objects.equals(this.parentBridgeE.getParent(), that.parentBridgeE.getParent()) && Objects.equals(this.joiner, that.joiner) && Objects.equals(this.filtering, that.filtering);
    }

    public int hashCode() {
        return Objects.hash(this.parentABCD, this.parentBridgeE.getParent(), this.shouldExist, this.joiner, this.filtering);
    }

    public String toString() {
        return "IfExists() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.parentABCD;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.parentBridgeE;
    }
}

