/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.quad;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.common.AbstractJoinNode;
import ai.timefold.solver.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.BavetJoinConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeTriConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetForeBridgeUniConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.common.index.IndexerFactory;
import ai.timefold.solver.constraint.streams.bavet.common.index.JoinerUtils;
import ai.timefold.solver.constraint.streams.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.constraint.streams.bavet.quad.BavetAbstractQuadConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.quad.IndexedJoinQuadNode;
import ai.timefold.solver.constraint.streams.bavet.quad.UnindexedJoinQuadNode;
import ai.timefold.solver.constraint.streams.common.quad.DefaultQuadJoiner;
import ai.timefold.solver.core.api.function.QuadPredicate;
import ai.timefold.solver.core.api.score.Score;
import java.util.Objects;
import java.util.Set;

public final class BavetJoinQuadConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetForeBridgeTriConstraintStream<Solution_, A, B, C> leftParent;
    private final BavetForeBridgeUniConstraintStream<Solution_, D> rightParent;
    private final DefaultQuadJoiner<A, B, C, D> joiner;
    private final QuadPredicate<A, B, C, D> filtering;

    public BavetJoinQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetForeBridgeTriConstraintStream<Solution_, A, B, C> leftParent, BavetForeBridgeUniConstraintStream<Solution_, D> rightParent, DefaultQuadJoiner<A, B, C, D> joiner, QuadPredicate<A, B, C, D> filtering) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory(this.joiner);
        AbstractJoinNode node = indexerFactory.hasJoiners() ? new IndexedJoinQuadNode(JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, this.filtering, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1, indexerFactory.buildIndexer(true), indexerFactory.buildIndexer(false)) : new UnindexedJoinQuadNode(buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, this.filtering, outputStoreSize + 2, outputStoreSize, outputStoreSize + 1);
        buildHelper.addNode(node, this, this.leftParent, this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetJoinQuadConstraintStream other = (BavetJoinQuadConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent()) && Objects.equals(this.joiner, other.joiner) && Objects.equals(this.filtering, other.filtering);
    }

    public int hashCode() {
        return Objects.hash(this.leftParent.getParent(), this.rightParent.getParent(), this.joiner, this.filtering);
    }

    public String toString() {
        return "QuadJoin() with " + this.childStreamList.size() + " children";
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getLeftParent() {
        return this.leftParent;
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getRightParent() {
        return this.rightParent;
    }
}

