/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.tri;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetAftBridgeTriConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.tri.BavetAbstractTriConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.tri.MapTriToTriNode;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.Score;
import java.util.Objects;

final class BavetTriMapTriConstraintStream<Solution_, A, B, C, NewA, NewB, NewC>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C> {
    private final TriFunction<A, B, C, NewA> mappingFunctionA;
    private final TriFunction<A, B, C, NewB> mappingFunctionB;
    private final TriFunction<A, B, C, NewC> mappingFunctionC;
    private BavetAftBridgeTriConstraintStream<Solution_, NewA, NewB, NewC> aftStream;

    public BavetTriMapTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, TriFunction<A, B, C, NewA> mappingFunctionA, TriFunction<A, B, C, NewB> mappingFunctionB, TriFunction<A, B, C, NewC> mappingFunctionC) {
        super(constraintFactory, parent);
        this.mappingFunctionA = mappingFunctionA;
        this.mappingFunctionB = mappingFunctionB;
        this.mappingFunctionC = mappingFunctionC;
    }

    public void setAftBridge(BavetAftBridgeTriConstraintStream<Solution_, NewA, NewB, NewC> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public boolean guaranteesDistinct() {
        return false;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        int inputStoreIndex = buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        MapTriToTriNode<A, B, C, NewA, NewB, NewC> node = new MapTriToTriNode<A, B, C, NewA, NewB, NewC>(inputStoreIndex, this.mappingFunctionA, this.mappingFunctionB, this.mappingFunctionC, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), outputStoreSize);
        buildHelper.addNode(node, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetTriMapTriConstraintStream that = (BavetTriMapTriConstraintStream)object;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.mappingFunctionA, that.mappingFunctionA) && Objects.equals(this.mappingFunctionB, that.mappingFunctionB) && Objects.equals(this.mappingFunctionC, that.mappingFunctionC);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.mappingFunctionA, this.mappingFunctionB, this.mappingFunctionC);
    }

    public String toString() {
        return "TriMap()";
    }
}

