/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.constraint.streams.bavet.uni;

import ai.timefold.solver.constraint.streams.bavet.BavetConstraintFactory;
import ai.timefold.solver.constraint.streams.bavet.common.NodeBuildHelper;
import ai.timefold.solver.constraint.streams.bavet.common.bridge.BavetAftBridgeBiConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import ai.timefold.solver.constraint.streams.bavet.uni.MapUniToBiNode;
import ai.timefold.solver.core.api.score.Score;
import java.util.Objects;
import java.util.function.Function;

final class BavetBiMapUniConstraintStream<Solution_, A, NewA, NewB>
extends BavetAbstractUniConstraintStream<Solution_, A> {
    private final Function<A, NewA> mappingFunctionA;
    private final Function<A, NewB> mappingFunctionB;
    private final boolean guaranteesDistinct;
    private BavetAftBridgeBiConstraintStream<Solution_, NewA, NewB> aftStream;

    public BavetBiMapUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parent, Function<A, NewA> mappingFunctionA, Function<A, NewB> mappingFunctionB, boolean isExpand) {
        super(constraintFactory, parent);
        this.mappingFunctionA = mappingFunctionA;
        this.mappingFunctionB = mappingFunctionB;
        this.guaranteesDistinct = isExpand && parent.guaranteesDistinct();
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.guaranteesDistinct;
    }

    public void setAftBridge(BavetAftBridgeBiConstraintStream<Solution_, NewA, NewB> aftStream) {
        this.aftStream = aftStream;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        this.assertEmptyChildStreamList();
        int inputStoreIndex = buildHelper.reserveTupleStoreIndex(this.parent.getTupleSource());
        int outputStoreSize = buildHelper.extractTupleStoreSize(this.aftStream);
        MapUniToBiNode<A, NewA, NewB> node = new MapUniToBiNode<A, NewA, NewB>(inputStoreIndex, this.mappingFunctionA, this.mappingFunctionB, buildHelper.getAggregatedTupleLifecycle(this.aftStream.getChildStreamList()), outputStoreSize);
        buildHelper.addNode(node, this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BavetBiMapUniConstraintStream that = (BavetBiMapUniConstraintStream)object;
        return Objects.equals(this.parent, that.parent) && this.guaranteesDistinct == that.guaranteesDistinct && Objects.equals(this.mappingFunctionA, that.mappingFunctionA) && Objects.equals(this.mappingFunctionB, that.mappingFunctionB);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.mappingFunctionA, this.mappingFunctionB, this.guaranteesDistinct);
    }

    public String toString() {
        return "BiMap()";
    }
}

