/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.jackson.api.score.analysis;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public final class ScoreAnalysisJacksonSerializer<Score_ extends Score<Score_>>
extends JsonSerializer<ScoreAnalysis<Score_>> {
    public void serialize(ScoreAnalysis<Score_> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("score", value.score().toString());
        ArrayList result = new ArrayList();
        value.constraintMap().forEach((constraintRef, constraintAnalysis) -> {
            LinkedHashMap<String, Object> constraintAnalysisMap = new LinkedHashMap<String, Object>();
            constraintAnalysisMap.put("package", constraintRef.packageName());
            constraintAnalysisMap.put("name", constraintRef.constraintName());
            constraintAnalysisMap.put("weight", constraintAnalysis.weight().toString());
            constraintAnalysisMap.put("score", constraintAnalysis.score().toString());
            if (constraintAnalysis.matches() != null) {
                ArrayList matchAnalysis = new ArrayList(constraintAnalysis.matches().size());
                constraintAnalysis.matches().forEach(match -> {
                    LinkedHashMap<String, Object> matchMap = new LinkedHashMap<String, Object>();
                    matchMap.put("score", match.score().toString());
                    ConstraintJustification patt1888$temp = match.justification();
                    if (patt1888$temp instanceof DefaultConstraintJustification) {
                        DefaultConstraintJustification justification = (DefaultConstraintJustification)patt1888$temp;
                        matchMap.put("justification", justification.getFacts());
                    } else {
                        matchMap.put("justification", match.justification());
                    }
                    matchAnalysis.add(matchMap);
                });
                constraintAnalysisMap.put("matches", matchAnalysis);
            }
            if (constraintAnalysis.matchCount() != -1) {
                constraintAnalysisMap.put("matchCount", constraintAnalysis.matchCount());
            }
            result.add(constraintAnalysisMap);
        });
        gen.writeObjectField("constraints", result);
        gen.writeEndObject();
    }
}

