/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.quarkus.deployment;

import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import ai.timefold.solver.benchmark.quarkus.TimefoldBenchmarkBeanProvider;
import ai.timefold.solver.benchmark.quarkus.TimefoldBenchmarkRecorder;
import ai.timefold.solver.benchmark.quarkus.UnavailableTimefoldBenchmarkBeanProvider;
import ai.timefold.solver.benchmark.quarkus.config.TimefoldBenchmarkRuntimeConfig;
import ai.timefold.solver.benchmark.quarkus.deployment.BenchmarkConfigBuildItem;
import ai.timefold.solver.benchmark.quarkus.deployment.TimefoldBenchmarkBuildTimeConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.quarkus.deployment.SolverConfigBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import org.jboss.logging.Logger;

class TimefoldBenchmarkProcessor {
    private static final Logger log = Logger.getLogger((String)TimefoldBenchmarkProcessor.class.getName());
    TimefoldBenchmarkBuildTimeConfig timefoldBenchmarkBuildTimeConfig;

    TimefoldBenchmarkProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("timefold-solver-benchmark");
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchSolverBenchmarkConfigXml() {
        String solverBenchmarkConfigXML = this.timefoldBenchmarkBuildTimeConfig.solverBenchmarkConfigXml.orElse("solverBenchmarkConfig.xml");
        return new HotDeploymentWatchedFileBuildItem(solverBenchmarkConfigXML);
    }

    @BuildStep
    BenchmarkConfigBuildItem registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, SolverConfigBuildItem solverConfigBuildItem) {
        PlannerBenchmarkConfig benchmarkConfig;
        if (solverConfigBuildItem.getSolverConfigMap().size() > 1) {
            throw new ConfigurationException("When defining multiple solvers, the benchmark feature is not enabled.\nConsider using separate <solverBenchmark> instances for evaluating different solver configurations.");
        }
        if (solverConfigBuildItem.getGeneratedGizmoClasses() == null) {
            log.warn((Object)"Skipping Timefold Benchmark extension because the Timefold extension was skipped.");
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{UnavailableTimefoldBenchmarkBeanProvider.class}));
            return new BenchmarkConfigBuildItem(null);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.timefoldBenchmarkBuildTimeConfig.solverBenchmarkConfigXml.isPresent()) {
            String solverBenchmarkConfigXML = this.timefoldBenchmarkBuildTimeConfig.solverBenchmarkConfigXml.get();
            if (classLoader.getResource(solverBenchmarkConfigXML) == null) {
                throw new ConfigurationException("Invalid quarkus.timefold.benchmark.solver-benchmark-config-xml property (" + solverBenchmarkConfigXML + "): that classpath resource does not exist.");
            }
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)solverBenchmarkConfigXML);
        } else {
            benchmarkConfig = classLoader.getResource("solverBenchmarkConfig.xml") != null ? PlannerBenchmarkConfig.createFromXmlResource((String)"solverBenchmarkConfig.xml") : null;
        }
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{TimefoldBenchmarkBeanProvider.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TimefoldBenchmarkRuntimeConfig.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{SolverConfig.class}));
        return new BenchmarkConfigBuildItem(benchmarkConfig);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerRuntimeBeans(TimefoldBenchmarkRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SolverConfigBuildItem solverConfigBuildItem, BenchmarkConfigBuildItem benchmarkConfigBuildItem, TimefoldBenchmarkRuntimeConfig runtimeConfig) {
        if (solverConfigBuildItem.getGeneratedGizmoClasses() == null) {
            return;
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(PlannerBenchmarkConfig.class).supplier(recorder.benchmarkConfigSupplier(benchmarkConfigBuildItem.getBenchmarkConfig(), runtimeConfig)).setRuntimeInit().done());
    }
}

