/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.deployment;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorImplementor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberInfo;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerImplementor;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionOrEntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.quarkus.deployment.QuarkusGizmoSolutionClonerImplementor;
import ai.timefold.solver.quarkus.gizmo.TimefoldGizmoBeanFactory;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.RuntimeValue;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class GizmoMemberAccessorEntityEnhancer {
    private final Set<Class<?>> visitedClasses = new HashSet();
    private final Set<Field> visitedFields = new HashSet<Field>();
    private final Set<Field> visitedFinalFields = new HashSet<Field>();
    private final Set<MethodInfo> visitedMethods = new HashSet<MethodInfo>();

    GizmoMemberAccessorEntityEnhancer() {
    }

    private static String getVirtualGetterName(boolean isField, String name) {
        return "$get$timefold$__" + (isField ? "field$__" : "method$__") + name;
    }

    private static String getVirtualSetterName(boolean isField, String name) {
        return "$set$timefold$__" + (isField ? "field$__" : "method$__") + name;
    }

    public String generateFieldAccessor(AnnotationInstance annotationInstance, ClassOutput classOutput, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> declaringClass = Class.forName(fieldInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
        Field fieldMember = declaringClass.getDeclaredField(fieldInfo.name());
        GizmoMemberDescriptor member = this.createMemberDescriptorForField(fieldMember, transformers);
        GizmoMemberInfo memberInfo = new GizmoMemberInfo(member, true, Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader()));
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName((Member)fieldMember);
        GizmoMemberAccessorImplementor.defineAccessorFor((String)generatedClassName, (ClassOutput)classOutput, (GizmoMemberInfo)memberInfo);
        return generatedClassName;
    }

    private void addVirtualFieldGetter(Class<?> classInfo, Field fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!this.visitedFields.contains(fieldInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.getName(), (className, classVisitor) -> new TimefoldFieldEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, fieldInfo)));
            this.visitedFields.add(fieldInfo);
        }
    }

    private void makeFieldNonFinal(Field finalField, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (this.visitedFinalFields.contains(finalField)) {
            return;
        }
        transformers.produce((BuildItem)new BytecodeTransformerBuildItem(finalField.getDeclaringClass().getName(), (className, classVisitor) -> new TimefoldFinalFieldEnhancingClassVisitor((ClassVisitor)classVisitor, finalField)));
        this.visitedFinalFields.add(finalField);
    }

    private static String getMemberName(Member member) {
        return Objects.requireNonNullElse(ReflectionHelper.getGetterPropertyName((Member)member), member.getName());
    }

    private static Optional<MethodDescriptor> getSetterDescriptor(ClassInfo classInfo, MethodInfo methodInfo, String name) {
        if (methodInfo.name().startsWith("get") || methodInfo.name().startsWith("is")) {
            return Optional.ofNullable(classInfo.method("set" + name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1), new org.jboss.jandex.Type[]{methodInfo.returnType()})).map(MethodDescriptor::of);
        }
        return Optional.empty();
    }

    public String generateMethodAccessor(AnnotationInstance annotationInstance, ClassOutput classOutput, ClassInfo classInfo, MethodInfo methodInfo, boolean requiredReturnType, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException, NoSuchMethodException {
        GizmoMemberDescriptor member;
        Class<?> declaringClass = Class.forName(methodInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
        Method methodMember = declaringClass.getDeclaredMethod(methodInfo.name(), new Class[0]);
        String generatedClassName = GizmoMemberAccessorFactory.getGeneratedClassName((Member)methodMember);
        String name = GizmoMemberAccessorEntityEnhancer.getMemberName(methodMember);
        Optional<MethodDescriptor> setterDescriptor = GizmoMemberAccessorEntityEnhancer.getSetterDescriptor(classInfo, methodInfo, name);
        MethodDescriptor memberDescriptor = MethodDescriptor.of((MethodInfo)methodInfo);
        if (Modifier.isPublic(methodInfo.flags())) {
            member = new GizmoMemberDescriptor(name, memberDescriptor, declaringClass, (MethodDescriptor)setterDescriptor.orElse(null));
        } else {
            setterDescriptor = this.addVirtualMethodGetter(classInfo, methodInfo, name, setterDescriptor, transformers);
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(false, name);
            MethodDescriptor newMethodDescriptor = MethodDescriptor.ofMethod(declaringClass, (String)methodName, (Object)memberDescriptor.getReturnType(), (Object[])new Object[0]);
            member = new GizmoMemberDescriptor(name, newMethodDescriptor, memberDescriptor, declaringClass, (MethodDescriptor)setterDescriptor.orElse(null));
        }
        Class<?> annotationClass = null;
        if (requiredReturnType || annotationInstance != null) {
            annotationClass = Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        GizmoMemberInfo memberInfo = new GizmoMemberInfo(member, requiredReturnType, annotationClass);
        GizmoMemberAccessorImplementor.defineAccessorFor((String)generatedClassName, (ClassOutput)classOutput, (GizmoMemberInfo)memberInfo);
        return generatedClassName;
    }

    private Optional<MethodDescriptor> addVirtualMethodGetter(ClassInfo classInfo, MethodInfo methodInfo, String name, Optional<MethodDescriptor> setterDescriptor, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!this.visitedMethods.contains(methodInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (className, classVisitor) -> new TimefoldMethodEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, methodInfo, name, setterDescriptor)));
            this.visitedMethods.add(methodInfo);
        }
        return setterDescriptor.map(md -> MethodDescriptor.ofMethod((String)classInfo.name().toString(), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(false, name), (String)md.getReturnType(), (String[])md.getParameterTypes()));
    }

    public String generateSolutionCloner(SolutionDescriptor solutionDescriptor, ClassOutput classOutput, IndexView indexView, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        String generatedClassName = GizmoSolutionClonerFactory.getGeneratedClassName((SolutionDescriptor)solutionDescriptor);
        try (ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{GizmoSolutionCloner.class}).classOutput(classOutput).setFinal(true).build();){
            Set solutionSubclassSet = indexView.getAllKnownSubclasses(DotName.createSimple((String)solutionDescriptor.getSolutionClass().getName())).stream().map(classInfo -> {
                try {
                    return Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to find class (" + String.valueOf(classInfo.name()) + "), which is a known subclass of the solution class (" + String.valueOf(solutionDescriptor.getSolutionClass()) + ").", e);
                }
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            solutionSubclassSet.add(solutionDescriptor.getSolutionClass());
            HashMap memoizedGizmoSolutionOrEntityDescriptorForClassMap = new HashMap();
            for (Class solutionSubclass : solutionSubclassSet) {
                this.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, solutionSubclass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            for (Object entityClass : solutionDescriptor.getEntityClassSet()) {
                this.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, (Class)entityClass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            HashSet solutionAndEntitySubclassSet = new HashSet(solutionSubclassSet);
            for (Object entityClassObject : solutionDescriptor.getEntityClassSet()) {
                Class entityClass = (Class)entityClassObject;
                Collection classInfoCollection = entityClass.isInterface() ? indexView.getAllKnownImplementors(DotName.createSimple((String)entityClass.getName())) : indexView.getAllKnownSubclasses(DotName.createSimple((String)entityClass.getName()));
                classInfoCollection.stream().map(classInfo -> {
                    try {
                        return Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to find class (" + String.valueOf(classInfo.name()) + "), which is a known subclass of the entity class (" + String.valueOf(entityClass) + ").", e);
                    }
                }).forEach(solutionAndEntitySubclassSet::add);
            }
            Set deepClonedClassSet = GizmoCloningUtils.getDeepClonedClasses((SolutionDescriptor)solutionDescriptor, solutionAndEntitySubclassSet);
            for (Class deepCloningClass : deepClonedClassSet) {
                this.makeConstructorAccessible(deepCloningClass, transformers);
                if (memoizedGizmoSolutionOrEntityDescriptorForClassMap.containsKey(deepCloningClass)) continue;
                this.getGizmoSolutionOrEntityDescriptorForEntity(solutionDescriptor, deepCloningClass, memoizedGizmoSolutionOrEntityDescriptorForClassMap, transformers);
            }
            GizmoSolutionClonerImplementor.defineClonerFor(QuarkusGizmoSolutionClonerImplementor::new, (ClassCreator)classCreator, (SolutionDescriptor)solutionDescriptor, (Set)solutionSubclassSet, memoizedGizmoSolutionOrEntityDescriptorForClassMap, (Set)deepClonedClassSet);
        }
        return generatedClassName;
    }

    private void makeConstructorAccessible(Class<?> clazz, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        try {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                return;
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers()) && !this.visitedClasses.contains(clazz)) {
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(clazz.getName(), (className, classVisitor) -> new TimefoldConstructorEnhancingClassVisitor((ClassVisitor)classVisitor)));
                this.visitedClasses.add(clazz);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Class (" + clazz.getName() + ") must have a no-args constructor so it can be constructed by Timefold.");
        }
    }

    private GizmoSolutionOrEntityDescriptor getGizmoSolutionOrEntityDescriptorForEntity(SolutionDescriptor solutionDescriptor, Class<?> entityClass, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedMap, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        HashMap<Field, GizmoMemberDescriptor> solutionFieldToMemberDescriptor = new HashMap<Field, GizmoMemberDescriptor>();
        for (Class<?> currentClass = entityClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                solutionFieldToMemberDescriptor.put(field, this.createMemberDescriptorForField(field, transformers));
            }
        }
        GizmoSolutionOrEntityDescriptor out = new GizmoSolutionOrEntityDescriptor(solutionDescriptor, entityClass, solutionFieldToMemberDescriptor);
        memoizedMap.put(entityClass, out);
        return out;
    }

    private GizmoMemberDescriptor createMemberDescriptorForField(Field field, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (Modifier.isFinal(field.getModifiers())) {
            this.makeFieldNonFinal(field, transformers);
        }
        Class<?> declaringClass = field.getDeclaringClass();
        FieldDescriptor memberDescriptor = FieldDescriptor.of((Field)field);
        String name = field.getName();
        if (Modifier.isPublic(field.getModifiers())) {
            return new GizmoMemberDescriptor(name, memberDescriptor, declaringClass);
        }
        this.addVirtualFieldGetter(declaringClass, field, transformers);
        String getterName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(true, name);
        MethodDescriptor getterDescriptor = MethodDescriptor.ofMethod((Object)declaringClass.getName(), (String)getterName, field.getType(), (Object[])new Object[0]);
        String setterName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(true, name);
        MethodDescriptor setterDescriptor = MethodDescriptor.ofMethod((Object)declaringClass.getName(), (String)setterName, (Object)"void", (Object[])new Object[]{field.getType()});
        return new GizmoMemberDescriptor(name, getterDescriptor, memberDescriptor, declaringClass, setterDescriptor);
    }

    public static Map<String, RuntimeValue<MemberAccessor>> getGeneratedGizmoMemberAccessorMap(RecorderContext recorderContext, Set<String> generatedMemberAccessorsClassNames) {
        HashMap<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorNameToInstanceMap = new HashMap<String, RuntimeValue<MemberAccessor>>();
        for (String className : generatedMemberAccessorsClassNames) {
            generatedGizmoMemberAccessorNameToInstanceMap.put(className, (RuntimeValue<MemberAccessor>)recorderContext.newInstance(className));
        }
        return generatedGizmoMemberAccessorNameToInstanceMap;
    }

    public static Map<String, RuntimeValue<SolutionCloner>> getGeneratedSolutionClonerMap(RecorderContext recorderContext, Set<String> generatedSolutionClonersClassNames) {
        HashMap<String, RuntimeValue<SolutionCloner>> generatedGizmoSolutionClonerNameToInstanceMap = new HashMap<String, RuntimeValue<SolutionCloner>>();
        for (String className : generatedSolutionClonersClassNames) {
            generatedGizmoSolutionClonerNameToInstanceMap.put(className, (RuntimeValue<SolutionCloner>)recorderContext.newInstance(className));
        }
        return generatedGizmoSolutionClonerNameToInstanceMap;
    }

    public String generateGizmoBeanFactory(ClassOutput classOutput, Set<Class<?>> beanClasses, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        String generatedClassName = TimefoldGizmoBeanFactory.class.getName() + "$Implementation";
        ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{TimefoldGizmoBeanFactory.class}).classOutput(classOutput).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod(TimefoldGizmoBeanFactory.class, (String)"newInstance", Object.class, (Class[])new Class[]{Class.class}));
        ResultHandle query = methodCreator.getMethodParam(0);
        MethodCreator currentBranch = methodCreator;
        for (Class<?> beanClass : beanClasses) {
            if (beanClass.isInterface() || Modifier.isAbstract(beanClass.getModifiers())) continue;
            this.makeConstructorAccessible(beanClass, transformers);
            ResultHandle beanClassHandle = currentBranch.loadClass(beanClass);
            ResultHandle isTarget = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class}), beanClassHandle, new ResultHandle[]{query});
            BranchResult isQueryBranchResult = currentBranch.ifTrue(isTarget);
            BytecodeCreator isQueryBranch = isQueryBranchResult.trueBranch();
            ResultHandle beanInstance = isQueryBranch.newInstance(MethodDescriptor.ofConstructor(beanClass, (Class[])new Class[0]), new ResultHandle[0]);
            isQueryBranch.returnValue(beanInstance);
            currentBranch = isQueryBranchResult.falseBranch();
        }
        currentBranch.returnValue(currentBranch.loadNull());
        classCreator.close();
        return generatedClassName;
    }

    private static class TimefoldConstructorEnhancingClassVisitor
    extends ClassVisitor {
        public TimefoldConstructorEnhancingClassVisitor(ClassVisitor outputClassVisitor) {
            super(589824, outputClassVisitor);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("<init>")) {
                return this.cv.visitMethod(1, name, desc, signature, exceptions);
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    private static class TimefoldMethodEnhancingClassVisitor
    extends ClassVisitor {
        private final MethodInfo methodInfo;
        private final Class<?> clazz;
        private final String returnTypeDescriptor;
        private final MethodDescriptor setter;
        private final String name;

        public TimefoldMethodEnhancingClassVisitor(ClassInfo classInfo, ClassVisitor outputClassVisitor, MethodInfo methodInfo, String name, Optional<MethodDescriptor> maybeSetter) {
            super(589824, outputClassVisitor);
            this.methodInfo = methodInfo;
            this.name = name;
            this.setter = maybeSetter.orElse(null);
            try {
                this.clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                this.returnTypeDescriptor = DescriptorUtils.typeToString((org.jboss.jandex.Type)methodInfo.returnType());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            if (this.setter != null) {
                this.addSetter(this.cv);
            }
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(false, this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.returnTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, Type.getInternalName(this.clazz), this.methodInfo.name(), "()" + this.returnTypeDescriptor, false);
            mv.visitInsn(Type.getType((String)this.returnTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }

        private void addSetter(ClassVisitor classWriter) {
            if (this.setter == null) {
                return;
            }
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(false, this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, this.setter.getDescriptor(), null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, Type.getInternalName(this.clazz), this.setter.getName(), this.setter.getDescriptor(), false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }
    }

    private static class TimefoldFinalFieldEnhancingClassVisitor
    extends ClassVisitor {
        final Field finalField;

        public TimefoldFinalFieldEnhancingClassVisitor(ClassVisitor outputClassVisitor, Field finalField) {
            super(589824, outputClassVisitor);
            this.finalField = finalField;
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (name.equals(this.finalField.getName())) {
                return super.visitField(access & 0xFFFFFFEF, name, descriptor, signature, value);
            }
            return super.visitField(access, name, descriptor, signature, value);
        }
    }

    private static class TimefoldFieldEnhancingClassVisitor
    extends ClassVisitor {
        private final Field fieldInfo;
        private final Class<?> clazz;
        private final String fieldTypeDescriptor;

        public TimefoldFieldEnhancingClassVisitor(Class<?> classInfo, ClassVisitor outputClassVisitor, Field fieldInfo) {
            super(589824, outputClassVisitor);
            this.fieldInfo = fieldInfo;
            this.clazz = classInfo;
            this.fieldTypeDescriptor = Type.getDescriptor(fieldInfo.getType());
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            this.addSetter(this.cv);
        }

        private void addSetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(true, this.fieldInfo.getName());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "(" + this.fieldTypeDescriptor + ")V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(Type.getType((String)this.fieldTypeDescriptor).getOpcode(21), 1);
            mv.visitFieldInsn(181, Type.getInternalName(this.clazz), this.fieldInfo.getName(), this.fieldTypeDescriptor);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(true, this.fieldInfo.getName());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.fieldTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, Type.getInternalName(this.clazz), this.fieldInfo.getName(), this.fieldTypeDescriptor);
            mv.visitInsn(Type.getType((String)this.fieldTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }
    }
}

