/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.config.solver.SolverManagerConfig;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.quarkus.config.SolverRuntimeConfig;
import ai.timefold.solver.quarkus.config.TimefoldRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

@Recorder
public class TimefoldRecorder {
    public Supplier<SolverConfig> solverConfigSupplier(String solverName, SolverConfig solverConfig, TimefoldRuntimeConfig timefoldRuntimeConfig, Map<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorMap, Map<String, RuntimeValue<SolutionCloner>> generatedGizmoSolutionClonerMap) {
        return () -> {
            this.updateSolverConfigWithRuntimeProperties(solverName, solverConfig, timefoldRuntimeConfig);
            HashMap memberAccessorMap = new HashMap();
            HashMap solutionClonerMap = new HashMap();
            generatedGizmoMemberAccessorMap.forEach((className, runtimeValue) -> memberAccessorMap.put(className, (MemberAccessor)runtimeValue.getValue()));
            generatedGizmoSolutionClonerMap.forEach((className, runtimeValue) -> solutionClonerMap.put(className, (SolutionCloner)runtimeValue.getValue()));
            solverConfig.setGizmoMemberAccessorMap(memberAccessorMap);
            solverConfig.setGizmoSolutionClonerMap(solutionClonerMap);
            return solverConfig;
        };
    }

    public Supplier<SolverManagerConfig> solverManagerConfig(SolverManagerConfig solverManagerConfig, TimefoldRuntimeConfig timefoldRuntimeConfig) {
        return () -> {
            this.updateSolverManagerConfigWithRuntimeProperties(solverManagerConfig, timefoldRuntimeConfig);
            return solverManagerConfig;
        };
    }

    public <Solution_, ProblemId_> Supplier<SolverManager<Solution_, ProblemId_>> solverManager(String solverName, SolverConfig solverConfig, TimefoldRuntimeConfig timefoldRuntimeConfig, Map<String, RuntimeValue<MemberAccessor>> generatedGizmoMemberAccessorMap, Map<String, RuntimeValue<SolutionCloner>> generatedGizmoSolutionClonerMap) {
        return () -> {
            this.updateSolverConfigWithRuntimeProperties(solverName, solverConfig, timefoldRuntimeConfig);
            HashMap memberAccessorMap = new HashMap();
            HashMap solutionClonerMap = new HashMap();
            generatedGizmoMemberAccessorMap.forEach((className, runtimeValue) -> memberAccessorMap.put(className, (MemberAccessor)runtimeValue.getValue()));
            generatedGizmoSolutionClonerMap.forEach((className, runtimeValue) -> solutionClonerMap.put(className, (SolutionCloner)runtimeValue.getValue()));
            solverConfig.setGizmoMemberAccessorMap(memberAccessorMap);
            solverConfig.setGizmoSolutionClonerMap(solutionClonerMap);
            SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
            this.updateSolverManagerConfigWithRuntimeProperties(solverManagerConfig, timefoldRuntimeConfig);
            SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
            return SolverManager.create((SolverFactory)solverFactory, (SolverManagerConfig)solverManagerConfig);
        };
    }

    private void updateSolverConfigWithRuntimeProperties(String solverName, SolverConfig solverConfig, TimefoldRuntimeConfig timefoldRunTimeConfig) {
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        timefoldRunTimeConfig.getSolverRuntimeConfig(solverName).flatMap(config -> config.termination().spentLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
        timefoldRunTimeConfig.getSolverRuntimeConfig(solverName).flatMap(config -> config.termination().unimprovedSpentLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
        timefoldRunTimeConfig.getSolverRuntimeConfig(solverName).flatMap(config -> config.termination().bestScoreLimit()).ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
        timefoldRunTimeConfig.getSolverRuntimeConfig(solverName).flatMap(SolverRuntimeConfig::moveThreadCount).ifPresent(arg_0 -> ((SolverConfig)solverConfig).setMoveThreadCount(arg_0));
    }

    private void updateSolverManagerConfigWithRuntimeProperties(SolverManagerConfig solverManagerConfig, TimefoldRuntimeConfig timefoldRunTimeConfig) {
        timefoldRunTimeConfig.solverManager().parallelSolverCount().ifPresent(arg_0 -> ((SolverManagerConfig)solverManagerConfig).setParallelSolverCount(arg_0));
    }
}

