/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.devui;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.quarkus.devui.DevUISolverConfig;
import ai.timefold.solver.quarkus.devui.TimefoldDevUIProperties;
import ai.timefold.solver.quarkus.devui.TimefoldModelProperties;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ApplicationScoped
public class TimefoldDevUIPropertiesRPCService {
    private final DevUISolverConfig devUISolverConfig;
    private final Map<String, TimefoldDevUIProperties> devUIProperties;

    @Inject
    public TimefoldDevUIPropertiesRPCService(DevUISolverConfig devUISolverConfig) {
        this.devUISolverConfig = devUISolverConfig;
        this.devUIProperties = new HashMap<String, TimefoldDevUIProperties>();
    }

    @PostConstruct
    public void init() {
        if (this.devUISolverConfig != null && !this.devUISolverConfig.isEmpty()) {
            this.devUISolverConfig.getSolverNames().forEach(key -> this.devUIProperties.put((String)key, new TimefoldDevUIProperties(this.buildModelInfo(this.devUISolverConfig.getFactory((String)key)), this.buildXmlContentWithComment(this.devUISolverConfig.getSolverConfigFile((String)key), "Properties that can be set at runtime are not included"), this.buildConstraintList(this.devUISolverConfig.getFactory((String)key)))));
        } else {
            this.devUIProperties.put("default", new TimefoldDevUIProperties(this.buildModelInfo(null), "<!-- Plugin execution was skipped because there are no @" + PlanningSolution.class.getSimpleName() + " or @" + PlanningEntity.class.getSimpleName() + " annotated classes. -->\n<solver />", Collections.emptyList()));
        }
    }

    public JsonObject getConfig() {
        JsonObject out = new JsonObject();
        JsonObject config = new JsonObject();
        out.put("config", (Object)config);
        this.devUIProperties.forEach((key, value) -> config.put(key, (Object)value.getEffectiveSolverConfig()));
        return out;
    }

    public JsonObject getConstraints() {
        JsonObject out = new JsonObject();
        this.devUIProperties.forEach((key, value) -> out.put(key, (Object)JsonArray.of((Object[])value.getConstraintList().stream().map(ConstraintRef::constraintId).toArray())));
        return out;
    }

    public JsonObject getModelInfo() {
        JsonObject out = new JsonObject();
        this.devUIProperties.forEach((key, value) -> {
            JsonObject property = new JsonObject();
            TimefoldModelProperties modelProperties = value.getTimefoldModelProperties();
            property.put("solutionClass", (Object)modelProperties.solutionClass);
            property.put("entityClassList", (Object)JsonArray.of((Object[])modelProperties.entityClassList.toArray()));
            property.put("entityClassToGenuineVariableListMap", (Object)new JsonObject(modelProperties.entityClassToGenuineVariableListMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonArray.of((Object[])((List)entry.getValue()).toArray())))));
            property.put("entityClassToShadowVariableListMap", (Object)new JsonObject(modelProperties.entityClassToShadowVariableListMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonArray.of((Object[])((List)entry.getValue()).toArray())))));
            out.put(key, (Object)property);
        });
        return out;
    }

    private TimefoldModelProperties buildModelInfo(SolverFactory<?> solverFactory) {
        if (solverFactory != null) {
            SolutionDescriptor solutionDescriptor = ((DefaultSolverFactory)solverFactory).getScoreDirectorFactory().getSolutionDescriptor();
            TimefoldModelProperties out = new TimefoldModelProperties();
            out.setSolutionClass(solutionDescriptor.getSolutionClass().getName());
            ArrayList<String> entityClassList = new ArrayList<String>();
            HashMap<String, List<String>> entityClassToGenuineVariableListMap = new HashMap<String, List<String>>();
            HashMap<String, List<String>> entityClassToShadowVariableListMap = new HashMap<String, List<String>>();
            for (EntityDescriptor entityDescriptor : solutionDescriptor.getEntityDescriptors()) {
                entityClassList.add(entityDescriptor.getEntityClass().getName());
                ArrayList<String> entityClassToGenuineVariableList = new ArrayList<String>();
                ArrayList<String> entityClassToShadowVariableList = new ArrayList<String>();
                for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                    if (variableDescriptor instanceof GenuineVariableDescriptor) {
                        entityClassToGenuineVariableList.add(variableDescriptor.getVariableName());
                        continue;
                    }
                    entityClassToShadowVariableList.add(variableDescriptor.getVariableName());
                }
                entityClassToGenuineVariableListMap.put(entityDescriptor.getEntityClass().getName(), entityClassToGenuineVariableList);
                entityClassToShadowVariableListMap.put(entityDescriptor.getEntityClass().getName(), entityClassToShadowVariableList);
            }
            out.setEntityClassList(entityClassList);
            out.setEntityClassToGenuineVariableListMap(entityClassToGenuineVariableListMap);
            out.setEntityClassToShadowVariableListMap(entityClassToShadowVariableListMap);
            return out;
        }
        return new TimefoldModelProperties();
    }

    private List<ConstraintRef> buildConstraintList(SolverFactory<?> solverFactory) {
        InnerScoreDirectorFactory scoreDirectorFactory;
        if (solverFactory != null && (scoreDirectorFactory = ((DefaultSolverFactory)solverFactory).getScoreDirectorFactory()) instanceof AbstractConstraintStreamScoreDirectorFactory) {
            AbstractConstraintStreamScoreDirectorFactory castScoreDirectorFactory = (AbstractConstraintStreamScoreDirectorFactory)scoreDirectorFactory;
            return castScoreDirectorFactory.getConstraintMetaModel().getConstraints().stream().map(Constraint::getConstraintRef).toList();
        }
        return Collections.emptyList();
    }

    private String buildXmlContentWithComment(String effectiveSolverConfigXml, String comment) {
        int indexOfPreambleEnd = effectiveSolverConfigXml.indexOf("?>");
        if (indexOfPreambleEnd != -1) {
            return effectiveSolverConfigXml.substring(0, indexOfPreambleEnd + 2) + "\n<!--" + comment + "-->\n" + effectiveSolverConfigXml.substring(indexOfPreambleEnd + 2);
        }
        return "<!--" + comment + "-->\n" + effectiveSolverConfigXml;
    }
}

