/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.quarkus.bean;

import ai.timefold.solver.core.api.score.stream.ConstraintMetaModel;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import java.util.Objects;

public class BeanUtil {
    public static ConstraintMetaModel buildConstraintMetaModel(SolverFactory<?> solverFactory) {
        SolverFactory<?> solverFactory2 = Objects.requireNonNull(solverFactory);
        if (solverFactory2 instanceof DefaultSolverFactory) {
            DefaultSolverFactory defaultSolverFactory = (DefaultSolverFactory)solverFactory2;
            InnerScoreDirectorFactory scoreDirectorFactory = defaultSolverFactory.getScoreDirectorFactory();
            if (scoreDirectorFactory instanceof AbstractConstraintStreamScoreDirectorFactory) {
                AbstractConstraintStreamScoreDirectorFactory castScoreDirectorFactory = (AbstractConstraintStreamScoreDirectorFactory)scoreDirectorFactory;
                return castScoreDirectorFactory.getConstraintMetaModel();
            }
            throw new IllegalStateException("Cannot provide %s because the score director does not use the Constraint Streams API.".formatted(ConstraintMetaModel.class.getSimpleName()));
        }
        throw new IllegalStateException("%s is not supported by the solver factory (%s).".formatted(ConstraintMetaModel.class.getSimpleName(), solverFactory.getClass().getName()));
    }

    private BeanUtil() {
        throw new IllegalStateException("Utility class");
    }
}

