/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.spring.boot.autoconfigure;

import ai.timefold.solver.benchmark.api.PlannerBenchmarkFactory;
import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import ai.timefold.solver.benchmark.config.SolverBenchmarkConfig;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.spring.boot.autoconfigure.TimefoldAutoConfiguration;
import ai.timefold.solver.spring.boot.autoconfigure.config.TimefoldProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={TimefoldAutoConfiguration.class})
@ConditionalOnClass(value={PlannerBenchmarkFactory.class})
@ConditionalOnMissingBean(value={PlannerBenchmarkFactory.class})
@EnableConfigurationProperties(value={TimefoldProperties.class})
public class TimefoldBenchmarkAutoConfiguration
implements BeanClassLoaderAware {
    private final TimefoldProperties timefoldProperties;
    private ClassLoader beanClassLoader;

    protected TimefoldBenchmarkAutoConfiguration(TimefoldProperties timefoldProperties) {
        this.timefoldProperties = timefoldProperties;
    }

    @Bean
    public PlannerBenchmarkConfig plannerBenchmarkConfig(SolverConfig solverConfig) {
        PlannerBenchmarkConfig benchmarkConfig;
        if (solverConfig == null) {
            return null;
        }
        if (this.timefoldProperties.getBenchmark() != null && this.timefoldProperties.getBenchmark().getSolverBenchmarkConfigXml() != null) {
            if (this.beanClassLoader.getResource(this.timefoldProperties.getBenchmark().getSolverBenchmarkConfigXml()) == null) {
                throw new IllegalStateException("Invalid timefold.benchmark.solverBenchmarkConfigXml property (" + this.timefoldProperties.getBenchmark().getSolverBenchmarkConfigXml() + "): that classpath resource does not exist.");
            }
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)this.timefoldProperties.getBenchmark().getSolverBenchmarkConfigXml(), (ClassLoader)this.beanClassLoader);
        } else if (this.beanClassLoader.getResource("solverBenchmarkConfig.xml") != null) {
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)"solverBenchmarkConfig.xml", (ClassLoader)this.beanClassLoader);
        } else {
            benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig);
            benchmarkConfig.setBenchmarkDirectory(new File("target/benchmarks"));
        }
        if (this.timefoldProperties.getBenchmark() != null && this.timefoldProperties.getBenchmark().getResultDirectory() != null) {
            benchmarkConfig.setBenchmarkDirectory(new File(this.timefoldProperties.getBenchmark().getResultDirectory()));
        }
        if (benchmarkConfig.getBenchmarkDirectory() == null) {
            benchmarkConfig.setBenchmarkDirectory(new File("target/benchmarks"));
        }
        if (this.timefoldProperties.getBenchmark() != null && this.timefoldProperties.getBenchmark().getSolver() != null) {
            TimefoldAutoConfiguration.applyTerminationProperties(benchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig(), this.timefoldProperties.getBenchmark().getSolver().getTermination());
        }
        if (benchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig().getTerminationConfig() == null || !benchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig().getTerminationConfig().isConfigured()) {
            List solverBenchmarkConfigList = benchmarkConfig.getSolverBenchmarkConfigList();
            ArrayList<String> unconfiguredTerminationSolverBenchmarkList = new ArrayList<String>();
            if (solverBenchmarkConfigList == null) {
                throw new IllegalStateException("At least one of the properties timefold.benchmark.solver.termination.spent-limit, timefold.benchmark.solver.termination.best-score-limit, timefold.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in the inherited solver benchmark config and solverBenchmarkBluePrint is used.");
            }
            if (solverBenchmarkConfigList.size() == 1 && ((SolverBenchmarkConfig)solverBenchmarkConfigList.get(0)).getSolverConfig() == null) {
                SolverBenchmarkConfig solverBenchmarkConfig = benchmarkConfig.getInheritedSolverBenchmarkConfig();
                if (!solverBenchmarkConfig.getSolverConfig().canTerminate()) {
                    String benchmarkConfigName = Objects.requireNonNullElse(solverBenchmarkConfig.getName(), "InheritedSolverBenchmarkConfig");
                    unconfiguredTerminationSolverBenchmarkList.add(benchmarkConfigName);
                }
            } else {
                for (int i = 0; i < solverBenchmarkConfigList.size(); ++i) {
                    SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)solverBenchmarkConfigList.get(i);
                    if (solverConfig.canTerminate()) continue;
                    String benchmarkConfigName = (String)((Object)Objects.requireNonNullElse(solverBenchmarkConfig.getName(), "SolverBenchmarkConfig" + i));
                    unconfiguredTerminationSolverBenchmarkList.add(benchmarkConfigName);
                }
            }
            if (!unconfiguredTerminationSolverBenchmarkList.isEmpty()) {
                throw new IllegalStateException("The following " + SolverBenchmarkConfig.class.getSimpleName() + " do not have termination configured: " + unconfiguredTerminationSolverBenchmarkList.stream().collect(Collectors.joining(", ", "[", "]")) + ". At least one of the properties timefold.benchmark.solver.termination.spent-limit, timefold.benchmark.solver.termination.best-score-limit, timefold.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in a solver benchmark and the inherited solver benchmark config.");
            }
        }
        return benchmarkConfig;
    }

    @Bean
    public PlannerBenchmarkFactory plannerBenchmarkFactory(PlannerBenchmarkConfig benchmarkConfig) {
        if (benchmarkConfig == null) {
            return null;
        }
        return PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

