/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.test.impl.score.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintFactory;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.score.stream.ConstraintStreamImplType;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.test.impl.score.stream.DefaultMultiConstraintVerification;
import ai.timefold.solver.test.impl.score.stream.DefaultSingleConstraintVerification;
import ai.timefold.solver.test.impl.score.stream.ScoreDirectorFactoryCache;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;

final class ConfiguredConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_, Score_ extends Score<Score_>> {
    private final ConstraintRef defaultScoreDirectorFactoryMapKey = ConstraintRef.of((String)UUID.randomUUID().toString(), (String)UUID.randomUUID().toString());
    private final ConstraintProvider_ constraintProvider;
    private final ThreadLocal<ScoreDirectorFactoryCache<ConstraintProvider_, Solution_, Score_>> scoreDirectorFactoryContainerThreadLocal;
    private final ConstraintStreamImplType constraintStreamImplType;

    public ConfiguredConstraintVerifier(ConstraintProvider_ constraintProvider, SolutionDescriptor<Solution_> solutionDescriptor, ConstraintStreamImplType constraintStreamImplType) {
        this.constraintProvider = constraintProvider;
        this.scoreDirectorFactoryContainerThreadLocal = ThreadLocal.withInitial(() -> new ScoreDirectorFactoryCache(solutionDescriptor));
        this.constraintStreamImplType = constraintStreamImplType;
    }

    public ConstraintStreamImplType getConstraintStreamImplType() {
        return this.constraintStreamImplType;
    }

    public DefaultSingleConstraintVerification<Solution_, Score_> verifyThat(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        Objects.requireNonNull(constraintFunction);
        AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.scoreDirectorFactoryContainerThreadLocal.get().getScoreDirectorFactory(constraintFunction, this.constraintProvider, EnvironmentMode.FULL_ASSERT);
        return new DefaultSingleConstraintVerification<Solution_, Score_>(scoreDirectorFactory);
    }

    public DefaultMultiConstraintVerification<Solution_, Score_> verifyThat() {
        AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.scoreDirectorFactoryContainerThreadLocal.get().getScoreDirectorFactory(this.defaultScoreDirectorFactoryMapKey, (ConstraintProvider)this.constraintProvider, EnvironmentMode.FULL_ASSERT);
        return new DefaultMultiConstraintVerification<Solution_, Score_>(scoreDirectorFactory, (ConstraintProvider)this.constraintProvider);
    }
}

